/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.container.managed;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.context.annotation.ContainerScoped;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.as.arquillian.container.CommonContainerConfiguration;
import org.jboss.as.arquillian.container.CommonManagedDeployableContainer;
import org.jboss.as.arquillian.container.ParameterUtils;
import org.jboss.as.arquillian.container.managed.AppClientWrapper;
import org.jboss.as.arquillian.container.managed.ManagedContainerConfiguration;
import org.jboss.logging.Logger;
import org.wildfly.core.launcher.CommandBuilder;
import org.wildfly.core.launcher.StandaloneCommandBuilder;

public final class ManagedDeployableContainer
extends CommonManagedDeployableContainer<ManagedContainerConfiguration> {
    private static final Pattern WHITESPACE_OR_COMMA_DELIMITED = Pattern.compile("(\\s+|,)(?=(?:[^\"]*\"[^\"]*\")*[^\"]*$)");
    static final String TEMP_CONTAINER_DIRECTORY = "arquillian-temp-container";
    static final String CONFIG_DIR = "configuration";
    static final String DATA_DIR = "data";
    private final Logger log = Logger.getLogger(ManagedDeployableContainer.class);
    @Inject
    @ContainerScoped
    private InstanceProducer<AppClientWrapper> appClientWrapperProducer;
    private AppClientWrapper appClient;

    public Class<ManagedContainerConfiguration> getConfigurationClass() {
        return ManagedContainerConfiguration.class;
    }

    protected CommandBuilder createCommandBuilder(ManagedContainerConfiguration config) {
        String moduleOptions;
        String bundlesPath;
        StandaloneCommandBuilder commandBuilder = StandaloneCommandBuilder.of((String)config.getJbossHome());
        String modulesPath = config.getModulePath();
        if (modulesPath != null && !modulesPath.isEmpty()) {
            commandBuilder.setModuleDirs(modulesPath.split(Pattern.quote(File.pathSeparator)));
        }
        if ((bundlesPath = config.getBundlePath()) != null && !bundlesPath.isEmpty()) {
            this.getLogger().warn((Object)"Bundles path is deprecated and no longer used.");
        }
        String javaOpts = config.getJavaVmArguments();
        String jbossArguments = config.getJbossArguments();
        commandBuilder.setJavaHome(config.getJavaHome());
        if (javaOpts != null && !javaOpts.trim().isEmpty()) {
            commandBuilder.setJavaOptions((Iterable)ParameterUtils.splitParams((String)javaOpts));
        }
        if ((moduleOptions = config.getModuleOptions()) != null && !moduleOptions.isBlank()) {
            commandBuilder.setModuleOptions((Iterable)ParameterUtils.splitParams((String)moduleOptions));
        }
        if (config.isEnableAssertions()) {
            commandBuilder.addJavaOption("-ea");
        }
        if (config.isAdminOnly()) {
            commandBuilder.setAdminOnly();
        }
        if (jbossArguments != null && !jbossArguments.trim().isEmpty()) {
            commandBuilder.addServerArguments((Iterable)ParameterUtils.splitParams((String)jbossArguments));
        }
        if (config.getServerConfig() != null) {
            commandBuilder.setServerConfiguration(config.getServerConfig());
        } else if (config.getReadOnlyServerConfig() != null) {
            commandBuilder.setServerReadOnlyConfiguration(config.getReadOnlyServerConfig());
        }
        if (config.getYamlConfiguration() != null) {
            commandBuilder.setYamlFiles(this.findSupplementalConfigurationFiles(commandBuilder.getConfigurationDirectory(), config.getYamlConfiguration()));
        }
        if (config.isSetupCleanServerBaseDir() || config.getCleanServerBaseDir() != null) {
            try {
                this.setupCleanServerDirectories(commandBuilder, config.getCleanServerBaseDir());
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to setup the clean server directory.", e);
            }
        }
        if (config.isDebug()) {
            commandBuilder.setDebug(config.isDebugSuspend(), config.getDebugPort());
        }
        commandBuilder.addJavaOption("-Djboss.home.dir=" + commandBuilder.getWildFlyHome());
        return commandBuilder;
    }

    public void setup(ManagedContainerConfiguration config) {
        super.setup((CommonContainerConfiguration)config);
        if (config.getClientAppEar() != null) {
            this.appClient = new AppClientWrapper(config, this.getLogger());
            this.appClientWrapperProducer.set((Object)this.appClient);
        }
    }

    protected void startInternal() throws LifecycleException {
        super.startInternal();
        if (this.appClient != null) {
            try {
                if (((ManagedContainerConfiguration)this.getContainerConfiguration()).isRunClient()) {
                    this.appClient.run();
                }
            }
            catch (Exception e) {
                throw new LifecycleException(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected void stopInternal(Integer timeout) throws LifecycleException {
        super.stopInternal(timeout);
        try {
            if (this.appClient != null) {
                this.appClient.close();
                this.appClient = null;
            }
        }
        catch (Exception e) {
            throw new LifecycleException(e.getMessage(), (Throwable)e);
        }
    }

    private Path[] findSupplementalConfigurationFiles(Path serverConfigurationDirPath, String yaml) {
        ArrayList<Path> yamlFiles = new ArrayList<Path>();
        for (String yamlFile : WHITESPACE_OR_COMMA_DELIMITED.split(yaml)) {
            Path path = Path.of(yamlFile, new String[0]);
            if (path.isAbsolute()) {
                yamlFiles.add(path);
                continue;
            }
            yamlFiles.add(serverConfigurationDirPath.resolve(path));
        }
        ArrayList<Path> invalidPaths = new ArrayList<Path>();
        for (Path yamlFile : yamlFiles) {
            if (!Files.notExists(yamlFile, new LinkOption[0])) continue;
            invalidPaths.add(yamlFile);
        }
        if (!invalidPaths.isEmpty()) {
            throw new IllegalStateException(String.format("Invalid YAML paths found in %s: %s", yaml, invalidPaths));
        }
        return yamlFiles.toArray(new Path[0]);
    }

    protected Logger getLogger() {
        return this.log;
    }

    private void setupCleanServerDirectories(StandaloneCommandBuilder commandBuilder, String cleanServerBaseDirPath) throws IOException {
        Path cleanBase;
        if (cleanServerBaseDirPath != null) {
            cleanBase = Paths.get(cleanServerBaseDirPath, new String[0]);
            if (Files.exists(cleanBase, new LinkOption[0]) && !ManagedDeployableContainer.deleteDir(cleanBase)) {
                this.log.warnf("Clean directory %s was not empty when copied. Previous data will be lost.", (Object)cleanBase);
            }
            Files.createDirectories(cleanBase, new FileAttribute[0]);
        } else {
            cleanBase = Files.createTempDirectory(TEMP_CONTAINER_DIRECTORY, new FileAttribute[0]);
        }
        if (Files.notExists(cleanBase, new LinkOption[0])) {
            throw new IllegalStateException(String.format("Base directory %s does not exist.", cleanBase));
        }
        if (!Files.isDirectory(cleanBase, new LinkOption[0])) {
            throw new IllegalStateException(String.format("Base directory %s is not a directory.", cleanBase));
        }
        Path currentConfigDir = commandBuilder.getConfigurationDirectory();
        Path configDir = cleanBase.resolve(CONFIG_DIR);
        ManagedDeployableContainer.copyDir(currentConfigDir, configDir);
        Path currentDataDir = commandBuilder.getBaseDirectory().resolve(DATA_DIR);
        if (Files.exists(currentDataDir, new LinkOption[0])) {
            ManagedDeployableContainer.copyDir(currentDataDir, cleanBase.resolve(DATA_DIR));
        }
        commandBuilder.setBaseDirectory(cleanBase);
        commandBuilder.setConfigurationDirectory(configDir);
    }

    private static void copyDir(final Path from, final Path to) throws IOException {
        Files.walkFileTree(from, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                Files.copy(dir, to.resolve(from.relativize(dir)), new CopyOption[0]);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.copy(file, to.resolve(from.relativize(file)), new CopyOption[0]);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private static boolean deleteDir(final Path toDelete) throws IOException {
        final AtomicBoolean empty = new AtomicBoolean(true);
        Files.walkFileTree(toDelete, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                if (!dir.equals(toDelete)) {
                    empty.compareAndSet(true, false);
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                empty.compareAndSet(true, false);
                return FileVisitResult.CONTINUE;
            }
        });
        return empty.get();
    }
}

