/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.container.managed;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jboss.as.arquillian.container.ParameterUtils;
import org.jboss.as.arquillian.container.managed.ManagedContainerConfiguration;
import org.jboss.logging.Logger;
import org.wildfly.plugin.tools.server.ServerManager;

public class AppClientWrapper
implements AutoCloseable {
    private final BlockingQueue<String> outputQueue = new LinkedBlockingQueue<String>();
    private final ManagedContainerConfiguration config;
    private final Logger log;
    private final Lock lock;
    private Process process;
    private ExecutorService executorService;
    private Future<?> stdoutConsumer;
    private Future<?> stderrConsumer;

    protected AppClientWrapper(ManagedContainerConfiguration config, Logger log) {
        this.config = config;
        this.log = log;
        this.lock = new ReentrantLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForExit(long timeout, TimeUnit unit) throws InterruptedException {
        try {
            this.lock.lock();
            if (this.process != null) {
                try {
                    boolean b = this.process.waitFor(timeout, unit);
                    this.process = null;
                    boolean bl = b;
                    this.close();
                    return bl;
                }
                catch (Throwable throwable) {
                    this.close();
                    throw throwable;
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        this.log.warn((Object)"waitForExit was invoked before the process was started.");
        return false;
    }

    public List<String> readAll(long timeout) {
        ArrayList<String> lines = new ArrayList<String>();
        String line = null;
        do {
            try {
                line = this.outputQueue.poll(timeout, TimeUnit.MILLISECONDS);
                if (line == null) continue;
                lines.add(line);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (line != null);
        return List.copyOf(lines);
    }

    public void run() throws IOException {
        try {
            this.lock.lock();
            if (this.process == null) {
                this.process = new ProcessBuilder(this.getAppClientCommand()).start();
                this.executorService = Executors.newFixedThreadPool(2);
                this.stdoutConsumer = this.executorService.submit(new LogConsumer(this.outputQueue, this.process.getInputStream(), Logger.Level.INFO, this.process.pid()));
                this.stderrConsumer = this.executorService.submit(new LogConsumer(null, this.process.getErrorStream(), Logger.Level.ERROR, this.process.pid()));
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void close() {
        try {
            this.lock.lock();
            if (this.process != null) {
                this.process.destroy();
                try {
                    this.process.waitFor();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            this.stdoutConsumer.cancel(true);
            this.stderrConsumer.cancel(true);
            this.executorService.shutdownNow();
        }
        finally {
            this.lock.unlock();
        }
    }

    private List<String> getAppClientCommand() {
        ArrayList<String> cmd = new ArrayList<String>();
        String archivePath = this.config.getClientAppEar();
        String clientArchiveName = this.config.getClientArchiveName();
        String jbossHome = this.config.getJbossHome();
        if (jbossHome == null) {
            throw new IllegalArgumentException("jbossHome config property is not set.");
        }
        if (!ServerManager.isValidHomeDirectory((String)jbossHome)) {
            throw new IllegalArgumentException("Server directory from config jbossHome doesn't exist: " + jbossHome);
        }
        String archiveArg = String.format("%s#%s", archivePath, clientArchiveName);
        String client = this.config.resolveAppClientCommand();
        Path clientExe = Path.of(jbossHome, "bin", client);
        if (Files.notExists(clientExe, new LinkOption[0])) {
            throw new IllegalArgumentException("Could not find appclient executable " + clientExe);
        }
        cmd.add(clientExe.toString());
        cmd.add(archiveArg);
        if (this.config.getClientArguments() != null) {
            cmd.addAll(ParameterUtils.splitParams((String)this.config.getClientArguments()));
        }
        this.log.info((Object)("AppClient cmd: " + cmd));
        return cmd;
    }

    private class LogConsumer
    implements Runnable {
        private final BlockingQueue<String> queue;
        private final InputStreamReader reader;
        private final Logger.Level level;
        private final long pid;

        private LogConsumer(BlockingQueue<String> queue, InputStream in, Logger.Level level, long pid) {
            this.queue = queue;
            this.reader = new InputStreamReader(in, StandardCharsets.UTF_8);
            this.level = level;
            this.pid = pid;
        }

        @Override
        public void run() {
            StringBuilder buffer = new StringBuilder();
            char[] inBuffer = new char[256];
            try {
                int len;
                while ((len = this.reader.read(inBuffer)) != -1) {
                    int i;
                    int mark = 0;
                    for (i = 0; i < len; ++i) {
                        char c = inBuffer[i];
                        if (c != '\n') continue;
                        buffer.append(inBuffer, mark, i - mark);
                        AppClientWrapper.this.log.log(this.level, (Object)buffer.toString());
                        if (this.queue != null) {
                            this.queue.add(buffer.toString());
                        }
                        buffer.setLength(0);
                        mark = i + 1;
                    }
                    buffer.append(inBuffer, mark, i - mark);
                }
                if (buffer.length() > 0) {
                    AppClientWrapper.this.log.log(this.level, (Object)buffer.toString());
                    if (this.queue != null) {
                        this.queue.add(buffer.toString());
                    }
                }
            }
            catch (IOException e) {
                if (buffer.length() > 0) {
                    AppClientWrapper.this.log.errorf((Throwable)e, "Failed to consume output from %s: %s", (Object)this.pid, (Object)buffer.toString());
                    buffer.setLength(0);
                }
                AppClientWrapper.this.log.errorf((Throwable)e, "Failed to consume output from %s", (Object)this.pid);
            }
        }
    }
}

