package org.wildfly.common._private;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import java.security.PrivilegedActionException;
import java.lang.SecurityException;
import java.lang.String;
import java.io.IOException;
import org.wildfly.common.codec.DecodeException;
import java.lang.Exception;
import java.lang.NullPointerException;
import java.lang.Class;
import java.lang.Object;
import java.util.Arrays;
import java.lang.ArrayIndexOutOfBoundsException;
import java.lang.IllegalArgumentException;
import java.lang.UnsupportedOperationException;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageBundleImplementor", date = "2024-05-07T08:40:04-0500")
public class CommonMessages_$bundle implements CommonMessages, Serializable {
    private static final long serialVersionUID = 1L;
    protected CommonMessages_$bundle() {}
    public static final CommonMessages_$bundle INSTANCE = new CommonMessages_$bundle();
    protected Object readResolve() {
        return INSTANCE;
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String nullParam$str() {
        return "Parameter '%s' may not be null";
    }
    @Override
    public final IllegalArgumentException nullParam(final String paramName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), nullParam$str(), paramName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String paramLessThan$str() {
        return "COM00001: Parameter '%s' must not be less than %d";
    }
    @Override
    public final IllegalArgumentException paramLessThan(final String name, final long min) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), paramLessThan$str(), name, min));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final IllegalArgumentException paramLessThan(final String name, final double min) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), paramLessThan$str(), name, min));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String paramGreaterThan$str() {
        return "COM00002: Parameter '%s' must not be greater than than %d";
    }
    @Override
    public final IllegalArgumentException paramGreaterThan(final String name, final long max) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), paramGreaterThan$str(), name, max));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final IllegalArgumentException paramGreaterThan(final String name, final double max) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), paramGreaterThan$str(), name, max));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String arrayOffsetGreaterThanLength$str() {
        return "COM00003: Given offset of %d is greater than array length of %d";
    }
    @Override
    public final ArrayIndexOutOfBoundsException arrayOffsetGreaterThanLength(final int offs, final int arrayLength) {
        final ArrayIndexOutOfBoundsException result = new ArrayIndexOutOfBoundsException(String.format(getLoggingLocale(), arrayOffsetGreaterThanLength$str(), offs, arrayLength));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String arrayOffsetLengthGreaterThanLength$str() {
        return "COM00004: Given offset of %d plus length of %d is greater than array length of %d";
    }
    @Override
    public final ArrayIndexOutOfBoundsException arrayOffsetLengthGreaterThanLength(final int offs, final int len, final int arrayLength) {
        final ArrayIndexOutOfBoundsException result = new ArrayIndexOutOfBoundsException(String.format(getLoggingLocale(), arrayOffsetLengthGreaterThanLength$str(), offs, len, arrayLength));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nullArrayParam$str() {
        return "COM00005: Array index %d of parameter '%s' may not be null";
    }
    @Override
    public final IllegalArgumentException nullArrayParam(final int index, final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), nullArrayParam$str(), index, name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nullParamNPE$str() {
        return "COM00006: Parameter '%s' may not be null";
    }
    @Override
    public final NullPointerException nullParamNPE(final String name) {
        final NullPointerException result = new NullPointerException(String.format(getLoggingLocale(), nullParamNPE$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidPermissionAction$str() {
        return "COM00007: Invalid permission action '%s'";
    }
    @Override
    public final IllegalArgumentException invalidPermissionAction(final String action) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidPermissionAction$str(), action));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String emptyParam$str() {
        return "COM00008: Parameter '%s' must not be empty";
    }
    @Override
    public final IllegalArgumentException emptyParam(final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), emptyParam$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidExpressionSyntax$str() {
        return "COM00009: Invalid expression syntax at position %d";
    }
    @Override
    public final String invalidExpressionSyntax(final int index) {
        return String.format(getLoggingLocale(), invalidExpressionSyntax$str(), index);
    }
    protected String unresolvedEnvironmentProperty$str() {
        return "COM00010: No environment property found named \"%s\"";
    }
    @Override
    public final IllegalArgumentException unresolvedEnvironmentProperty(final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unresolvedEnvironmentProperty$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unresolvedSystemProperty$str() {
        return "COM00011: No system property found named \"%s\"";
    }
    @Override
    public final IllegalArgumentException unresolvedSystemProperty(final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unresolvedSystemProperty$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidAddressBytes$str() {
        return "COM00012: Invalid address length of %d; must be 4 or 16";
    }
    @Override
    public final IllegalArgumentException invalidAddressBytes(final int length) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidAddressBytes$str(), length));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidAddress$str() {
        return "COM00013: Invalid address string \"%s\"";
    }
    @Override
    public final IllegalArgumentException invalidAddress(final String address) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidAddress$str(), address));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unsupported$str() {
        return "COM00100: Method \"%s\" of class \"%s\" is not implemented";
    }
    @Override
    public final UnsupportedOperationException unsupported(final String methodName, final String className) {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(getLoggingLocale(), unsupported$str(), methodName, className));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String privilegedActionFailed$str() {
        return "COM00200: Privileged action failed";
    }
    @Override
    public final PrivilegedActionException privilegedActionFailed(final Exception e) {
        final PrivilegedActionException result = new PrivilegedActionException(e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String readOnlyPermissionCollection$str() {
        return "COM00300: Permission collection is read-only";
    }
    @Override
    public final SecurityException readOnlyPermissionCollection() {
        final SecurityException result = new SecurityException(String.format(getLoggingLocale(), readOnlyPermissionCollection$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidPermissionType$str() {
        return "COM00301: Invalid permission type (expected %s, actual value was %s)";
    }
    @Override
    public final IllegalArgumentException invalidPermissionType(final Class<? extends java.security.Permission> expectedType, final Class<? extends java.security.Permission> actualType) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidPermissionType$str(), expectedType, actualType));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidOddFields$str() {
        return "COM00400: Invalid serialized remote exception cause object with odd number of strings in fields key/value list";
    }
    @Override
    public final IllegalStateException invalidOddFields() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), invalidOddFields$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotContainNullFieldNameOrValue$str() {
        return "COM00401: Field name or field value cannot be null";
    }
    @Override
    public final IllegalArgumentException cannotContainNullFieldNameOrValue() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), cannotContainNullFieldNameOrValue$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String corruptedStream$str() {
        return "COM00402: Remote exception stream is corrupted and cannot be read";
    }
    @Override
    public final IOException corruptedStream() {
        final IOException result = new IOException(String.format(getLoggingLocale(), corruptedStream$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String remoteException2$str() {
        return "Remote exception %s: %s";
    }
    @Override
    public final String remoteException(final String exceptionClassName, final String message) {
        return String.format(getLoggingLocale(), remoteException2$str(), exceptionClassName, message);
    }
    protected String remoteException1$str() {
        return "Remote exception %s";
    }
    @Override
    public final String remoteException(final String exceptionClassName) {
        return String.format(getLoggingLocale(), remoteException1$str(), exceptionClassName);
    }
    protected String unexpectedPadding$str() {
        return "COM00500: Unexpected padding";
    }
    @Override
    public final DecodeException unexpectedPadding() {
        final DecodeException result = new DecodeException(String.format(getLoggingLocale(), unexpectedPadding$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String expectedPadding$str() {
        return "COM00501: Expected padding";
    }
    @Override
    public final DecodeException expectedPadding() {
        final DecodeException result = new DecodeException(String.format(getLoggingLocale(), expectedPadding$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String incompleteDecode$str() {
        return "COM00502: Incomplete decode";
    }
    @Override
    public final DecodeException incompleteDecode() {
        final DecodeException result = new DecodeException(String.format(getLoggingLocale(), incompleteDecode$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String expectedPaddingCharacters$str() {
        return "COM00503: Expected %d padding characters";
    }
    @Override
    public final DecodeException expectedPaddingCharacters(final int numExpected) {
        final DecodeException result = new DecodeException(String.format(getLoggingLocale(), expectedPaddingCharacters$str(), numExpected));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidBase32Character$str() {
        return "COM00504: Invalid base 32 character";
    }
    @Override
    public final DecodeException invalidBase32Character() {
        final DecodeException result = new DecodeException(String.format(getLoggingLocale(), invalidBase32Character$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String expectedEvenNumberOfHexCharacters$str() {
        return "COM00505: Expected an even number of hex characters";
    }
    @Override
    public final DecodeException expectedEvenNumberOfHexCharacters() {
        final DecodeException result = new DecodeException(String.format(getLoggingLocale(), expectedEvenNumberOfHexCharacters$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidHexCharacter$str() {
        return "COM00506: Invalid hex character";
    }
    @Override
    public final DecodeException invalidHexCharacter() {
        final DecodeException result = new DecodeException(String.format(getLoggingLocale(), invalidHexCharacter$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String expectedTwoPaddingCharacters$str() {
        return "COM00507: Expected two padding characters";
    }
    @Override
    public final DecodeException expectedTwoPaddingCharacters() {
        final DecodeException result = new DecodeException(String.format(getLoggingLocale(), expectedTwoPaddingCharacters$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidBase64Character$str() {
        return "COM00508: Invalid base 64 character";
    }
    @Override
    public final DecodeException invalidBase64Character() {
        final DecodeException result = new DecodeException(String.format(getLoggingLocale(), invalidBase64Character$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String tooLarge$str() {
        return "COM00509: Byte string builder is too large to grow";
    }
    @Override
    public final IllegalStateException tooLarge() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), tooLarge$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unexpectedNullValue$str() {
        return "COM01000: Internal error: Assertion failure: Unexpectedly null value";
    }
    @Override
    public final String unexpectedNullValue() {
        return String.format(getLoggingLocale(), unexpectedNullValue$str());
    }
    protected String expectedLockHold$str() {
        return "COM01001: Internal error: Assertion failure: Current thread expected to hold lock for %s";
    }
    @Override
    public final String expectedLockHold(final Object monitor) {
        return String.format(getLoggingLocale(), expectedLockHold$str(), monitor);
    }
    protected String expectedLockNotHold$str() {
        return "COM01002: Internal error: Assertion failure: Current thread expected to not hold lock for %s";
    }
    @Override
    public final String expectedLockNotHold(final Object monitor) {
        return String.format(getLoggingLocale(), expectedLockNotHold$str(), monitor);
    }
    protected String expectedBoolean$str() {
        return "COM01003: Internal error: Assertion failure: Expected boolean value to be %s";
    }
    @Override
    public final String expectedBoolean(final boolean expr) {
        return String.format(getLoggingLocale(), expectedBoolean$str(), expr);
    }
    protected String unreachableCode$str() {
        return "COM02000: Internal error: Unreachable code has been reached";
    }
    @Override
    public final IllegalStateException unreachableCode() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), unreachableCode$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String impossibleSwitchCase$str() {
        return "COM02001: Internal error: Impossible switch condition encountered: %s";
    }
    @Override
    public final IllegalStateException impossibleSwitchCase(final Object cond) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), impossibleSwitchCase$str(), cond));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
