/*
 * Copyright The WildFly Authors
 * SPDX-License-Identifier: Apache-2.0
 */
package org.jboss.as.server.deployment.jbossallxml;

import java.util.Set;

import org.jboss.as.controller.xml.IntVersionSchema;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;

/**
 * A versioned schema for an XML element contained within <code>jboss-all.xml</code>,
 * @author Paul Ferraro
 * @param <S> the schema type
 * @param <T> the type upon which this parser operates
 */
public interface JBossAllSchema<S extends JBossAllSchema<S, T>, T> extends IntVersionSchema<S>, JBossAllXMLParser<T> {

    /**
     * Creates a deployment unit processor that registers parsers for the specified <code>jboss-all.xml</code> schemas.
     * @param <S> the schema type
     * @param <T> the deployment unit attachment type, generated by the parser
     * @param schemas a set of XML element schemas
     * @param key a deployment unit attachment key
     * @return a deployment unit processor
     */
    static <S extends JBossAllSchema<S, T>, T> DeploymentUnitProcessor createDeploymentUnitProcessor(Set<S> schemas, AttachmentKey<T> key) {
        JBossAllXmlParserRegisteringProcessor.Builder builder = JBossAllXmlParserRegisteringProcessor.builder();
        for (S schema : schemas) {
            builder.addParser(schema.getQualifiedName(), key, schema);
        }
        return builder.build();
    }
}
