/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.module;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ModuleAliasChecker;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.marshalling.reflect.SerializableClassRegistry;
import org.jboss.modules.Module;

public final class ModuleDependencyProcessor
implements DeploymentUnitProcessor {
    private static final SerializableClassRegistry REGISTRY = AccessController.doPrivileged(new PrivilegedAction<SerializableClassRegistry>(){

        @Override
        public SerializableClassRegistry run() {
            return SerializableClassRegistry.getInstance();
        }
    });

    @Override
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ModuleSpecification moduleSpecification = deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        List<ModuleDependency> manifestDependencies = deploymentUnit.getAttachmentList(Attachments.MANIFEST_DEPENDENCIES);
        ModuleAliasChecker.checkModuleAliasesForDependencies(manifestDependencies, ModuleAliasChecker.MessageContext.MANIFEST_CONTEXT, deploymentUnit.getName());
        moduleSpecification.addUserDependencies(manifestDependencies);
        if (deploymentUnit.getParent() != null) {
            List<ModuleDependency> parentDependencies = deploymentUnit.getParent().getAttachmentList(Attachments.MANIFEST_DEPENDENCIES);
            moduleSpecification.addUserDependencies(parentDependencies);
        }
    }

    @Override
    public void undeploy(DeploymentUnit context) {
        Module module = context.getAttachment(Attachments.MODULE);
        if (module != null) {
            REGISTRY.release((ClassLoader)module.getClassLoader());
        }
    }
}

