/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import java.util.List;
import java.util.function.Consumer;
import org.jboss.as.controller.RequirementServiceTarget;
import org.jboss.as.server.deployment.AttachableDependency;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.server.deployment.SimpleAttachable;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.wildfly.service.ServiceDependency;

final class DeploymentPhaseContextImpl
extends SimpleAttachable
implements DeploymentPhaseContext {
    private final RequirementServiceTarget serviceTarget;
    private final ServiceRegistry serviceRegistry;
    private final List<Consumer<ServiceBuilder<?>>> dependencies;
    private final DeploymentUnit deploymentUnitContext;
    private final Phase phase;

    DeploymentPhaseContextImpl(RequirementServiceTarget serviceTarget, ServiceRegistry serviceRegistry, List<Consumer<ServiceBuilder<?>>> dependencies, DeploymentUnit deploymentUnitContext, Phase phase) {
        this.serviceTarget = serviceTarget;
        this.serviceRegistry = serviceRegistry;
        this.dependencies = dependencies;
        this.deploymentUnitContext = deploymentUnitContext;
        this.phase = phase;
    }

    @Override
    public ServiceName getPhaseServiceName() {
        return this.deploymentUnitContext.getServiceName().append(new String[]{this.phase.name()});
    }

    @Override
    public RequirementServiceTarget getRequirementServiceTarget() {
        return this.serviceTarget;
    }

    @Override
    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    @Override
    public DeploymentUnit getDeploymentUnit() {
        return this.deploymentUnitContext;
    }

    @Override
    public Phase getPhase() {
        return this.phase;
    }

    @Override
    public <T> void addDependency(ServiceName serviceName, AttachmentKey<T> attachmentKey) {
        this.addToAttachmentList(Attachments.NEXT_PHASE_ATTACHABLE_DEPS, new AttachableDependency(attachmentKey, serviceName, false));
    }

    @Override
    public <T> void requires(ServiceDependency<T> dependency) {
        this.dependencies.add((Consumer<ServiceBuilder<?>>)dependency);
    }

    @Override
    public <T> void addDeploymentDependency(ServiceName serviceName, AttachmentKey<T> attachmentKey) {
        this.addToAttachmentList(Attachments.NEXT_PHASE_ATTACHABLE_DEPS, new AttachableDependency(attachmentKey, serviceName, true));
    }
}

