/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.transformer.tool.maven;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.model.FileSet;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.wildfly.extras.transformer.tool.maven.HandleTransformation;

@Mojo(name="transform-sources", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class SourceTransformerMojo
extends AbstractMojo {
    @Component
    protected MojoExecution execution;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject mavenProject;
    @Parameter(property="inputFile")
    private File inputFile;
    @Parameter(name="source-project", property="source.project")
    private File sourceProject;
    @Parameter(defaultValue="${configs.dir}", readonly=true)
    private String configsDir;
    @Parameter(property="overwrite", required=false, defaultValue="false")
    private boolean overwrite;
    @Parameter(property="invert", required=false, defaultValue="false")
    private boolean invert;
    @Parameter(required=false, readonly=true)
    private String outputFolder;
    @Parameter(alias="ignore-existing", defaultValue="true", property="transform.ignore.existing")
    private boolean ignoreExisting;

    public void execute() throws MojoExecutionException, MojoFailureException {
        block12: {
            LifecyclePhase lifecyclePhase = this.valueOf(this.execution.getLifecyclePhase());
            try {
                if (this.inputFile != null && this.inputFile.isDirectory()) {
                    File outputDir = this.getOutputDirectory(lifecyclePhase);
                    try {
                        this.getLog().info((CharSequence)("Transforming contents of folder " + this.inputFile + " to " + outputDir));
                        HandleTransformation.transformDirectory(this.inputFile, outputDir, this.configsDir, this.getLog().isDebugEnabled(), this.overwrite, this.invert, this.getIgnored(lifecyclePhase));
                        switch (lifecyclePhase) {
                            case GENERATE_SOURCES: {
                                this.mavenProject.addCompileSourceRoot(new File(outputDir, this.inputFile.getName()).getAbsolutePath());
                                break;
                            }
                            case GENERATE_TEST_SOURCES: {
                                this.mavenProject.addTestCompileSourceRoot(new File(outputDir, this.inputFile.getName()).getAbsolutePath());
                                break;
                            }
                            case GENERATE_RESOURCES: {
                                Resource resource = new Resource();
                                resource.setDirectory(outputDir.getAbsolutePath());
                                this.mavenProject.addResource(resource);
                                break;
                            }
                            case GENERATE_TEST_RESOURCES: {
                                Resource testResource = new Resource();
                                testResource.setDirectory(outputDir.getAbsolutePath());
                                this.mavenProject.addTestResource(testResource);
                            }
                        }
                        break block12;
                    }
                    catch (IOException e) {
                        throw new MojoExecutionException(e.getMessage(), (Exception)e);
                    }
                }
                if (this.sourceProject != null && this.sourceProject.isDirectory()) {
                    this.getLog().info((CharSequence)("Transforming contents of project " + this.sourceProject));
                    Path sourceProjectPath = this.sourceProject.toPath();
                    Path baseDir = this.mavenProject.getBasedir().getCanonicalFile().toPath();
                    this.transformSources(baseDir, sourceProjectPath, LifecyclePhase.GENERATE_SOURCES);
                    this.transformSources(baseDir, sourceProjectPath, LifecyclePhase.GENERATE_TEST_SOURCES);
                    this.transformSources(baseDir, sourceProjectPath, LifecyclePhase.GENERATE_RESOURCES);
                    this.transformSources(baseDir, sourceProjectPath, LifecyclePhase.GENERATE_TEST_RESOURCES);
                }
            }
            catch (IOException ioex) {
                throw new MojoExecutionException("Error transforming code", (Exception)ioex);
            }
        }
    }

    private LifecyclePhase valueOf(String phase) {
        if (LifecyclePhase.GENERATE_TEST_SOURCES.id().equals(phase)) {
            return LifecyclePhase.GENERATE_TEST_SOURCES;
        }
        if (LifecyclePhase.GENERATE_RESOURCES.id().equals(phase)) {
            return LifecyclePhase.GENERATE_RESOURCES;
        }
        if (LifecyclePhase.GENERATE_TEST_RESOURCES.id().equals(phase)) {
            return LifecyclePhase.GENERATE_TEST_RESOURCES;
        }
        return LifecyclePhase.GENERATE_SOURCES;
    }

    private void transformSources(Path baseDir, Path sourceProjectPath, LifecyclePhase lifecyclePhase) throws IOException {
        List<String> roots = this.getSourceRoots(lifecyclePhase);
        this.getLog().debug((CharSequence)(lifecyclePhase + " roots are " + roots));
        File outputDir = null;
        for (String rawRoot : roots) {
            Path canonicalRoot = new File(rawRoot).getCanonicalFile().toPath();
            if (canonicalRoot.startsWith(baseDir)) {
                Path relative = baseDir.relativize(canonicalRoot);
                Path input = sourceProjectPath.resolve(relative);
                if (!Files.exists(input, new LinkOption[0]) || !Files.isDirectory(input, new LinkOption[0])) continue;
                outputDir = this.getOutputDirectory(lifecyclePhase);
                this.getLog().info((CharSequence)("Transforming contents of folder " + input + " to " + outputDir));
                HandleTransformation.transformDirectory(input.toFile(), outputDir, this.configsDir, this.getLog().isDebugEnabled(), this.overwrite, this.invert, this.getIgnored(lifecyclePhase));
                continue;
            }
            this.getLog().info((CharSequence)("Source folder " + rawRoot + " is not relative to " + baseDir + " -- skipping transformation"));
        }
        if (outputDir != null) {
            switch (lifecyclePhase) {
                case GENERATE_TEST_SOURCES: {
                    this.mavenProject.addTestCompileSourceRoot(outputDir.getAbsolutePath());
                    break;
                }
                case GENERATE_RESOURCES: {
                    Resource resource = new Resource();
                    resource.setDirectory(outputDir.getAbsolutePath());
                    this.mavenProject.addResource(resource);
                    break;
                }
                case GENERATE_TEST_RESOURCES: {
                    Resource testResource = new Resource();
                    testResource.setDirectory(outputDir.getAbsolutePath());
                    this.mavenProject.addTestResource(testResource);
                    break;
                }
                default: {
                    this.mavenProject.addCompileSourceRoot(outputDir.getAbsolutePath());
                }
            }
        }
    }

    private List<String> getSourceRoots(LifecyclePhase phase) {
        List result = null;
        List resources = null;
        switch (phase) {
            case GENERATE_TEST_SOURCES: {
                result = this.mavenProject.getTestCompileSourceRoots();
                break;
            }
            case GENERATE_RESOURCES: {
                resources = this.mavenProject.getResources();
                break;
            }
            case GENERATE_TEST_RESOURCES: {
                resources = this.mavenProject.getTestResources();
                break;
            }
            default: {
                result = this.mavenProject.getCompileSourceRoots();
            }
        }
        if (result == null) {
            result = resources != null ? resources.stream().map(FileSet::getDirectory).collect(Collectors.toList()) : Collections.emptyList();
        }
        return result;
    }

    private File getOutputDirectory(LifecyclePhase phase) throws IOException {
        Path outputDirectory = new File(this.mavenProject.getBuild().getDirectory()).toPath();
        if (this.outputFolder == null) {
            switch (phase) {
                case GENERATE_TEST_SOURCES: {
                    outputDirectory = outputDirectory.resolve("generated-test-sources").resolve("transformed");
                    break;
                }
                case GENERATE_RESOURCES: {
                    outputDirectory = outputDirectory.resolve("generated-resources").resolve("transformed");
                    break;
                }
                case GENERATE_TEST_RESOURCES: {
                    outputDirectory = outputDirectory.resolve("generated-test-resources").resolve("transformed");
                    break;
                }
                default: {
                    outputDirectory = outputDirectory.resolve("generated-sources").resolve("transformed");
                    break;
                }
            }
        } else {
            outputDirectory = new File(this.outputFolder).toPath();
        }
        if (!Files.exists(outputDirectory, new LinkOption[0])) {
            Files.createDirectories(outputDirectory, new FileAttribute[0]);
        }
        return outputDirectory.toFile();
    }

    private Set<String> getIgnored(LifecyclePhase phase) throws IOException {
        if (!this.ignoreExisting) {
            return Collections.emptySet();
        }
        switch (phase) {
            case GENERATE_SOURCES: {
                return this.getSourceFiles(Paths.get(this.mavenProject.getBuild().getSourceDirectory(), new String[0]));
            }
            case GENERATE_TEST_SOURCES: {
                return this.getSourceFiles(Paths.get(this.mavenProject.getBuild().getTestSourceDirectory(), new String[0]));
            }
            case GENERATE_RESOURCES: {
                return this.getSourceFiles(this.mavenProject.getResources());
            }
            case GENERATE_TEST_RESOURCES: {
                return this.getSourceFiles(this.mavenProject.getTestResources());
            }
        }
        return Collections.emptySet();
    }

    private Set<String> getSourceFiles(final Path sourceDirectory) throws IOException {
        final HashSet<String> sourceFiles = new HashSet<String>();
        if (Files.exists(sourceDirectory, new LinkOption[0])) {
            Files.walkFileTree(sourceDirectory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    sourceFiles.add(sourceDirectory.relativize(file).toString());
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        return sourceFiles;
    }

    private Set<String> getSourceFiles(Collection<Resource> resources) throws IOException {
        HashSet<String> sourceFiles = new HashSet<String>();
        for (Resource resource : resources) {
            sourceFiles.addAll(this.getSourceFiles(Paths.get(resource.getDirectory(), new String[0])));
        }
        return sourceFiles;
    }
}

