/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin.config.generator;

import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.galleon.Errors;
import org.jboss.galleon.MessageWriter;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.plugin.ProvisionedConfigHandler;
import org.jboss.galleon.progresstracking.ProgressTracker;
import org.jboss.galleon.runtime.ProvisioningRuntime;
import org.jboss.galleon.state.ProvisionedConfig;
import org.wildfly.galleon.plugin.config.generator.BaseConfigGenerator;
import org.wildfly.galleon.plugin.config.generator.ForkedConfigGenerator;
import org.wildfly.galleon.plugin.config.generator.WfProvisionedConfigHandler;
import org.wildfly.galleon.plugin.server.ConfigGeneratorException;
import org.wildfly.galleon.plugin.server.ForkCallback;
import org.wildfly.galleon.plugin.server.ForkedEmbeddedUtil;

public class WfConfigGenerator
extends BaseConfigGenerator {
    private MessageWriter messageWriter;
    private static Set<String> RESETTABLE_EMBEDDED_SYS_PROPERTIES = Set.of("jboss.home.dir", "jboss.modules.dir", "jboss.bundles.dir", "jboss.server.base.dir", "jboss.server.config.dir", "jboss.server.data.dir", "jboss.server.content.dir", "jboss.server.deploy.dir", "jboss.server.log.dir", "jboss.server.temp.dir", "jboss.controller.temp.dir", "jboss.node.name", "jboss.server.name", "jboss.host.name", "jboss.qualified.host.name", "org.jboss.server.bootstrap.maxThreads", "jboss.server.default.config", "jboss.server.management.uuid", "jboss.server.persist.config", "jboss.domain.base.dir", "jboss.domain.config.dir", "jboss.domain.data.dir", "jboss.domain.content.dir", "jboss.domain.deployment.dir", "jboss.domain.log.dir", "jboss.domain.servers.dir", "jboss.domain.temp.dir", "jboss.domain.default.config", "jboss.host.default.config", "jboss.host.management.uuid", "jboss.modules.system.pkgs", "modules.path", "javax.management.builder.initial");

    public static Set<String> computeResettableSysProps(String resetSysProps) {
        String[] sysPropKeys;
        HashSet<String> result = new HashSet<String>();
        result.addAll(RESETTABLE_EMBEDDED_SYS_PROPERTIES);
        for (String sysPropKey : sysPropKeys = resetSysProps.split(",")) {
            String trim = sysPropKey.trim();
            if ("".equals(trim)) continue;
            if (trim.startsWith("-")) {
                result.remove(trim);
                continue;
            }
            result.add(trim);
        }
        return Collections.unmodifiableSet(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(ProvisioningRuntime runtime, boolean forkEmbedded, String resetSystemProperties) throws ProvisioningException {
        this.messageWriter = runtime.getMessageWriter();
        this.forkEmbedded = forkEmbedded;
        this.resetSysProps = resetSystemProperties;
        this.jbossHome = runtime.getStagedDir().toString();
        HashMap<Object, Object> originalProps = new HashMap<Object, Object>(System.getProperties());
        HashMap<Object, Object> resetProps = new HashMap<Object, Object>();
        try {
            if (this.resetSysProps != null) {
                Set<String> resettableList = WfConfigGenerator.computeResettableSysProps(this.resetSysProps);
                for (Map.Entry<Object, Object> prop : System.getProperties().entrySet()) {
                    if (!resettableList.contains(prop.getKey().toString())) continue;
                    resetProps.put(prop.getKey(), prop.getValue());
                    System.clearProperty(prop.getKey().toString());
                }
            }
            this.doGenerate(runtime);
        }
        finally {
            this.cleanup(originalProps);
            for (Map.Entry prop : resetProps.entrySet()) {
                System.setProperty(prop.getKey().toString(), prop.getValue().toString());
            }
        }
    }

    private void doGenerate(ProvisioningRuntime runtime) throws ProvisioningException {
        if (this.messageWriter.isVerboseEnabled()) {
            this.messageWriter.verbose("Generating WildFly-based configs forkEmbedded=%s", new Object[]{this.forkEmbedded});
        }
        if (this.forkEmbedded) {
            this.initScriptWriter(runtime);
        }
        ProgressTracker progressTracker = runtime.getLayout().getFactory().getProgressTracker("CONFIGS");
        try (WfProvisionedConfigHandler configHandler = new WfProvisionedConfigHandler(runtime, this);){
            List configs = runtime.getConfigs();
            progressTracker.starting((long)configs.size());
            for (ProvisionedConfig config : configs) {
                progressTracker.processing((Object)config);
                if (runtime.getMessageWriter().isVerboseEnabled()) {
                    StringBuilder msg = new StringBuilder(64).append("Feature config");
                    if (config.getModel() != null) {
                        msg.append(" model=").append(config.getModel());
                    }
                    if (config.getName() != null) {
                        msg.append(" name=").append(config.getName());
                    }
                    this.messageWriter.verbose((CharSequence)msg);
                    if (config.hasProperties()) {
                        this.messageWriter.verbose((CharSequence)"  properties");
                        for (Map.Entry entry : config.getProperties().entrySet()) {
                            this.messageWriter.verbose("    %s=%s", new Object[]{entry.getKey(), entry.getValue()});
                        }
                    }
                }
                config.handle((ProvisionedConfigHandler)configHandler);
                progressTracker.processed((Object)config);
            }
        }
        if (this.forkEmbedded) {
            progressTracker.processing(null);
            this.scriptWriter.close();
            this.scriptWriter = null;
            ForkedEmbeddedUtil.fork((ForkCallback)new ForkedConfigGenerator(), (String[])new String[]{this.jbossHome, this.script.toString()});
        }
        progressTracker.complete();
    }

    private void cleanup(Map<?, ?> originalProps) {
        if (this.embeddedProcess != null) {
            try {
                this.stopEmbedded();
            }
            catch (ConfigGeneratorException e) {
                e.printStackTrace();
            }
        }
        if (this.scriptWriter != null) {
            this.scriptWriter.close();
        } else if (originalProps != null) {
            ArrayList<String> toClear = new ArrayList<String>();
            for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
                Object value = originalProps.get(entry.getKey());
                if (value != null) {
                    System.setProperty(entry.getKey().toString(), value.toString());
                    continue;
                }
                toClear.add(entry.getKey().toString());
            }
            if (!toClear.isEmpty()) {
                for (String string : toClear) {
                    System.clearProperty(string);
                }
            }
        }
    }

    private void initScriptWriter(ProvisioningRuntime runtime) throws ProvisioningException {
        this.scriptBuf = new StringBuilder();
        this.script = runtime.getTmpPath(new String[]{"forkedembedded.txt"});
        try {
            Files.createDirectories(this.script.getParent(), new FileAttribute[0]);
            this.scriptWriter = new PrintWriter(Files.newBufferedWriter(this.script, new OpenOption[0]));
        }
        catch (IOException e) {
            throw new ProvisioningException(Errors.writeFile((Path)this.script), (Throwable)e);
        }
    }

    void startServer(String ... args) throws ProvisioningException {
        try {
            if (this.forkEmbedded) {
                this.writeScript("standalone");
                this.writeArgs(args);
            } else {
                this.doStartServer(args);
            }
        }
        catch (ConfigGeneratorException e) {
            throw new ProvisioningException((Throwable)e);
        }
    }

    void startHc(String ... args) throws ProvisioningException {
        try {
            if (this.forkEmbedded) {
                this.writeScript("host");
                this.writeArgs(args);
            } else {
                this.doStartHc(args);
            }
        }
        catch (ConfigGeneratorException e) {
            throw new ProvisioningException((Throwable)e);
        }
    }

    private void writeArgs(String ... args) throws ConfigGeneratorException {
        this.scriptBuf.setLength(0);
        this.scriptBuf.append(args[0]);
        for (int i = 1; i < args.length; ++i) {
            this.scriptBuf.append(',').append(args[i]);
        }
        this.writeScript(this.scriptBuf.toString());
    }
}

