/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugins.bootablejar.maven.goals;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.maven.plugin.MojoExecutionException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.api.GalleonFeaturePackRuntime;
import org.jboss.galleon.api.GalleonPackageRuntime;
import org.jboss.galleon.api.GalleonProvisioningRuntime;
import org.jboss.galleon.api.Provisioning;
import org.jboss.galleon.api.config.GalleonProvisioningConfig;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wildfly.plugins.bootablejar.maven.goals.AbstractBuildBootableJarMojo;
import org.xml.sax.SAXException;

final class ScannedModules {
    private static final String MODULE_XML = "module.xml";
    private static final String PM = "pm";
    private static final String WILDFLY = "wildfly";
    private static final String MODULE = "module";
    private static final String TASKS_XML = "tasks.xml";
    private static final String MODULE_RUNTIME_KEY = "org.jboss.modules:jboss-modules";
    private final Map<String, Map<String, String>> perModule;
    private final Map<String, String> copiedArtifacts;
    private final String moduleRuntimeKey;
    private final String moduleRuntimeValue;

    ScannedModules(Map<String, Map<String, String>> perModule, String moduleRuntimeKey, String moduleRuntimeValue, Map<String, String> copiedArtifacts) {
        this.perModule = perModule;
        this.moduleRuntimeKey = moduleRuntimeKey;
        this.moduleRuntimeValue = moduleRuntimeValue;
        this.copiedArtifacts = copiedArtifacts;
    }

    Map<String, Map<String, String>> getPerModuleArtifacts() {
        return this.perModule;
    }

    Map<String, String> getCopiedArtifacts() {
        return this.copiedArtifacts;
    }

    String getModuleRuntime() {
        return this.moduleRuntimeValue;
    }

    Map<String, String> getProvisionedArtifacts() {
        HashMap<String, String> all = new HashMap<String, String>();
        for (Map<String, String> artifacts : this.perModule.values()) {
            all.putAll(artifacts);
        }
        all.put(this.moduleRuntimeKey, this.moduleRuntimeValue);
        all.putAll(this.copiedArtifacts);
        return all;
    }

    static ScannedModules scanProvisionedArtifacts(Provisioning pm, GalleonProvisioningConfig config) throws ProvisioningException, MojoExecutionException {
        HashMap<String, String> propsMap = new HashMap<String, String>();
        TreeMap<String, Map<String, String>> perModule = new TreeMap<String, Map<String, String>>();
        HashMap<String, String> copiedArtifacts = new HashMap<String, String>();
        try (GalleonProvisioningRuntime rt = pm.getProvisioningRuntime(config);){
            for (GalleonFeaturePackRuntime fprt : rt.getGalleonFeaturePacks()) {
                Path artifactProps = fprt.getResource(new String[]{"wildfly/artifact-versions.properties"});
                try {
                    AbstractBuildBootableJarMojo.readProperties(artifactProps, propsMap);
                }
                catch (Exception ex) {
                    throw new MojoExecutionException("Error reading artifact versions", ex);
                }
            }
            for (GalleonFeaturePackRuntime fprt : rt.getGalleonFeaturePacks()) {
                ScannedModules.processPackages(fprt, perModule, propsMap, copiedArtifacts);
            }
        }
        String moduleRuntimeValue = (String)propsMap.get(MODULE_RUNTIME_KEY);
        if (moduleRuntimeValue == null) {
            throw new ProvisioningException("No JBoss Modules runtime found");
        }
        return new ScannedModules(perModule, MODULE_RUNTIME_KEY, moduleRuntimeValue, copiedArtifacts);
    }

    private static void processPackages(GalleonFeaturePackRuntime fp, Map<String, Map<String, String>> perModule, Map<String, String> propsMap, Map<String, String> copiedArtifacts) throws ProvisioningException {
        HashMap<Path, GalleonPackageRuntime> jbossModules = new HashMap<Path, GalleonPackageRuntime>();
        for (GalleonPackageRuntime galleonPackageRuntime : fp.getGalleonPackages()) {
            Path tasks;
            Path pmWfDir = galleonPackageRuntime.getResource(new String[]{PM, WILDFLY});
            if (!Files.exists(pmWfDir, new LinkOption[0])) continue;
            Path moduleDir = pmWfDir.resolve(MODULE);
            if (Files.exists(moduleDir, new LinkOption[0])) {
                ScannedModules.processModules(galleonPackageRuntime, moduleDir, jbossModules);
            }
            if (!Files.exists(tasks = pmWfDir.resolve(TASKS_XML), new LinkOption[0])) continue;
            ScannedModules.processTasks(galleonPackageRuntime, tasks, propsMap, copiedArtifacts);
        }
        for (Map.Entry entry : jbossModules.entrySet()) {
            GalleonPackageRuntime pkg = (GalleonPackageRuntime)entry.getValue();
            try {
                ScannedModules.processModuleTemplate(pkg, (Path)entry.getKey(), perModule, propsMap);
            }
            catch (IOException | ParserConfigurationException | ProvisioningException | SAXException e) {
                throw new ProvisioningException("Failed to process JBoss module XML template for feature-pack " + pkg.getFeaturePackFPID() + " package " + pkg.getName(), e);
            }
        }
    }

    private static void processTasks(GalleonPackageRuntime pkg, Path tasks, Map<String, String> propsMap, Map<String, String> artifacts) throws ProvisioningException {
        try (InputStream reader = Files.newInputStream(tasks, new OpenOption[0]);){
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(reader);
            Element root = document.getDocumentElement();
            NodeList lst = root.getChildNodes();
            for (int i = 0; i < lst.getLength(); ++i) {
                Node n = lst.item(i);
                if (!(n instanceof Element) || !"copy-artifact".equals(n.getNodeName())) continue;
                Element copyArtifact = (Element)n;
                String artifact = copyArtifact.getAttribute("artifact");
                String optional = copyArtifact.getAttribute("optional");
                String value = propsMap.get(artifact);
                if (value == null) {
                    if (!"true".equals(optional)) continue;
                    artifacts.put(artifact, artifact + ":unknown::jar");
                    continue;
                }
                artifacts.put(artifact, value);
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new ProvisioningException("Failed to process tasks from package " + pkg.getName() + " from feature-pack " + pkg.getFeaturePackFPID(), (Throwable)e);
        }
    }

    private static void processModules(final GalleonPackageRuntime pkg, final Path fpModuleDir, final Map<Path, GalleonPackageRuntime> jbossModules) throws ProvisioningException {
        try {
            Files.walkFileTree(fpModuleDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (file.getFileName().toString().equals(ScannedModules.MODULE_XML)) {
                        jbossModules.put(fpModuleDir.relativize(file), pkg);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new ProvisioningException("Failed to process modules from package " + pkg.getName() + " from feature-pack " + pkg.getFeaturePackFPID(), (Throwable)e);
        }
    }

    private static void processModuleTemplate(GalleonPackageRuntime pkg, Path moduleXmlRelativePath, Map<String, Map<String, String>> perModule, Map<String, String> propsMap) throws ProvisioningException, IOException, ParserConfigurationException, SAXException {
        Path moduleTemplate = pkg.getResource(new String[]{PM, WILDFLY, MODULE}).resolve(moduleXmlRelativePath);
        try (InputStream reader = Files.newInputStream(moduleTemplate, new OpenOption[0]);){
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(reader);
            Element root = document.getDocumentElement();
            NodeList lst = root.getChildNodes();
            for (int i = 0; i < lst.getLength(); ++i) {
                Node n = lst.item(i);
                if (!(n instanceof Element) || !"resources".equals(n.getNodeName())) continue;
                Element resources = (Element)n;
                NodeList artifacts = resources.getChildNodes();
                for (int j = 0; j < artifacts.getLength(); ++j) {
                    String name;
                    Node a = artifacts.item(j);
                    if (!(a instanceof Element) || !"artifact".equals(a.getNodeName()) || !(name = ((Element)a).getAttribute("name")).startsWith("${")) continue;
                    name = name.substring(2, name.length() - 1);
                    Map<String, String> m = perModule.get(pkg.getName());
                    if (m == null) {
                        m = new TreeMap<String, String>();
                        perModule.put(pkg.getName(), m);
                    }
                    String value = propsMap.get(name);
                    m.put(name, value);
                }
            }
        }
    }
}

