/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.cli;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandContextFactory;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.batch.Batch;
import org.jboss.as.cli.batch.BatchManager;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;
import org.wildfly.core.launcher.CliCommandBuilder;
import org.wildfly.plugin.cli.ScriptWriter;
import org.wildfly.plugin.common.AbstractServerConnection;
import org.wildfly.plugin.common.Archives;
import org.wildfly.plugin.common.ServerOperations;
import org.wildfly.plugin.common.StandardOutput;
import org.wildfly.plugin.core.ServerHelper;
import org.wildfly.plugin.repository.ArtifactNameBuilder;
import org.wildfly.plugin.repository.ArtifactResolver;

@Mojo(name="execute-commands", threadSafe=true)
public class ExecuteCommandsMojo
extends AbstractServerConnection {
    @Parameter(defaultValue="false", property="wildfly.skip")
    private boolean skip;
    @Parameter(defaultValue="false", property="wildfly.batch")
    private boolean batch;
    @Parameter(alias="jboss-home", property="jboss-as.home")
    private String jbossHome;
    @Parameter(alias="system-properties")
    private Map<String, String> systemProperties;
    @Parameter
    private List<File> propertiesFiles = new ArrayList<File>();
    @Parameter(property="wildfly.commands")
    private List<String> commands = new ArrayList<String>();
    @Parameter(property="wildfly.scripts")
    private List<File> scripts = new ArrayList<File>();
    @Parameter(alias="fail-on-error", defaultValue="true", property="wildfly.failOnError")
    private boolean failOnError = true;
    @Parameter(defaultValue="false", property="wildfly.fork")
    private boolean fork;
    @Parameter(name="offline", defaultValue="false", property="wildfly.offline")
    private boolean offline = false;
    @Parameter(name="stdout", defaultValue="System.out", property="wildfly.stdout")
    private String stdout;
    @Parameter(alias="java-opts", property="wildfly.javaOpts")
    private String[] javaOpts;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true, required=true)
    private RepositorySystemSession session;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    private List<RemoteRepository> repositories;
    @Parameter(defaultValue="${project.build.directory}", readonly=true, required=true)
    private File buildDir;
    @Inject
    private ArtifactResolver artifactResolver;

    @Override
    public String goal() {
        return "execute-commands";
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().debug((CharSequence)"Skipping commands execution");
            return;
        }
        if (this.offline) {
            if (!ServerHelper.isValidHomeDirectory((String)this.jbossHome)) {
                throw new MojoFailureException("Invalid JBoss Home directory is not valid: " + this.jbossHome);
            }
            this.executeInNewProcess(Paths.get(this.jbossHome, new String[0]));
        } else if (this.fork) {
            this.executeInNewProcess(this.extractIfRequired());
        } else {
            this.executeInProcess();
        }
    }

    public void setJavaOpts(String value) {
        if (value != null) {
            this.javaOpts = value.split("\\s+");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void executeInNewProcess(Path wildflyHome) throws MojoExecutionException {
        block10: {
            if (this.commands != null && !this.commands.isEmpty()) {
                Path scriptFile = null;
                try {
                    scriptFile = ScriptWriter.create(this.commands, this.batch, this.failOnError);
                    this.executeInNewProcess(wildflyHome, scriptFile);
                    if (scriptFile == null) break block10;
                }
                catch (IOException e) {
                    try {
                        throw new MojoExecutionException("Failed execute commands.", (Exception)e);
                    }
                    catch (Throwable throwable) {
                        if (scriptFile == null) throw throwable;
                        try {
                            Files.deleteIfExists(scriptFile);
                            throw throwable;
                        }
                        catch (IOException e2) {
                            this.getLog().debug((CharSequence)("Failed to deleted CLI script file: " + scriptFile), (Throwable)e2);
                        }
                        throw throwable;
                    }
                }
                try {
                    Files.deleteIfExists(scriptFile);
                }
                catch (IOException e) {
                    this.getLog().debug((CharSequence)("Failed to deleted CLI script file: " + scriptFile), (Throwable)e);
                }
            }
        }
        if (this.scripts == null) return;
        if (this.scripts.isEmpty()) return;
        Iterator<File> iterator = this.scripts.iterator();
        while (iterator.hasNext()) {
            File script = iterator.next();
            this.executeInNewProcess(wildflyHome, script.toPath());
        }
    }

    private void executeInNewProcess(Path wildflyHome, Path scriptFile) throws MojoExecutionException {
        this.getLog().debug((CharSequence)"Executing CLI scripts");
        try {
            StandardOutput out = StandardOutput.parse(this.stdout, false);
            int exitCode = this.executeInNewProcess(wildflyHome, scriptFile, out);
            if (exitCode != 0) {
                StringBuilder msg = new StringBuilder("Failed to execute commands: ");
                switch (out.getTarget()) {
                    case COLLECTING: {
                        msg.append(out);
                        break;
                    }
                    case FILE: {
                        Path stdoutPath = out.getStdoutPath();
                        msg.append("See ").append(stdoutPath).append(" for full details of failure.").append(System.lineSeparator());
                        List<String> lines = Files.readAllLines(stdoutPath);
                        lines.subList(Math.max(lines.size() - 4, 0), lines.size()).forEach(line -> msg.append((String)line).append(System.lineSeparator()));
                        break;
                    }
                    case SYSTEM_ERR: 
                    case SYSTEM_OUT: 
                    case INHERIT: {
                        msg.append("See previous messages for failure messages.");
                        break;
                    }
                    default: {
                        msg.append("Reason unknown");
                    }
                }
                if (this.failOnError) {
                    throw new MojoExecutionException(msg.toString());
                }
                this.getLog().warn((CharSequence)msg);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to execute scripts.", (Exception)e);
        }
    }

    /*
     * Exception decompiling
     */
    private int executeInNewProcess(Path wildflyHome, Path scriptFile, StandardOutput stdout) throws MojoExecutionException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void executeInProcess() throws MojoExecutionException, MojoFailureException {
        if (this.jbossHome != null && !ServerHelper.isValidHomeDirectory((String)this.jbossHome)) {
            throw new MojoFailureException("Invalid JBoss Home directory is not valid: " + this.jbossHome);
        }
        Properties currentSystemProperties = System.getProperties();
        try {
            this.getLog().debug((CharSequence)"Executing commands");
            Properties newSystemProperties = new Properties(currentSystemProperties);
            if (this.jbossHome != null) {
                newSystemProperties.setProperty("jboss.home", this.jbossHome);
                newSystemProperties.setProperty("jboss.home.dir", this.jbossHome);
            }
            if (this.propertiesFiles != null) {
                for (File file : this.propertiesFiles) {
                    ExecuteCommandsMojo.parseProperties(file, newSystemProperties);
                }
            }
            if (this.systemProperties != null) {
                newSystemProperties.putAll(this.systemProperties);
            }
            System.setProperties(newSystemProperties);
            CommandContext commandContext = null;
            try (ModelControllerClient client = this.createClient();){
                commandContext = this.createCommandContext(client);
                if (this.commands != null && !this.commands.isEmpty()) {
                    if (this.batch) {
                        ExecuteCommandsMojo.executeBatch(commandContext, this.commands);
                    } else {
                        ExecuteCommandsMojo.executeCommands(commandContext, this.commands, this.failOnError);
                    }
                }
                if (this.scripts != null && !this.scripts.isEmpty()) {
                    for (File scriptFile : this.scripts) {
                        List<String> commands = Files.readAllLines(scriptFile.toPath(), StandardCharsets.UTF_8);
                        if (this.batch) {
                            ExecuteCommandsMojo.executeBatch(commandContext, commands);
                            continue;
                        }
                        ExecuteCommandsMojo.executeCommands(commandContext, commands, this.failOnError);
                    }
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not execute commands.", (Exception)e);
            }
            finally {
                if (commandContext != null) {
                    commandContext.terminateSession();
                }
            }
        }
        catch (IOException e) {
            throw new MojoFailureException("Failed to parse properties.", (Throwable)e);
        }
        finally {
            System.setProperties(currentSystemProperties);
        }
    }

    private static void executeCommands(CommandContext ctx, Iterable<String> commands, boolean failOnError) throws MojoExecutionException {
        for (String cmd : commands) {
            try {
                if (failOnError) {
                    ctx.handle(cmd);
                    continue;
                }
                ctx.handleSafe(cmd);
            }
            catch (CommandFormatException e) {
                throw new MojoExecutionException(String.format("Command '%s' is invalid. %s", cmd, e.getLocalizedMessage()), (Exception)((Object)e));
            }
            catch (CommandLineException e) {
                throw new MojoExecutionException(String.format("Command execution failed for command '%s'. %s", cmd, e.getLocalizedMessage()), (Exception)((Object)e));
            }
        }
    }

    private static void executeBatch(CommandContext ctx, Iterable<String> commands) throws IOException, MojoExecutionException {
        BatchManager batchManager = ctx.getBatchManager();
        if (batchManager.activateNewBatch()) {
            Batch batch = batchManager.getActiveBatch();
            for (String cmd : commands) {
                try {
                    batch.add(ctx.toBatchedCommand(cmd));
                }
                catch (CommandFormatException e) {
                    throw new MojoExecutionException(String.format("Command '%s' is invalid. %s", cmd, e.getLocalizedMessage()), (Exception)((Object)e));
                }
            }
            ModelNode result = ctx.getModelControllerClient().execute(batch.toRequest());
            if (!ServerOperations.isSuccessfulOutcome((ModelNode)result)) {
                throw new MojoExecutionException(ServerOperations.getFailureDescriptionAsString(result));
            }
        }
    }

    private CommandContext createCommandContext(ModelControllerClient client) {
        CommandContext commandContext = null;
        try {
            commandContext = CommandContextFactory.getInstance().newCommandContext();
            commandContext.bindClient(client);
        }
        catch (CommandLineException e) {
            throw new IllegalStateException("Failed to initialize CLI context", e);
        }
        catch (Exception e) {
            if (commandContext != null) {
                commandContext.terminateSession();
            }
            throw new IllegalStateException("Failed to initialize CLI context", e);
        }
        return commandContext;
    }

    private Path extractIfRequired() throws MojoFailureException {
        if (this.jbossHome != null) {
            return Paths.get(this.jbossHome, new String[0]);
        }
        Path result = this.artifactResolver.resolve(this.session, this.repositories, ArtifactNameBuilder.forRuntime(null).build());
        try {
            return Archives.uncompress(result, this.buildDir.toPath());
        }
        catch (IOException e) {
            throw new MojoFailureException("Artifact was not successfully extracted: " + result, (Throwable)e);
        }
    }

    private static void parseProperties(File file, Properties properties) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(file.toPath(), StandardCharsets.UTF_8);){
            properties.load(reader);
        }
    }

    private static /* synthetic */ void lambda$executeInNewProcess$1(CliCommandBuilder builder, String key, String value) {
        builder.addJavaOption(String.format("-D%s=%s", key, value));
    }
}

