/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.tools.server;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.as.controller.client.helpers.domain.DomainClient;
import org.jboss.as.controller.client.helpers.domain.ServerIdentity;
import org.jboss.as.controller.client.helpers.domain.ServerStatus;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.wildfly.plugin.tools.OperationExecutionException;
import org.wildfly.plugin.tools.server.ServerManager;

class CommonOperations {
    static final ModelNode EMPTY_ADDRESS = new ModelNode().setEmptyList();
    private static final Logger LOGGER = Logger.getLogger(CommonOperations.class);

    CommonOperations() {
    }

    static ModelNode determineHostAddress(ModelControllerClient client) throws IOException, OperationExecutionException {
        ModelNode op = Operations.createReadAttributeOperation((ModelNode)EMPTY_ADDRESS, (String)"local-host-name");
        ModelNode response = client.execute(op);
        if (Operations.isSuccessfulOutcome((ModelNode)response)) {
            return Operations.createAddress((String[])new String[]{"host", Operations.readResult((ModelNode)response).asString()});
        }
        throw new OperationExecutionException(op, response);
    }

    static boolean isStandaloneRunning(ModelControllerClient client) {
        try {
            ModelNode response = client.execute(Operations.createReadAttributeOperation((ModelNode)new ModelNode().setEmptyList(), (String)"server-state"));
            if (Operations.isSuccessfulOutcome((ModelNode)response)) {
                String state = Operations.readResult((ModelNode)response).asString();
                return !"starting".equals(state) && !"stopping".equals(state);
            }
        }
        catch (IOException | RuntimeException e) {
            Logger.getLogger(ServerManager.class).trace((Object)"Interrupted determining if server is running", (Throwable)e);
        }
        return false;
    }

    static boolean isDomainRunning(ModelControllerClient client, boolean shutdown) {
        DomainClient domainClient = client instanceof DomainClient ? (DomainClient)client : DomainClient.Factory.create((ModelControllerClient)client);
        try {
            ModelNode hostAddress = CommonOperations.determineHostAddress((ModelControllerClient)domainClient);
            Operations.CompositeOperationBuilder builder = Operations.CompositeOperationBuilder.create().addStep(Operations.createReadAttributeOperation((ModelNode)hostAddress, (String)"running-mode")).addStep(Operations.createReadAttributeOperation((ModelNode)hostAddress, (String)"host-state"));
            ModelNode response = domainClient.execute(builder.build());
            if (Operations.isSuccessfulOutcome((ModelNode)response) && "ADMIN_ONLY".equals(Operations.readResult((ModelNode)(response = Operations.readResult((ModelNode)response)).get("step-1")).asString()) && Operations.isSuccessfulOutcome((ModelNode)response.get("step-2"))) {
                String state = Operations.readResult((ModelNode)response).asString();
                return !"starting".equals(state) && !"stopping".equals(state);
            }
            HashMap<ServerIdentity, ServerStatus> servers = new HashMap<ServerIdentity, ServerStatus>();
            Map statuses = domainClient.getServerStatuses();
            for (ServerIdentity id : statuses.keySet()) {
                ServerStatus status = (ServerStatus)statuses.get(id);
                switch (status) {
                    case DISABLED: 
                    case STARTED: {
                        servers.put(id, status);
                    }
                }
            }
            if (shutdown) {
                return statuses.isEmpty();
            }
            return statuses.size() == servers.size();
        }
        catch (Exception e) {
            LOGGER.trace((Object)"Interrupted determining if domain is running", (Throwable)e);
            return false;
        }
    }

    static {
        EMPTY_ADDRESS.protect();
    }
}

