/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.tools.server;

import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.as.controller.client.helpers.domain.DomainClient;
import org.jboss.as.controller.client.helpers.domain.ServerIdentity;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.logging.Logger;
import org.wildfly.plugin.tools.OperationExecutionException;
import org.wildfly.plugin.tools.server.AbstractServerManager;
import org.wildfly.plugin.tools.server.CommonOperations;

public class DomainManager
extends AbstractServerManager {
    private static final Logger LOGGER = Logger.getLogger(DomainManager.class);
    private final DomainClient client;

    protected DomainManager(ProcessHandle process, DomainClient client) {
        super(process, (ModelControllerClient)client);
        this.client = client;
    }

    @Override
    public ModelControllerClient client() {
        return this.client;
    }

    @Override
    public String serverState() {
        try {
            ModelNode response = this.client().execute(Operations.createReadAttributeOperation((ModelNode)this.determineHostAddress(), (String)"host-state"));
            return Operations.isSuccessfulOutcome((ModelNode)response) ? Operations.readResult((ModelNode)response).asString() : "failed";
        }
        catch (IOException | RuntimeException e) {
            LOGGER.tracef("Interrupted determining the server state", (Object)e);
            return "failed";
        }
    }

    public ModelNode determineHostAddress() throws OperationExecutionException, IOException {
        return CommonOperations.determineHostAddress((ModelControllerClient)this.client);
    }

    @Override
    public boolean isRunning() {
        return CommonOperations.isDomainRunning((ModelControllerClient)this.client, false);
    }

    @Override
    public void shutdown() throws IOException, OperationExecutionException {
        this.shutdown(0L);
    }

    @Override
    public void shutdown(long timeout) throws IOException {
        ModelNode stopServersOp = Operations.createOperation((String)"stop-servers");
        stopServersOp.get("blocking").set(true);
        stopServersOp.get("timeout").set(timeout);
        ModelNode response = this.client.execute(stopServersOp);
        if (!Operations.isSuccessfulOutcome((ModelNode)response)) {
            throw new OperationExecutionException("Failed to stop servers.", stopServersOp, response);
        }
        ModelNode address = this.determineHostAddress();
        ModelNode shutdownOp = Operations.createOperation((String)"shutdown", (ModelNode)address);
        response = this.client.execute(shutdownOp);
        if (Operations.isSuccessfulOutcome((ModelNode)response)) {
            while (CommonOperations.isDomainRunning((ModelControllerClient)this.client, true)) {
                Thread.onSpinWait();
            }
        } else {
            throw new OperationExecutionException("Failed to shutdown host.", shutdownOp, response);
        }
    }

    @Override
    public void executeReload() {
        this.executeReload(Operations.createOperation((String)"reload-servers"));
    }

    @Override
    public void reloadIfRequired() throws IOException {
        this.reloadIfRequired(10L, TimeUnit.SECONDS);
    }

    @Override
    public void reloadIfRequired(long timeout, TimeUnit unit) throws IOException {
        block8: {
            String launchType = this.launchType();
            if ("DOMAIN".equalsIgnoreCase(launchType)) {
                HashMap<CallSite, Object> steps = new HashMap<CallSite, Object>();
                Operations.CompositeOperationBuilder builder = Operations.CompositeOperationBuilder.create();
                int stepCounter = 1;
                ModelNode hostAddress = this.determineHostAddress();
                for (Map.Entry entry : this.client.getServerStatuses().entrySet()) {
                    ModelNode address = hostAddress.clone().add("server", ((ServerIdentity)entry.getKey()).getServerName());
                    ModelNode op = Operations.createReadAttributeOperation((ModelNode)address, (String)"server-state");
                    builder.addStep(op);
                    steps.put((CallSite)((Object)("step-" + stepCounter++)), address);
                }
                ModelNode result = this.client.execute(builder.build());
                if (!Operations.isSuccessfulOutcome((ModelNode)result)) {
                    throw new OperationExecutionException("Failed to reload servers.", builder.build(), result);
                }
                builder = Operations.CompositeOperationBuilder.create();
                ModelNode results = Operations.readResult((ModelNode)result);
                for (Property serverResult : results.asPropertyList()) {
                    if (!"reload-required".equals(Operations.readResult((ModelNode)serverResult.getValue()).asString())) continue;
                    ModelNode address = (ModelNode)steps.get(serverResult.getName());
                    builder.addStep(Operations.createOperation((String)"reload", (ModelNode)address));
                }
                result = this.client.execute(builder.build());
                if (!Operations.isSuccessfulOutcome((ModelNode)result)) {
                    throw new OperationExecutionException("Failed to reload servers.", builder.build(), result);
                }
                try {
                    if (!this.waitFor(timeout, unit)) {
                        throw new RuntimeException(String.format("Failed to reload servers within %d %s.", timeout, unit.name().toLowerCase(Locale.ROOT)));
                    }
                    break block8;
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("Failed to reload the servers.", e);
                }
            }
            LOGGER.warnf("Cannot reload and wait for the server to start with a server type of %s.", (Object)launchType);
        }
    }
}

