/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.tools.server;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.dmr.ModelNode;
import org.wildfly.plugin.tools.ContainerDescription;
import org.wildfly.plugin.tools.DeploymentManager;
import org.wildfly.plugin.tools.OperationExecutionException;
import org.wildfly.plugin.tools.server.AbstractServerManager;
import org.wildfly.plugin.tools.server.ServerManager;

class ManagedServerManager
implements ServerManager {
    private final ServerManager delegate;

    ManagedServerManager(ServerManager delegate) {
        this.delegate = delegate;
    }

    @Override
    public ModelControllerClient client() {
        return this.delegate.client();
    }

    @Override
    public String serverState() {
        return this.delegate.serverState();
    }

    @Override
    public String launchType() {
        return this.delegate.launchType();
    }

    @Override
    public String takeSnapshot() throws IOException {
        return this.delegate.takeSnapshot();
    }

    @Override
    public ContainerDescription containerDescription() throws IOException {
        return this.delegate.containerDescription();
    }

    @Override
    public DeploymentManager deploymentManager() {
        return this.delegate.deploymentManager();
    }

    @Override
    public boolean isRunning() {
        return this.delegate.isRunning();
    }

    @Override
    public CompletableFuture<ServerManager> kill() {
        throw new UnsupportedOperationException("Cannot kill an managed server");
    }

    @Override
    public boolean waitFor(long startupTimeout) throws InterruptedException {
        return this.delegate.waitFor(startupTimeout);
    }

    @Override
    public boolean waitFor(long startupTimeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.waitFor(startupTimeout, unit);
    }

    @Override
    public void shutdown() throws IOException {
        throw new UnsupportedOperationException("Cannot shutdown an managed server");
    }

    @Override
    public void shutdown(long timeout) throws IOException {
        throw new UnsupportedOperationException("Cannot shutdown an managed server");
    }

    @Override
    public CompletableFuture<ServerManager> shutdownAsync() {
        throw new UnsupportedOperationException("Cannot shutdown an managed server");
    }

    @Override
    public CompletableFuture<ServerManager> shutdownAsync(long timeout) {
        throw new UnsupportedOperationException("Cannot shutdown an managed server");
    }

    @Override
    public void executeReload() throws IOException {
        this.delegate.executeReload();
    }

    @Override
    public void executeReload(ModelNode reloadOp) throws IOException {
        this.checkOperation(reloadOp);
        this.delegate.executeReload(reloadOp);
    }

    @Override
    public void reloadIfRequired() throws IOException {
        this.delegate.reloadIfRequired();
    }

    @Override
    public void reloadIfRequired(long timeout, TimeUnit unit) throws IOException {
        this.delegate.reloadIfRequired(timeout, unit);
    }

    @Override
    public ModelNode executeOperation(ModelNode op) throws IOException, OperationExecutionException {
        this.checkOperation(op);
        return this.delegate.executeOperation(op);
    }

    @Override
    public ModelNode executeOperation(Operation op) throws IOException, OperationExecutionException {
        this.checkOperation(op.getOperation());
        return this.delegate.executeOperation(op);
    }

    @Override
    public boolean isClosed() {
        return this.delegate.isClosed();
    }

    @Override
    public void close() {
        if (this.delegate instanceof AbstractServerManager) {
            ((AbstractServerManager)this.delegate).internalClose(false, true);
        }
    }

    private void checkOperation(ModelNode op) {
        String opName = Operations.getOperationName((ModelNode)op);
        if (opName.equalsIgnoreCase("shutdown")) {
            throw new UnsupportedOperationException("Cannot shutdown an managed server");
        }
    }
}

