/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.spi.api;

import java.net.URL;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class Defaultable<T>
implements Supplier<T> {
    private final Class<T> type;
    private final DefaultValue<T> defaultValue;
    private Optional<T> explicit = Optional.empty();

    public static Defaultable<String> string(String defaultValue) {
        return Defaultable.string(() -> defaultValue);
    }

    public static Defaultable<String> string(Supplier<String> defaultValueSupplier) {
        return new Defaultable<String>(String.class, defaultValueSupplier);
    }

    public static Defaultable<Integer> integer(int defaultValue) {
        return Defaultable.integer(() -> defaultValue);
    }

    public static Defaultable<Float> floating(float defaultValue) {
        return Defaultable.floating(() -> Float.valueOf(defaultValue));
    }

    public static Defaultable<Integer> integer(Supplier<Integer> defaultValueSupplier) {
        return new Defaultable<Integer>(Integer.class, defaultValueSupplier);
    }

    public static Defaultable<Float> floating(Supplier<Float> defaultValueSupplier) {
        return new Defaultable<Float>(Float.class, defaultValueSupplier);
    }

    public static Defaultable<Long> longInteger(long defaultValue) {
        return Defaultable.longInteger(() -> defaultValue);
    }

    public static Defaultable<Long> longInteger(Supplier<Long> defaultValueSupplier) {
        return new Defaultable<Long>(Long.class, defaultValueSupplier);
    }

    public static Defaultable<Boolean> bool(boolean defaultValue) {
        return Defaultable.bool(() -> defaultValue);
    }

    public static Defaultable<Boolean> bool(Supplier<Boolean> defaultValueSupplier) {
        return new Defaultable<Boolean>(Boolean.class, defaultValueSupplier);
    }

    public static Defaultable<URL> url(URL defaultValue) {
        return Defaultable.url(() -> defaultValue);
    }

    public static Defaultable<URL> url(Supplier<URL> defaultValueSupplier) {
        return new Defaultable<URL>(URL.class, defaultValueSupplier);
    }

    public static Defaultable<Boolean> ifAllExplicitlySet(Defaultable<?> ... items) {
        return Defaultable.bool(() -> {
            for (Defaultable item : items) {
                if (item.isExplicit()) continue;
                return false;
            }
            return true;
        });
    }

    public static Defaultable<Boolean> ifAnyExplicitlySet(Defaultable<?> ... items) {
        return Defaultable.bool(() -> {
            for (Defaultable item : items) {
                if (!item.isExplicit()) continue;
                return true;
            }
            return false;
        });
    }

    private Defaultable(Class<T> type, Supplier<T> defaultValueSupplier) {
        this.type = type;
        this.defaultValue = new DefaultValue<T>(defaultValueSupplier);
    }

    public Class<T> type() {
        return this.type;
    }

    public synchronized void set(T explicitValue) {
        this.explicit = Optional.ofNullable(explicitValue);
    }

    public T defaultValue() throws NoSuchElementException {
        return this.defaultValue(true);
    }

    private synchronized T defaultValue(boolean throwIfNull) {
        return this.defaultValue.get(throwIfNull);
    }

    public T explicitValue() throws NoSuchElementException {
        return this.explicitValue(true);
    }

    private synchronized T explicitValue(boolean throwIfNull) {
        return (T)this.explicit.orElseGet(() -> {
            if (throwIfNull) {
                throw new NoSuchElementException("No explicit value present");
            }
            return null;
        });
    }

    @Override
    public T get() throws NoSuchElementException {
        return this.get(true);
    }

    private synchronized T get(boolean throwIfNull) {
        return (T)this.explicitOrElseGet(() -> this.defaultValue.get(throwIfNull));
    }

    public Optional<T> explicit() {
        return this.explicit;
    }

    public void ifPresent(Consumer<? super T> consumer) {
        T value = this.get(false);
        if (value != null) {
            consumer.accept(value);
        }
    }

    public void ifExplicit(Consumer<? super T> consumer) {
        if (this.isExplicit()) {
            consumer.accept(this.get());
        }
    }

    public void ifDefault(Consumer<? super T> consumer) {
        if (this.isDefault()) {
            consumer.accept(this.get());
        }
    }

    public T orElse(T defaultValue) {
        T value = this.get();
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public T orElseGet(Supplier<? extends T> other) {
        T value = this.get();
        return value != null ? value : other.get();
    }

    public T explicitOrElseGet(Supplier<? extends T> other) {
        return this.explicit.orElseGet(other);
    }

    public T get(Supplier<? extends T> preferred) {
        return (T)this.explicitOrElseGet(() -> {
            Object value = preferred.get();
            if (value != null) {
                return value;
            }
            return this.defaultValue.get(false);
        });
    }

    public boolean isPresent() {
        return this.get(false) != null;
    }

    public boolean isExplicitPresent(Supplier<T> other) {
        return this.isExplicit() || other.get() != null;
    }

    public boolean isDefault() {
        return !this.explicit.isPresent();
    }

    public boolean isExplicit() {
        return this.explicit.isPresent();
    }

    private static class DefaultValue<T> {
        private final Supplier<T> supplier;

        DefaultValue(Supplier<T> supplier) {
            this.supplier = supplier;
        }

        synchronized T get(boolean throwIfNull) {
            T value = this.supplier.get();
            if (throwIfNull && value == null) {
                throw new NoSuchElementException("No default value present");
            }
            return value;
        }
    }
}

