/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.channelplugin;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilderException;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.apache.maven.shared.dependency.graph.traversal.CollectingDependencyNodeVisitor;
import org.apache.maven.shared.dependency.graph.traversal.DependencyNodeVisitor;
import org.commonjava.maven.atlas.ident.ref.ArtifactRef;
import org.commonjava.maven.atlas.ident.ref.ProjectRef;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.atlas.ident.ref.SimpleArtifactRef;
import org.commonjava.maven.atlas.ident.ref.SimpleProjectRef;
import org.commonjava.maven.atlas.ident.ref.SimpleProjectVersionRef;
import org.commonjava.maven.ext.common.ManipulationException;
import org.commonjava.maven.ext.common.model.Project;
import org.commonjava.maven.ext.common.session.MavenSessionHandler;
import org.commonjava.maven.ext.core.ManipulationSession;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.repository.RemoteRepository;
import org.wildfly.channel.Channel;
import org.wildfly.channel.ChannelManifestCoordinate;
import org.wildfly.channel.ChannelMapper;
import org.wildfly.channel.ChannelSession;
import org.wildfly.channel.Repository;
import org.wildfly.channel.UnresolvedMavenArtifactException;
import org.wildfly.channel.VersionResult;
import org.wildfly.channel.maven.ChannelCoordinate;
import org.wildfly.channel.maven.VersionResolverFactory;
import org.wildfly.channel.spi.MavenVersionsResolver;
import org.wildfly.channelplugin.AbstractChannelMojo;
import org.wildfly.channelplugin.ChannelPluginLogger;
import org.wildfly.channelplugin.InjectRepositoriesMojo;
import org.wildfly.channelplugin.MojoConfigurator;
import org.wildfly.channelplugin.manipulation.PomManipulator;
import org.wildfly.channelplugin.utils.IOUtils;
import org.wildfly.channeltools.util.ConversionUtils;
import org.wildfly.channeltools.util.VersionUtils;

@Mojo(name="upgrade", requiresProject=true, requiresDirectInvocation=true)
public class UpgradeComponentsMojo
extends AbstractChannelMojo {
    @Parameter(property="channelFile")
    String channelFile;
    @Parameter(property="manifestFile")
    String manifestFile;
    @Parameter(property="channelGAV")
    String channelGAV;
    @Parameter(property="manifestGAV")
    String manifestGAV;
    @Parameter(property="remoteRepositories")
    List<String> remoteRepositories;
    @Parameter(property="localRepository")
    String localRepositoryPath;
    @Parameter(property="ignoreStreams")
    List<String> ignoreStreams;
    @Parameter(property="dontIgnoreStreams")
    List<String> dontIgnoreStreams;
    @Parameter(property="ignoreModules")
    List<String> ignoreModules;
    @Parameter(property="ignoreProperties")
    List<String> ignoreProperties;
    @Parameter(property="ignorePropertiesPrefixedWith")
    List<String> ignorePropertiesPrefixedWith;
    @Parameter(property="overrideProperties")
    List<String> overrideProperties;
    @Parameter(property="overrideDependencies")
    List<String> overrideDependencies;
    @Parameter(property="inlineVersionOnConflict", defaultValue="true")
    boolean inlineVersionOnConflict;
    @Parameter(property="injectTransitiveDependencies", defaultValue="true")
    boolean injectTransitiveDependencies;
    @Parameter(property="copyExclusionsFrom")
    String copyExclusionsFrom;
    @Parameter(property="ignoreTestDependencies", defaultValue="true")
    boolean ignoreTestDependencies;
    @Parameter(property="injectExternalProperties", defaultValue="true")
    boolean injectExternalProperties;
    @Parameter(property="injectRepositories", defaultValue="true")
    boolean injectRepositories;
    @Inject
    DependencyGraphBuilder dependencyGraphBuilder;
    @Inject
    MavenSession mavenSession;
    @Inject
    ManipulationSession manipulationSession;
    @Inject
    RepositorySystem repositorySystem;
    private List<Channel> channels = new ArrayList<Channel>();
    private ChannelSession channelSession;
    private final List<ProjectRef> ignoredStreams = new ArrayList<ProjectRef>();
    private final List<ProjectRef> unignoredStreams = new ArrayList<ProjectRef>();
    private final List<ProjectRef> ignoredModules = new ArrayList<ProjectRef>();
    private Set<ProjectVersionRef> projectGavs;
    private final HashMap<Pair<String, String>, PomManipulator> manipulators = new HashMap();
    private final HashMap<Pair<Project, String>, String> upgradedProperties = new HashMap();
    private final Set<ProjectRef> declaredDependencies = new HashSet<ProjectRef>();

    private void init() throws MojoExecutionException {
        if (StringUtils.isBlank((CharSequence)this.localRepositoryPath)) {
            try {
                this.localRepositoryPath = IOUtils.createTemporaryCache();
            }
            catch (IOException e) {
                throw new MojoExecutionException("Cannot create local maven cache", (Exception)e);
            }
        }
        DefaultRepositorySystemSession repositorySystemSession = MavenRepositorySystemUtils.newSession();
        LocalRepository localRepository = new LocalRepository(this.localRepositoryPath);
        LocalRepositoryManager localRepoManager = this.repositorySystem.newLocalRepositoryManager((RepositorySystemSession)repositorySystemSession, localRepository);
        repositorySystemSession.setLocalRepositoryManager(localRepoManager);
        this.initChannel();
        if (!this.remoteRepositories.isEmpty()) {
            this.channels = UpgradeComponentsMojo.overrideRemoteRepositories(this.channels, this.remoteRepositories);
        }
        this.channelSession = new ChannelSession(this.channels, (MavenVersionsResolver.Factory)new VersionResolverFactory(this.repositorySystem, (RepositorySystemSession)repositorySystemSession));
        this.ignoreStreams.forEach(ga -> this.ignoredStreams.add(SimpleProjectRef.parse((String)ga)));
        this.dontIgnoreStreams.forEach(ga -> this.unignoredStreams.add(SimpleProjectRef.parse((String)ga)));
        this.ignoreModules.forEach(ga -> this.ignoredModules.add(SimpleProjectRef.parse((String)ga)));
    }

    private void reconfigure() throws MojoExecutionException {
        File configFile = new File(this.mavenSession.getExecutionRootDirectory(), ".wildfly-channel-maven-plugin");
        try {
            MojoConfigurator configurator = new MojoConfigurator(configFile);
            configurator.configureProperties(this);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to read plugin configuration from .wildfly-channel-maven-plugin", (Exception)e);
        }
    }

    public void execute() throws MojoExecutionException {
        if (!this.mavenSession.getCurrentProject().isExecutionRoot()) {
            return;
        }
        this.reconfigure();
        this.init();
        try {
            List<Project> pmeProjects = this.parsePmeProjects();
            this.projectGavs = pmeProjects.stream().map(p -> new SimpleProjectVersionRef(p.getGroupId(), p.getArtifactId(), p.getVersion())).collect(Collectors.toSet());
            for (Project project : pmeProjects) {
                ProjectRef moduleGA = project.getKey().asProjectRef();
                if (this.ignoredModules.contains(moduleGA)) {
                    this.getLog().info((CharSequence)String.format("Skipping module %s:%s", project.getGroupId(), project.getArtifactId()));
                    continue;
                }
                this.getLog().info((CharSequence)String.format("Processing module %s:%s", project.getGroupId(), project.getArtifactId()));
                PomManipulator manipulator = new PomManipulator(project);
                this.manipulators.put((Pair<String, String>)Pair.of((Object)project.getGroupId(), (Object)project.getArtifactId()), manipulator);
                this.processModule(project, manipulator);
            }
            if (this.injectTransitiveDependencies) {
                this.injectTransitiveDependencies();
            }
            if (this.injectRepositories) {
                Project rootProject = this.findRootProject(pmeProjects);
                PomManipulator rootManipulator = this.manipulators.get(Pair.of((Object)rootProject.getGroupId(), (Object)rootProject.getArtifactId()));
                InjectRepositoriesMojo.insertRepositories(rootProject, rootManipulator, this.channels);
            }
            for (PomManipulator manipulator : this.manipulators.values()) {
                manipulator.writePom();
            }
        }
        catch (XMLStreamException | ManipulationException e) {
            throw new MojoExecutionException("Project parsing failed", (Exception)e);
        }
        catch (DependencyGraphBuilderException e) {
            throw new MojoExecutionException("Dependency collector error", (Exception)((Object)e));
        }
    }

    private void processModule(Project pmeProject, PomManipulator manipulator) throws ManipulationException, XMLStreamException {
        Map<ArtifactRef, Dependency> resolvedProjectDependencies = this.collectResolvedProjectDependencies(pmeProject);
        resolvedProjectDependencies.keySet().forEach(a -> this.declaredDependencies.add(a.asProjectRef()));
        List<String> overriddenProperties = this.performHardPropertyOverrides(manipulator);
        List<Dependency> overriddenDependencies = this.performHardDependencyOverrides(resolvedProjectDependencies, manipulator);
        List<Pair<Dependency, String>> dependenciesToUpgrade = this.findDependenciesToUpgrade(resolvedProjectDependencies);
        for (Pair<Dependency, String> upgrade : dependenciesToUpgrade) {
            Dependency locatedDependency;
            String newVersion = (String)upgrade.getRight();
            Dependency d = locatedDependency = (Dependency)upgrade.getLeft();
            if (overriddenDependencies.contains(locatedDependency)) continue;
            if (VersionUtils.isProperty((String)locatedDependency.getVersion())) {
                PomManipulator targetManipulator;
                Pair<String, String> externalProperty;
                String originalVersionString = locatedDependency.getVersion();
                String versionPropertyName = VersionUtils.extractPropertyName((String)originalVersionString);
                if (overriddenProperties.contains(versionPropertyName)) continue;
                Pair projectProperty = UpgradeComponentsMojo.followProperties(pmeProject, versionPropertyName);
                if (projectProperty == null && (externalProperty = UpgradeComponentsMojo.resolveExternalProperty(this.mavenProject, versionPropertyName)) != null) {
                    projectProperty = Pair.of(null, (Object)((String)externalProperty.getLeft()));
                }
                if (projectProperty == null) {
                    ChannelPluginLogger.LOGGER.errorf("Unable to upgrade %s:%s:%s to '%s', can't locate property '%s' in the project", new Object[]{d.getGroupId(), d.getArtifactId(), d.getVersion(), newVersion, versionPropertyName});
                    continue;
                }
                Project targetProject = (Project)projectProperty.getLeft();
                String targetPropertyName = (String)projectProperty.getRight();
                if (this.isIgnoredProperty(targetPropertyName)) {
                    this.getLog().info((CharSequence)String.format("Ignoring property '%s'", targetPropertyName));
                    continue;
                }
                if (this.upgradedProperties.containsKey(projectProperty) && !this.upgradedProperties.get(projectProperty).equals(newVersion)) {
                    String propertyName = (String)projectProperty.getRight();
                    String currentPropertyValue = this.upgradedProperties.get(projectProperty);
                    if (this.inlineVersionOnConflict) {
                        this.getLog().warn((CharSequence)String.format("Inlining version string for %s:%s:%s, new version '%s'. The original version property '%s' has already been modified to '%s'.", d.getGroupId(), d.getArtifactId(), d.getVersion(), newVersion, propertyName, currentPropertyValue));
                        manipulator.overrideDependencyVersion(d.getGroupId(), d.getArtifactId(), originalVersionString, newVersion);
                        continue;
                    }
                    this.getLog().warn((CharSequence)String.format("Can't upgrade %s:%s:%s to '%s', property '%s' was already upgraded to '%s'.", d.getGroupId(), d.getArtifactId(), d.getVersion(), newVersion, propertyName, currentPropertyValue));
                    continue;
                }
                this.upgradedProperties.put((Pair<Project, String>)projectProperty, newVersion);
                if (targetProject != null) {
                    targetManipulator = this.manipulators.get(Pair.of((Object)targetProject.getGroupId(), (Object)targetProject.getArtifactId()));
                    targetManipulator.overrideProperty(targetPropertyName, newVersion);
                    continue;
                }
                if (this.injectExternalProperties) {
                    targetManipulator = this.manipulators.get(Pair.of((Object)pmeProject.getGroupId(), (Object)pmeProject.getArtifactId()));
                    targetManipulator.injectProperty(targetPropertyName, newVersion);
                    continue;
                }
                this.getLog().warn((CharSequence)String.format("Can't upgrade %s:%s:%s to %s, property %s is not defined in the scope of the project (consider enabling the injectExternalProperties parameter).", d.getGroupId(), d.getArtifactId(), d.getVersion(), newVersion, targetPropertyName));
                continue;
            }
            manipulator.overrideDependencyVersion(ConversionUtils.toArtifactRef((Dependency)locatedDependency), newVersion);
        }
    }

    private void injectTransitiveDependencies() throws DependencyGraphBuilderException, XMLStreamException {
        PomManipulator rootManipulator = this.manipulators.get(Pair.of((Object)this.mavenProject.getGroupId(), (Object)this.mavenProject.getArtifactId()));
        Map<ArtifactRef, Collection<ProjectRef>> undeclaredDependencies = this.collectUndeclaredDependencies();
        List dependenciesToInject = undeclaredDependencies.entrySet().stream().sorted((e1, e2) -> ((ArtifactRef)e1.getKey()).compareTo((Object)((ProjectRef)e2.getKey()))).filter(entry -> {
            ArtifactRef a = (ArtifactRef)entry.getKey();
            try {
                VersionResult versionResult = this.channelSession.findLatestMavenArtifactVersion(a.getGroupId(), a.getArtifactId(), a.getType(), a.getClassifier(), a.getVersionString());
                return !versionResult.getVersion().equals(a.getVersionString());
            }
            catch (UnresolvedMavenArtifactException e) {
                return false;
            }
        }).filter(entry -> {
            ArtifactRef a = (ArtifactRef)entry.getKey();
            boolean isIgnored = this.ignoredStreams.contains(a.asProjectRef()) || this.ignoredStreams.contains(new SimpleProjectRef(a.getGroupId(), "*"));
            boolean isUnignored = this.unignoredStreams.contains(a.asProjectRef());
            return isUnignored || !isIgnored;
        }).collect(Collectors.toList());
        for (Map.Entry entry2 : dependenciesToInject) {
            ArtifactRef a = (ArtifactRef)entry2.getKey();
            try {
                VersionResult versionResult = this.channelSession.findLatestMavenArtifactVersion(a.getGroupId(), a.getArtifactId(), a.getType(), a.getClassifier(), a.getVersionString());
                String newVersion = versionResult.getVersion();
                if (newVersion.equals(a.getVersionString())) continue;
                SimpleArtifactRef newDependency = new SimpleArtifactRef(a.getGroupId(), a.getArtifactId(), newVersion, a.getType(), a.getClassifier());
                this.getLog().info((CharSequence)String.format("Injecting undeclared dependency: %s (original version was %s)", newDependency, a.getVersionString()));
                rootManipulator.injectManagedDependency((ArtifactRef)newDependency, (Collection)entry2.getValue());
            }
            catch (UnresolvedMavenArtifactException e) {
                this.getLog().error((CharSequence)String.format("Unable to resolve dependency %s", a));
            }
        }
    }

    private List<String> performHardPropertyOverrides(PomManipulator manipulator) throws XMLStreamException {
        ArrayList<String> overriddenProperties = new ArrayList<String>();
        for (String nameValue : this.overrideProperties) {
            String[] split = nameValue.split("=");
            if (split.length != 2) {
                this.getLog().error((CharSequence)String.format("Can't interpret property to override settings: '%s'", nameValue));
                continue;
            }
            String propertyName = split[0];
            String propertyValue = split[1];
            if (!manipulator.overrideProperty(propertyName, propertyValue)) continue;
            this.getLog().info((CharSequence)String.format("Property '%s' overridden to '%s'", propertyName, propertyValue));
            overriddenProperties.add(propertyName);
        }
        return overriddenProperties;
    }

    private List<Dependency> performHardDependencyOverrides(Map<ArtifactRef, Dependency> resolvedProjectDependencies, PomManipulator manipulator) throws XMLStreamException {
        ArrayList<Dependency> overriddenDependencies = new ArrayList<Dependency>();
        for (Dependency dependency : resolvedProjectDependencies.values()) {
            Optional<String> overridenVersion = this.findOverridenVersion(dependency);
            if (!overridenVersion.isPresent()) continue;
            manipulator.overrideDependencyVersion(ConversionUtils.toArtifactRef((Dependency)dependency), overridenVersion.get());
            overriddenDependencies.add(dependency);
        }
        return overriddenDependencies;
    }

    private Optional<String> findOverridenVersion(Dependency dependency) {
        for (String gav : this.overrideDependencies) {
            String[] split = gav.split(":");
            if (split.length != 3) continue;
            String g = split[0];
            String a = split[1];
            String v = split[2];
            if (!dependency.getGroupId().equals(g) || !dependency.getArtifactId().equals(a)) continue;
            return Optional.of(v);
        }
        return Optional.empty();
    }

    private boolean isIgnoredProperty(String propertyName) {
        if (this.ignoreProperties.contains(propertyName)) {
            return true;
        }
        for (String prefix : this.ignorePropertiesPrefixedWith) {
            if (!propertyName.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    private Map<ArtifactRef, Dependency> collectResolvedProjectDependencies(Project pmeProject) throws ManipulationException {
        HashMap<ArtifactRef, Dependency> projectDependencies = new HashMap<ArtifactRef, Dependency>();
        projectDependencies.putAll(pmeProject.getResolvedManagedDependencies((MavenSessionHandler)this.manipulationSession));
        projectDependencies.putAll(pmeProject.getResolvedDependencies((MavenSessionHandler)this.manipulationSession));
        if (projectDependencies.isEmpty()) {
            this.getLog().debug((CharSequence)("No dependencies found in " + pmeProject.getArtifactId()));
        }
        return projectDependencies;
    }

    private List<Pair<Dependency, String>> findDependenciesToUpgrade(Map<ArtifactRef, Dependency> resolvedProjectDependencies) {
        ArrayList<Pair<Dependency, String>> dependenciesToUpgrade = new ArrayList<Pair<Dependency, String>>();
        for (Map.Entry<ArtifactRef, Dependency> entry : resolvedProjectDependencies.entrySet()) {
            ArtifactRef artifactRef = entry.getKey();
            Dependency dependency = entry.getValue();
            Objects.requireNonNull(artifactRef);
            Objects.requireNonNull(dependency);
            if (this.projectGavs.contains(artifactRef.asProjectVersionRef())) {
                this.getLog().debug((CharSequence)("Ignoring in-project dependency: " + artifactRef.asProjectVersionRef().toString()));
                continue;
            }
            if (!this.unignoredStreams.contains(artifactRef.asProjectRef())) {
                if (this.ignoredStreams.contains(artifactRef.asProjectRef())) {
                    this.getLog().info((CharSequence)("Skipping dependency (ignored stream): " + artifactRef.asProjectVersionRef().toString()));
                    continue;
                }
                SimpleProjectRef wildCardIgnoredProjectRef = new SimpleProjectRef(artifactRef.getGroupId(), "*");
                if (this.ignoredStreams.contains(wildCardIgnoredProjectRef)) {
                    this.getLog().info((CharSequence)("Skipping dependency (ignored stream): " + artifactRef.asProjectVersionRef().toString()));
                    continue;
                }
            }
            if (artifactRef.getVersionString() == null) {
                this.getLog().error((CharSequence)("Resolved dependency has null version: " + artifactRef));
                continue;
            }
            if (VersionUtils.isProperty((String)artifactRef.getVersionString())) {
                Pair<String, String> externalProperty = UpgradeComponentsMojo.resolveExternalProperty(this.mavenProject, VersionUtils.extractPropertyName((String)artifactRef.getVersionString()));
                if (externalProperty != null) {
                    artifactRef = new SimpleArtifactRef(artifactRef.getGroupId(), artifactRef.getArtifactId(), (String)externalProperty.getRight(), artifactRef.getType(), artifactRef.getClassifier());
                } else {
                    this.getLog().error((CharSequence)("Resolved dependency has version with property: " + artifactRef));
                    continue;
                }
            }
            if ("test".equals(dependency.getScope()) && this.ignoreTestDependencies) {
                this.getLog().info((CharSequence)("Skipping dependency (ignored scope): " + artifactRef.asProjectVersionRef().toString()));
                continue;
            }
            try {
                VersionResult versionResult = this.channelSession.findLatestMavenArtifactVersion(artifactRef.getGroupId(), artifactRef.getArtifactId(), artifactRef.getType(), artifactRef.getClassifier(), artifactRef.getVersionString());
                String channelVersion = versionResult.getVersion();
                if (!channelVersion.equals(artifactRef.getVersionString())) {
                    this.getLog().info((CharSequence)("Updating dependency " + artifactRef.getGroupId() + ":" + artifactRef.getArtifactId() + ":" + artifactRef.getVersionString() + " to version " + channelVersion));
                }
                dependenciesToUpgrade.add((Pair<Dependency, String>)Pair.of((Object)dependency, (Object)channelVersion));
            }
            catch (UnresolvedMavenArtifactException e) {
                this.getLog().debug((CharSequence)("Can't resolve artifact: " + artifactRef), (Throwable)e);
            }
        }
        return dependenciesToUpgrade;
    }

    private void initChannel() throws MojoExecutionException {
        block16: {
            int numberOfSources = 0;
            if (StringUtils.isNotBlank((CharSequence)this.channelFile)) {
                ++numberOfSources;
            }
            if (StringUtils.isNotBlank((CharSequence)this.channelGAV)) {
                ++numberOfSources;
            }
            if (StringUtils.isNotBlank((CharSequence)this.manifestFile)) {
                ++numberOfSources;
            }
            if (StringUtils.isNotBlank((CharSequence)this.manifestGAV)) {
                ++numberOfSources;
            }
            if (numberOfSources > 1) {
                throw new MojoExecutionException("Exactly one of [channelFile, channelGAV, manifestFile, manifestGAV] has to be given.");
            }
            try {
                if (StringUtils.isNotBlank((CharSequence)this.channelFile)) {
                    String[] paths;
                    for (String path : paths = this.channelFile.split(",")) {
                        Path channelFilePath = Path.of(path, new String[0]);
                        if (!channelFilePath.isAbsolute()) {
                            channelFilePath = Path.of(this.mavenSession.getExecutionRootDirectory(), new String[0]).resolve(channelFilePath);
                        }
                        this.getLog().info((CharSequence)("Reading channel file " + channelFilePath));
                        this.channels.add(ChannelMapper.from((URL)channelFilePath.toUri().toURL()));
                    }
                    break block16;
                }
                if (StringUtils.isNotBlank((CharSequence)this.channelGAV)) {
                    String[] gavs;
                    for (String gav : gavs = this.channelGAV.split(",")) {
                        this.channels.addAll(this.resolveChannelsFromGav(gav));
                    }
                    break block16;
                }
                if (StringUtils.isNotBlank((CharSequence)this.manifestFile)) {
                    String[] paths;
                    for (String path : paths = this.manifestFile.split(",")) {
                        URL manifestUrl = Path.of(path, new String[0]).toUri().toURL();
                        ChannelManifestCoordinate coordinate = new ChannelManifestCoordinate(manifestUrl);
                        this.channels.add(new Channel("a-channel", null, null, null, coordinate, null, null));
                    }
                    break block16;
                }
                if (StringUtils.isNotBlank((CharSequence)this.manifestGAV)) {
                    String[] gavs;
                    for (String gav : gavs = this.manifestGAV.split(",")) {
                        ChannelManifestCoordinate coordinate = UpgradeComponentsMojo.toManifestCoordinate(gav);
                        List repositories = this.mavenProject.getRemoteProjectRepositories().stream().map(rr -> new Repository(rr.getId(), rr.getUrl())).collect(Collectors.toList());
                        repositories.addAll(UpgradeComponentsMojo.createRepositories(this.remoteRepositories));
                        this.channels.add(new Channel("a-channel", null, null, repositories, coordinate, null, null));
                    }
                    break block16;
                }
                throw new MojoExecutionException("No channel or manifest specified.");
            }
            catch (MalformedURLException e) {
                throw new MojoExecutionException("Can't parse the channel or manifest file path", (Exception)e);
            }
        }
    }

    private List<Channel> resolveChannelsFromGav(String gavString) {
        List list;
        ChannelCoordinate channelCoordinate = UpgradeComponentsMojo.toChannelCoordinate(gavString);
        RepositorySystemSession repoSession = this.mavenSession.getRepositorySession();
        ArrayList<RemoteRepository> channelRepos = new ArrayList<RemoteRepository>(this.mavenProject.getRemoteProjectRepositories());
        int repoNumber = 0;
        if (this.remoteRepositories != null && !this.remoteRepositories.isEmpty()) {
            for (String repoUrl : this.remoteRepositories) {
                RemoteRepository repo = new RemoteRepository.Builder("repo-" + repoNumber++, "default", repoUrl).build();
                channelRepos.add(repo);
            }
        }
        VersionResolverFactory versionResolverFactory = new VersionResolverFactory(this.repositorySystem, repoSession);
        try {
            list = versionResolverFactory.resolveChannels(List.of(channelCoordinate), channelRepos);
        }
        catch (Throwable throwable) {
            try {
                try {
                    versionResolverFactory.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException("Couldn't resolve channel GAV", e);
            }
        }
        versionResolverFactory.close();
        return list;
    }

    private static ChannelCoordinate toChannelCoordinate(String gavString) {
        ChannelCoordinate coordinate;
        String[] gavSegments = gavString.split(":");
        if (gavSegments.length == 2) {
            coordinate = new ChannelCoordinate(gavSegments[0], gavSegments[1]);
        } else if (gavSegments.length == 3) {
            coordinate = new ChannelCoordinate(gavSegments[0], gavSegments[1], gavSegments[2]);
        } else {
            throw new IllegalArgumentException("Invalid GAV string, channel GAV has to have two or three segments separated with ':'. Given value was: " + gavString);
        }
        return coordinate;
    }

    private static ChannelManifestCoordinate toManifestCoordinate(String gavString) {
        ChannelManifestCoordinate coordinate;
        String[] gavSegments = gavString.split(":");
        if (gavSegments.length == 2) {
            coordinate = new ChannelManifestCoordinate(gavSegments[0], gavSegments[1]);
        } else if (gavSegments.length == 3) {
            coordinate = new ChannelManifestCoordinate(gavSegments[0], gavSegments[1], gavSegments[2]);
        } else {
            throw new IllegalArgumentException("Invalid GAV string, manifest GAV has to have two or three segments separated with ':'. Given value was: " + gavString);
        }
        return coordinate;
    }

    private static List<Channel> overrideRemoteRepositories(List<Channel> channels, List<String> repositories) {
        ArrayList<Channel> updatedChannels = new ArrayList<Channel>(channels.size());
        for (Channel channel : channels) {
            updatedChannels.add(new Channel(channel.getName(), channel.getDescription(), channel.getVendor(), UpgradeComponentsMojo.createRepositories(repositories), channel.getManifestCoordinate(), channel.getBlocklistCoordinate(), channel.getNoStreamStrategy()));
        }
        return updatedChannels;
    }

    private static List<Repository> createRepositories(List<String> userRepositories) {
        HashMap<Object, Repository> result = new HashMap<Object, Repository>();
        int idx = 0;
        for (String input : userRepositories) {
            Repository previous;
            Object id;
            String[] segments = input.split("::");
            if (segments.length == 1) {
                id = "repo-" + idx++;
                previous = result.put(id, new Repository((String)id, segments[0]));
            } else if (segments.length == 2) {
                id = segments[0];
                previous = result.put(id, new Repository((String)id, segments[1]));
            } else {
                throw new IllegalArgumentException("Invalid remote repository entry: " + input);
            }
            if (previous == null) continue;
            throw new IllegalArgumentException("Duplicate remote repository key: '" + (String)id + "'");
        }
        return new ArrayList<Repository>(result.values());
    }

    private Map<ArtifactRef, Collection<ProjectRef>> collectUndeclaredDependencies() throws DependencyGraphBuilderException {
        HashMap artifactExclusions = new HashMap();
        if (this.copyExclusionsFrom != null) {
            ProjectRef exclusionsModule = SimpleProjectRef.parse((String)this.copyExclusionsFrom);
            Optional<MavenProject> exclusionsProject = this.mavenProject.getCollectedProjects().stream().filter(p -> exclusionsModule.getGroupId().equals(p.getGroupId()) && exclusionsModule.getArtifactId().equals(p.getArtifactId())).findFirst();
            if (exclusionsProject.isPresent()) {
                DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(this.mavenSession.getProjectBuildingRequest());
                buildingRequest.setProject(exclusionsProject.get());
                DependencyNode rootNode = this.dependencyGraphBuilder.buildDependencyGraph((ProjectBuildingRequest)buildingRequest, null);
                CollectingDependencyNodeVisitor visitor = new CollectingDependencyNodeVisitor();
                rootNode.accept((DependencyNodeVisitor)visitor);
                visitor.getNodes().forEach(node -> {
                    HashSet exclusionSet = new HashSet(ConversionUtils.toProjectRefs((List)node.getExclusions()));
                    Collection previousExclusions = artifactExclusions.put(ConversionUtils.toArtifactRef((Artifact)node.getArtifact()), exclusionSet);
                    if (previousExclusions != null) {
                        exclusionSet.addAll(previousExclusions);
                    }
                });
            }
        } else {
            List managedDependencies = this.mavenProject.getModel().getDependencyManagement().getDependencies();
            managedDependencies.forEach(d -> artifactExclusions.put(ConversionUtils.toArtifactRef((Dependency)d), ConversionUtils.toProjectRefs((List)d.getExclusions())));
        }
        List projectGAs = this.projectGavs.stream().map(ProjectRef::asProjectRef).collect(Collectors.toList());
        HashMap<ArtifactRef, Collection<ProjectRef>> undeclaredDependencies = new HashMap<ArtifactRef, Collection<ProjectRef>>();
        for (MavenProject module : this.mavenProject.getCollectedProjects()) {
            DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(this.mavenSession.getProjectBuildingRequest());
            buildingRequest.setProject(module);
            DependencyNode rootNode = this.dependencyGraphBuilder.buildDependencyGraph((ProjectBuildingRequest)buildingRequest, null);
            CollectingDependencyNodeVisitor visitor = new CollectingDependencyNodeVisitor();
            rootNode.accept((DependencyNodeVisitor)visitor);
            visitor.getNodes().forEach(node -> {
                ArtifactRef artifact = ConversionUtils.toArtifactRef((Artifact)node.getArtifact());
                Collection exclusions = (Collection)artifactExclusions.get(artifact);
                if (projectGAs.contains(artifact.asProjectRef())) {
                    return;
                }
                if (this.declaredDependencies.contains(artifact.asProjectRef())) {
                    return;
                }
                if ("test".equals(node.getArtifact().getScope()) && this.ignoreTestDependencies) {
                    return;
                }
                undeclaredDependencies.put(artifact, exclusions);
            });
        }
        return undeclaredDependencies;
    }

    static Pair<Project, String> followProperties(Project pmeProject, String propertyName) {
        String newPropertyName;
        Pair<Project, String> targetProperty;
        Properties properties = pmeProject.getModel().getProperties();
        if (!properties.containsKey(propertyName)) {
            Project parentProject = pmeProject.getProjectParent();
            if (parentProject == null) {
                return null;
            }
            return UpgradeComponentsMojo.followProperties(parentProject, propertyName);
        }
        String propertyValue = (String)properties.get(propertyName);
        if (VersionUtils.isProperty((String)propertyValue) && (targetProperty = UpgradeComponentsMojo.followProperties(pmeProject, newPropertyName = VersionUtils.extractPropertyName((String)propertyValue))) != null) {
            return targetProperty;
        }
        return Pair.of((Object)pmeProject, (Object)propertyName);
    }

    static Pair<String, String> resolveExternalProperty(MavenProject mavenProject, String propertyName) {
        String newPropertyName;
        Pair<String, String> targetProperty;
        if (mavenProject == null) {
            return null;
        }
        Properties properties = mavenProject.getModel().getProperties();
        if (!properties.containsKey(propertyName)) {
            return UpgradeComponentsMojo.resolveExternalProperty(mavenProject.getParent(), propertyName);
        }
        String propertyValue = (String)properties.get(propertyName);
        if (VersionUtils.isProperty((String)propertyValue) && (targetProperty = UpgradeComponentsMojo.resolveExternalProperty(mavenProject, newPropertyName = VersionUtils.extractPropertyName((String)propertyValue))) != null) {
            return targetProperty;
        }
        return Pair.of((Object)propertyName, (Object)propertyValue);
    }
}

