/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.parsing.arguments;

import java.util.ArrayDeque;
import java.util.Deque;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.parsing.ParsingContext;
import org.jboss.as.cli.parsing.ParsingStateCallbackHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class ArgumentValueCallbackHandler
implements ParsingStateCallbackHandler {
    private static byte QUOTES = 1;
    private static byte ESCAPE = (byte)2;
    private Deque<ValueState> stack;
    private ValueState currentState;
    private byte flag;

    @Override
    public void enteredState(ParsingContext ctx) throws CommandFormatException {
        String stateId = ctx.getState().getId();
        if ("ARG_VALUE".equals(stateId)) {
            if (this.currentState != null) {
                if (this.stack == null) {
                    this.stack = new ArrayDeque<ValueState>();
                }
                this.stack.push(this.currentState);
                this.currentState = ctx.getCharacter() == '{' ? new DefaultValueState(false, true) : new DefaultValueState(this.currentState.isList());
            } else {
                this.currentState = ctx.getCharacter() == '{' ? new DefaultValueState(false, true) : new DefaultValueState(false);
            }
        } else if ("LIST".equals(stateId)) {
            if (this.currentState != null) {
                if (this.stack == null) {
                    this.stack = new ArrayDeque<ValueState>();
                }
                this.stack.push(this.currentState);
            }
            this.currentState = new ListValueState();
        } else if ("LIST_ITEM_SEP".equals(stateId)) {
            this.currentState.itemSeparator();
        } else if ("NAME_VALUE_SEP".equals(stateId)) {
            this.currentState.nameSeparator(ctx);
        } else if ("QUOTES".equals(stateId)) {
            this.flag = (byte)(this.flag ^ QUOTES);
        } else if ("ESCAPED_CHARACTER".equals(stateId)) {
            this.flag = (byte)(this.flag ^ ESCAPE);
        }
    }

    @Override
    public void leavingState(ParsingContext ctx) throws CommandFormatException {
        String stateId = ctx.getState().getId();
        if ("ARG_VALUE".equals(stateId) || "LIST".equals(stateId)) {
            this.currentState.complete();
            if (this.stack != null && this.stack.peek() != null) {
                this.stack.peek().addChild(this.currentState);
                this.currentState = this.stack.pop();
            }
        } else if ("QUOTES".equals(stateId)) {
            this.flag = (byte)(this.flag ^ QUOTES);
        } else if ("ESCAPED_CHARACTER".equals(stateId)) {
            this.flag = (byte)(this.flag ^ ESCAPE);
        }
    }

    @Override
    public void character(ParsingContext ctx) throws CommandFormatException {
        this.currentState.character(ctx.getCharacter());
    }

    public ModelNode getResult() {
        return this.currentState.getValue();
    }

    class ListValueState
    implements ValueState {
        private ModelNode list;

        ListValueState() {
        }

        @Override
        public void addChild(ValueState child) {
            if (this.list != null) {
                this.list.add(child.getValue());
            } else {
                this.list = child.getValue();
                if (this.list.getType() != ModelType.LIST) {
                    ModelNode list = new ModelNode();
                    list.add(this.list);
                    this.list = list;
                }
            }
        }

        @Override
        public String getName() {
            return null;
        }

        @Override
        public void nameSeparator(ParsingContext ctx) throws CommandFormatException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void itemSeparator() throws CommandFormatException {
        }

        @Override
        public void complete() throws CommandFormatException {
        }

        @Override
        public void character(char ch) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ModelNode getValue() {
            if (this.list == null) {
                ModelNode node = new ModelNode();
                node.setEmptyList();
                return node;
            }
            return this.list;
        }

        @Override
        public boolean isList() {
            return true;
        }
    }

    class DefaultValueState
    implements ValueState {
        private ModelNode wrapper;
        private boolean list;
        protected String name;
        protected StringBuilder buf;
        protected int trimToSize = -1;
        protected boolean dontQuote;

        public DefaultValueState(boolean list) {
            this(list, false);
        }

        public DefaultValueState(boolean list, boolean initWrapper) {
            this.list = list;
            if (initWrapper) {
                this.wrapper = new ModelNode();
            }
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public void nameSeparator(ParsingContext ctx) throws CommandFormatException {
            if (this.buf == null) {
                throw new CommandFormatException("Property name is null.");
            }
            if (this.name != null) {
                this.buf.append(ctx.getCharacter());
            } else {
                this.name = this.getTrimmedString();
                this.buf.setLength(0);
            }
        }

        @Override
        public void character(char ch) {
            if (this.buf == null) {
                this.buf = new StringBuilder();
            }
            if ((byte)(ArgumentValueCallbackHandler.this.flag & ESCAPE) > 0) {
                this.buf.append(ch);
            } else if ((byte)(ArgumentValueCallbackHandler.this.flag & QUOTES) > 0) {
                if (ch == '\"') {
                    if (this.buf.length() == 0) {
                        this.dontQuote = true;
                    } else if (!this.dontQuote) {
                        this.buf.append(ch);
                    }
                } else {
                    this.buf.append(ch);
                }
            } else if (!Character.isWhitespace(ch)) {
                this.buf.append(ch);
                if (this.trimToSize >= 0) {
                    this.trimToSize = -1;
                }
            } else if (this.buf.length() > 0) {
                if (this.trimToSize < 0) {
                    this.trimToSize = this.buf.length();
                }
                this.buf.append(ch);
            }
        }

        @Override
        public void itemSeparator() {
            if (this.buf.length() == 0) {
                return;
            }
            if (this.wrapper == null) {
                this.wrapper = new ModelNode();
            }
            if (this.name == null) {
                this.wrapper.add(this.getStringValue());
            } else {
                this.addChild(this.wrapper, this.name, this.getStringValue());
                this.name = null;
            }
            this.buf.setLength(0);
        }

        @Override
        public void complete() throws CommandFormatException {
            if (this.wrapper != null) {
                if (this.name == null) {
                    if (this.buf != null && this.buf.length() > 0) {
                        if (this.list || this.wrapper.getType().equals((Object)ModelType.LIST)) {
                            this.wrapper.add(this.getStringValue());
                        } else {
                            this.wrapper.set(this.getStringValue());
                        }
                    }
                } else {
                    this.addChild(this.wrapper, this.name, this.getStringValue());
                    this.name = null;
                }
            }
        }

        @Override
        public void addChild(ValueState child) {
            if (this.wrapper != null) {
                if (this.buf != null && this.buf.length() > 0) {
                    this.wrapper.add(this.getStringValue());
                } else {
                    ModelNode childNode;
                    if (child.getName() != null) {
                        childNode = new ModelNode();
                        childNode.get(child.getName()).set(child.getValue());
                    } else {
                        childNode = child.getValue();
                    }
                    this.addChild(this.wrapper, this.name, childNode);
                    this.name = null;
                }
            } else {
                String childName = child.getName() != null ? child.getName() : this.name;
                this.addChild(this.getValue(), childName, child.getValue());
            }
        }

        @Override
        public ModelNode getValue() {
            return this.wrapper != null ? this.wrapper : this.getStringValue();
        }

        private ModelNode getStringValue() {
            ModelNode value = new ModelNode();
            if (this.buf != null) {
                value.set(this.getTrimmedString());
            }
            return value;
        }

        protected void addChild(ModelNode parent, String name, ModelNode child) {
            if (this.list) {
                if (name != null) {
                    parent.add(name, child);
                } else {
                    parent.add(child);
                }
            } else if (name != null) {
                parent.get(name).set(child);
            } else {
                parent.set(child);
            }
        }

        @Override
        public boolean isList() {
            return false;
        }

        protected String getTrimmedString() {
            if (this.trimToSize >= 0) {
                this.buf.setLength(this.trimToSize);
                this.trimToSize = -1;
            }
            return this.buf.toString();
        }
    }

    static interface ValueState {
        public void addChild(ValueState var1);

        public String getName();

        public void nameSeparator(ParsingContext var1) throws CommandFormatException;

        public void itemSeparator() throws CommandFormatException;

        public void complete() throws CommandFormatException;

        public void character(char var1);

        public ModelNode getValue();

        public boolean isList();
    }
}

