package org.apache.activemq.artemis.core.client;

import java.util.Locale;
import org.apache.activemq.artemis.core.protocol.core.Packet;
import java.io.Serializable;
import javax.annotation.processing.Generated;
import java.net.UnknownHostException;
import org.jboss.logging.DelegatingBasicLogger;
import org.w3c.dom.Node;
import java.lang.String;
import org.jboss.logging.Logger;
import java.lang.Exception;
import java.lang.Integer;
import org.jboss.logging.BasicLogger;
import java.lang.Long;
import java.lang.Throwable;
import java.lang.Object;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.api.core.Interceptor;


import static org.jboss.logging.Logger.Level.TRACE;
import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2022-09-21T13:33:29-0400")
public class ActiveMQClientLogger_$logger extends DelegatingBasicLogger implements ActiveMQClientLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ActiveMQClientLogger_$logger.class.getName();
    public ActiveMQClientLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void dumpingSessionStacks() {
        super.log.logv(FQCN, INFO, null, dumpingSessionStacks$str());
    }
    protected String dumpingSessionStacks$str() {
        return "AMQ211000: **** Dumping session creation stacks ****";
    }
    @Override
    public final void dumpingSessionStack(final Exception e) {
        super.log.logv(FQCN, INFO, e, dumpingSessionStack$str());
    }
    protected String dumpingSessionStack$str() {
        return "AMQ211001: session created";
    }
    @Override
    public final void startedNettyConnector(final String connectorType, final String version, final String host, final Integer port) {
        super.log.logv(FQCN, DEBUG, null, startedNettyConnector$str(), connectorType, version, host, port);
    }
    protected String startedNettyConnector$str() {
        return "AMQ211002: Started {0} Netty Connector version {1} to {2}:{3,number,#}";
    }
    @Override
    public final void startedInVMConnector() {
        super.log.logv(FQCN, DEBUG, null, startedInVMConnector$str());
    }
    protected String startedInVMConnector$str() {
        return "AMQ211003: Started InVM Connector";
    }
    @Override
    public final void warn(final String message) {
        super.log.logv(FQCN, WARN, null, warn$str(), message);
    }
    protected String warn$str() {
        return "AMQ212000: {0}";
    }
    @Override
    public final void errorClearingMessages(final Throwable e) {
        super.log.logv(FQCN, WARN, e, errorClearingMessages$str());
    }
    protected String errorClearingMessages$str() {
        return "AMQ212001: Error on clearing messages";
    }
    @Override
    public final void timeOutWaitingForProcessing() {
        super.log.logv(FQCN, WARN, null, timeOutWaitingForProcessing$str());
    }
    protected String timeOutWaitingForProcessing$str() {
        return "AMQ212002: Timed out waiting for handler to complete processing";
    }
    @Override
    public final void unableToCloseSession(final Exception e) {
        super.log.logv(FQCN, WARN, e, unableToCloseSession$str());
    }
    protected String unableToCloseSession$str() {
        return "AMQ212003: Unable to close session";
    }
    @Override
    public final void failedToConnectToServer() {
        super.log.logv(FQCN, WARN, null, failedToConnectToServer0$str());
    }
    protected String failedToConnectToServer0$str() {
        return "AMQ212004: Failed to connect to server.";
    }
    @Override
    public final void failedToConnectToServer(final Integer reconnectAttempts) {
        super.log.logv(FQCN, WARN, null, failedToConnectToServer1$str(), reconnectAttempts);
    }
    protected String failedToConnectToServer1$str() {
        return "AMQ212005: Tried {0} times to connect. Now giving up on reconnecting it.";
    }
    @Override
    public final void createConnectorException(final Exception e) {
        super.log.logv(FQCN, WARN, e, createConnectorException$str());
    }
    protected String createConnectorException$str() {
        return "AMQ212007: connector.create or connectorFactory.createConnector should never throw an exception, implementation is badly behaved, but we will deal with it anyway.";
    }
    @Override
    public final void factoryLeftOpen(final Exception e, final int i) {
        super.log.logv(FQCN, WARN, e, factoryLeftOpen$str(), i);
    }
    protected String factoryLeftOpen$str() {
        return "AMQ212008: I am closing a core ClientSessionFactory you left open. Please make sure you close all ClientSessionFactories explicitly before letting them go out of scope! {0}";
    }
    @Override
    public final void resettingSessionAfterFailure() {
        super.log.logv(FQCN, WARN, null, resettingSessionAfterFailure$str());
    }
    protected String resettingSessionAfterFailure$str() {
        return "AMQ212009: resetting session after failure";
    }
    @Override
    public final void retryCreateSessionSeverStarting(final String name) {
        super.log.logv(FQCN, WARN, null, retryCreateSessionSeverStarting$str(), name);
    }
    protected String retryCreateSessionSeverStarting$str() {
        return "AMQ212010: Server is starting, retry to create the session {0}";
    }
    @Override
    public final void commitAfterFailover() {
        super.log.logv(FQCN, WARN, null, commitAfterFailover$str());
    }
    protected String commitAfterFailover$str() {
        return "AMQ212011: committing transaction after failover occurred, any non persistent messages may be lost";
    }
    @Override
    public final void failoverDuringCommit() {
        super.log.logv(FQCN, WARN, null, failoverDuringCommit$str());
    }
    protected String failoverDuringCommit$str() {
        return "AMQ212012: failure occurred during commit throwing XAException";
    }
    @Override
    public final void failoverDuringPrepareRollingBack() {
        super.log.logv(FQCN, WARN, null, failoverDuringPrepareRollingBack$str());
    }
    protected String failoverDuringPrepareRollingBack$str() {
        return "AMQ212014: failover occurred during prepare rolling back";
    }
    @Override
    public final void errorDuringPrepare(final Throwable e) {
        super.log.logv(FQCN, WARN, e, errorDuringPrepare$str());
    }
    protected String errorDuringPrepare$str() {
        return "AMQ212015: failover occurred during prepare rolling back";
    }
    @Override
    public final void clientSessionNotClosed(final Exception e, final int identity) {
        super.log.logv(FQCN, WARN, e, clientSessionNotClosed$str(), identity);
    }
    protected String clientSessionNotClosed$str() {
        return "AMQ212016: I am closing a core ClientSession you left open. Please make sure you close all ClientSessions explicitly before letting them go out of scope! {0}";
    }
    @Override
    public final void errorAddingPacket(final Exception e) {
        super.log.logv(FQCN, WARN, e, errorAddingPacket$str());
    }
    protected String errorAddingPacket$str() {
        return "AMQ212017: error adding packet";
    }
    @Override
    public final void errorCallingCancel(final Exception e) {
        super.log.logv(FQCN, WARN, e, errorCallingCancel$str());
    }
    protected String errorCallingCancel$str() {
        return "AMQ212018: error calling cancel";
    }
    @Override
    public final void errorReadingIndex(final Exception e) {
        super.log.logv(FQCN, WARN, e, errorReadingIndex$str());
    }
    protected String errorReadingIndex$str() {
        return "AMQ212019: error reading index";
    }
    @Override
    public final void errorSettingIndex(final Exception e) {
        super.log.logv(FQCN, WARN, e, errorSettingIndex$str());
    }
    protected String errorSettingIndex$str() {
        return "AMQ212020: error setting index";
    }
    @Override
    public final void errorReSettingIndex(final Exception e) {
        super.log.logv(FQCN, WARN, e, errorReSettingIndex$str());
    }
    protected String errorReSettingIndex$str() {
        return "AMQ212021: error resetting index";
    }
    @Override
    public final void errorReadingCache(final Exception e) {
        super.log.logv(FQCN, WARN, e, errorReadingCache$str());
    }
    protected String errorReadingCache$str() {
        return "AMQ212022: error reading LargeMessage file cache";
    }
    @Override
    public final void errorClosingCache(final Exception e) {
        super.log.logv(FQCN, WARN, e, errorClosingCache$str());
    }
    protected String errorClosingCache$str() {
        return "AMQ212023: error closing LargeMessage file cache";
    }
    @Override
    public final void errorFinalisingCache(final Exception e) {
        super.log.logv(FQCN, WARN, e, errorFinalisingCache$str());
    }
    protected String errorFinalisingCache$str() {
        return "AMQ212024: Exception during finalization for LargeMessage file cache";
    }
    @Override
    public final void errorConnectingToNodes(final Exception e) {
        super.log.logv(FQCN, WARN, e, errorConnectingToNodes$str());
    }
    protected String errorConnectingToNodes$str() {
        return "AMQ212025: did not connect the cluster connection to other nodes";
    }
    @Override
    public final void timedOutWaitingForTermination() {
        super.log.logv(FQCN, WARN, null, timedOutWaitingForTermination$str());
    }
    protected String timedOutWaitingForTermination$str() {
        return "AMQ212026: Timed out waiting for pool to terminate";
    }
    @Override
    public final void timedOutWaitingForScheduledPoolTermination() {
        super.log.logv(FQCN, WARN, null, timedOutWaitingForScheduledPoolTermination$str());
    }
    protected String timedOutWaitingForScheduledPoolTermination$str() {
        return "AMQ212027: Timed out waiting for scheduled pool to terminate";
    }
    @Override
    public final void errorStartingLocator(final Exception e) {
        super.log.logv(FQCN, WARN, e, errorStartingLocator$str());
    }
    protected String errorStartingLocator$str() {
        return "AMQ212028: error starting server locator";
    }
    @Override
    public final void serverLocatorNotClosed(final Exception e, final int identity) {
        super.log.logv(FQCN, DEBUG, e, serverLocatorNotClosed$str(), identity);
    }
    protected String serverLocatorNotClosed$str() {
        return "AMQ212029: Closing a Server Locator left open. Please make sure you close all Server Locators explicitly before letting them go out of scope! {0}";
    }
    @Override
    public final void errorSendingTopology(final Throwable e) {
        super.log.logv(FQCN, WARN, e, errorSendingTopology$str());
    }
    protected String errorSendingTopology$str() {
        return "AMQ212030: error sending topology";
    }
    @Override
    public final void errorSendingTopologyNodedown(final Throwable e) {
        super.log.logv(FQCN, WARN, e, errorSendingTopologyNodedown$str());
    }
    protected String errorSendingTopologyNodedown$str() {
        return "AMQ212031: error sending topology";
    }
    @Override
    public final void timedOutStoppingDiscovery() {
        super.log.logv(FQCN, WARN, null, timedOutStoppingDiscovery$str());
    }
    protected String timedOutStoppingDiscovery$str() {
        return "AMQ212032: Timed out waiting to stop discovery thread";
    }
    @Override
    public final void errorSendingNotifOnDiscoveryStop(final Throwable e) {
        super.log.logv(FQCN, WARN, e, errorSendingNotifOnDiscoveryStop$str());
    }
    protected String errorSendingNotifOnDiscoveryStop$str() {
        return "AMQ212033: unable to send notification when discovery group is stopped";
    }
    @Override
    public final void multipleServersBroadcastingSameNode(final String nodeId) {
        super.log.logv(FQCN, WARN, null, multipleServersBroadcastingSameNode$str(), nodeId);
    }
    protected String multipleServersBroadcastingSameNode$str() {
        return "AMQ212034: There are more than one servers on the network broadcasting the same node id. You will see this message exactly once (per node) if a node is restarted, in which case it can be safely ignored. But if it is logged continuously it means you really do have more than one node on the same network active concurrently with the same node id. This could occur if you have a backup node active at the same time as its live node. nodeID={0}";
    }
    @Override
    public final void errorReceivingPacketInDiscovery(final Throwable e) {
        super.log.logv(FQCN, WARN, e, errorReceivingPacketInDiscovery$str());
    }
    protected String errorReceivingPacketInDiscovery$str() {
        return "AMQ212035: error receiving packet in discovery";
    }
    @Override
    public final void cannotFindPacketToClear(final Integer lastReceivedCommandID, final Integer firstStoredCommandID) {
        super.log.logv(FQCN, WARN, null, cannotFindPacketToClear$str(), lastReceivedCommandID, firstStoredCommandID);
    }
    protected String cannotFindPacketToClear$str() {
        return "AMQ212036: Can not find packet to clear: {0} last received command id first stored command id {1}";
    }
    @Override
    public final void connectionFailureDetected(final String remoteAddress, final String message, final ActiveMQExceptionType type) {
        super.log.logv(FQCN, WARN, null, connectionFailureDetected$str(), remoteAddress, message, type);
    }
    protected String connectionFailureDetected$str() {
        return "AMQ212037: Connection failure to {0} has been detected: {1} [code={2}]";
    }
    @Override
    public final void errorCallingInterceptor(final Throwable e, final Interceptor interceptor) {
        super.log.logv(FQCN, WARN, e, errorCallingInterceptor$str(), interceptor);
    }
    protected String errorCallingInterceptor$str() {
        return "AMQ212038: Failure in calling interceptor: {0}";
    }
    @Override
    public final void timeoutClosingSSL() {
        super.log.logv(FQCN, WARN, null, timeoutClosingSSL$str());
    }
    protected String timeoutClosingSSL$str() {
        return "AMQ212040: Timed out waiting for netty ssl close future to complete";
    }
    @Override
    public final void timeoutClosingNettyChannel() {
        super.log.logv(FQCN, WARN, null, timeoutClosingNettyChannel$str());
    }
    protected String timeoutClosingNettyChannel$str() {
        return "AMQ212041: Timed out waiting for netty channel to close";
    }
    @Override
    public final void timeoutFlushingPacket() {
        super.log.logv(FQCN, WARN, null, timeoutFlushingPacket$str());
    }
    protected String timeoutFlushingPacket$str() {
        return "AMQ212042: Timed out waiting for packet to be flushed";
    }
    @Override
    public final void propertyNotInteger(final String propName, final String name) {
        super.log.logv(FQCN, WARN, null, propertyNotInteger$str(), propName, name);
    }
    protected String propertyNotInteger$str() {
        return "AMQ212043: Property {0} must be an Integer, it is {1}";
    }
    @Override
    public final void propertyNotLong(final String propName, final String name) {
        super.log.logv(FQCN, WARN, null, propertyNotLong$str(), propName, name);
    }
    protected String propertyNotLong$str() {
        return "AMQ212044: Property {0} must be a Long, it is {1}";
    }
    @Override
    public final void propertyNotBoolean(final String propName, final String name) {
        super.log.logv(FQCN, WARN, null, propertyNotBoolean$str(), propName, name);
    }
    protected String propertyNotBoolean$str() {
        return "AMQ212045: Property {0} must be a Boolean, it is {1}";
    }
    @Override
    public final void noVersionOnClasspath(final String classpath) {
        super.log.logv(FQCN, WARN, null, noVersionOnClasspath$str(), classpath);
    }
    protected String noVersionOnClasspath$str() {
        return "AMQ212046: Cannot find activemq-version.properties on classpath: {0}";
    }
    @Override
    public final void jvmAllocatedMoreMemory(final Long totalMemory1, final Long totalMemory2) {
        super.log.logv(FQCN, WARN, null, jvmAllocatedMoreMemory$str(), totalMemory1, totalMemory2);
    }
    protected String jvmAllocatedMoreMemory$str() {
        return "AMQ212047: Warning: JVM allocated more data what would make results invalid {0}:{1}";
    }
    @Override
    public final void broadcastGroupBindErrorRetry(final String hostAndPort, final Throwable t) {
        super.log.logv(FQCN, WARN, t, broadcastGroupBindErrorRetry$str(), hostAndPort);
    }
    protected String broadcastGroupBindErrorRetry$str() {
        return "AMQ212048: Random address ({0}) was already in use, trying another time";
    }
    @Override
    public final void ioDiscoveryError(final String hostAddress, final String s) {
        super.log.logv(FQCN, WARN, null, ioDiscoveryError$str(), hostAddress, s);
    }
    protected String ioDiscoveryError$str() {
        return "AMQ212049: Could not bind to {0} ({1} address); make sure your discovery group-address is of the same type as the IP stack (IPv4 or IPv6).\nIgnoring discovery group-address, but this may lead to cross talking.";
    }
    @Override
    public final void compressedLargeMessageError(final int length, final int nReadBytes) {
        super.log.logv(FQCN, WARN, null, compressedLargeMessageError$str(), length, nReadBytes);
    }
    protected String compressedLargeMessageError$str() {
        return "AMQ212050: Compressed large message tried to read {0} bytes from stream {1}";
    }
    @Override
    public final void invalidConcurrentSessionUsage(final Throwable t) {
        super.log.logv(FQCN, WARN, t, invalidConcurrentSessionUsage$str());
    }
    protected String invalidConcurrentSessionUsage$str() {
        return "AMQ212051: Invalid concurrent session usage. Sessions are not supposed to be used by more than one thread concurrently.";
    }
    @Override
    public final void packetOutOfOrder(final Object obj, final Throwable t) {
        super.log.logv(FQCN, WARN, t, packetOutOfOrder$str(), obj);
    }
    protected String packetOutOfOrder$str() {
        return "AMQ212052: Packet {0} was answered out of sequence due to a previous server timeout and it''s being ignored";
    }
    @Override
    public final void confirmationWindowDisabledWarning() {
        super.log.logv(FQCN, WARN, null, confirmationWindowDisabledWarning$str());
    }
    protected String confirmationWindowDisabledWarning$str() {
        return "AMQ212053: CompletionListener/SendAcknowledgementHandler used with confirmationWindowSize=-1. Enable confirmationWindowSize to receive acks from server!";
    }
    @Override
    public final void outOfCreditOnFlowControl(final String address) {
        super.log.logv(FQCN, WARN, null, outOfCreditOnFlowControl$str(), address);
    }
    protected String outOfCreditOnFlowControl$str() {
        return "AMQ212054: Destination address={0} is blocked. If the system is configured to block make sure you consume messages on this configuration.";
    }
    @Override
    public final void unableToCloseConsumer(final Exception e) {
        super.log.logv(FQCN, WARN, e, unableToCloseConsumer$str());
    }
    protected String unableToCloseConsumer$str() {
        return "AMQ212055: Unable to close consumer";
    }
    @Override
    public final void broadcastGroupBindError(final String hostAndPort) {
        super.log.logv(FQCN, WARN, null, broadcastGroupBindError$str(), hostAndPort);
    }
    protected String broadcastGroupBindError$str() {
        return "AMQ212056: local-bind-address specified for broadcast group but no local-bind-port. Using random port for UDP Broadcast ({0})";
    }
    @Override
    public final void timeoutStreamingLargeMessage() {
        super.log.logv(FQCN, WARN, null, timeoutStreamingLargeMessage$str());
    }
    protected String timeoutStreamingLargeMessage$str() {
        return "AMQ212057: Large Message Streaming is taking too long to flush on back pressure.";
    }
    @Override
    public final void unableToGetMessage(final Exception e) {
        super.log.logv(FQCN, WARN, e, unableToGetMessage$str());
    }
    protected String unableToGetMessage$str() {
        return "AMQ212058: Unable to get a message.";
    }
    @Override
    public final void failedCleaningUp(final String target) {
        super.log.logv(FQCN, WARN, null, failedCleaningUp$str(), target);
    }
    protected String failedCleaningUp$str() {
        return "AMQ212059: Failed to clean up: {0} ";
    }
    @Override
    public final void unexpectedNullDataReceived() {
        super.log.logv(FQCN, WARN, null, unexpectedNullDataReceived$str());
    }
    protected String unexpectedNullDataReceived$str() {
        return "AMQ212060: Unexpected null data received from DiscoveryEndpoint ";
    }
    @Override
    public final void failedForceClose(final Throwable e) {
        super.log.logv(FQCN, WARN, e, failedForceClose$str());
    }
    protected String failedForceClose$str() {
        return "AMQ212061: Failed to perform force close ";
    }
    @Override
    public final void failedPerformPostActionsOnMessage(final Exception e) {
        super.log.logv(FQCN, WARN, e, failedPerformPostActionsOnMessage$str());
    }
    protected String failedPerformPostActionsOnMessage$str() {
        return "AMQ212062: Failed to perform post actions on message processing ";
    }
    @Override
    public final void unableToHandleConnectionFailure(final Throwable e) {
        super.log.logv(FQCN, WARN, e, unableToHandleConnectionFailure$str());
    }
    protected String unableToHandleConnectionFailure$str() {
        return "AMQ212063: Unable to handle connection failure ";
    }
    @Override
    public final void unableToReceiveClusterTopology(final Throwable e) {
        super.log.logv(FQCN, WARN, e, unableToReceiveClusterTopology$str());
    }
    protected String unableToReceiveClusterTopology$str() {
        return "AMQ212064: Unable to receive cluster topology ";
    }
    @Override
    public final void unableToReceiveBroadcast(final Exception e, final String target) {
        super.log.logv(FQCN, WARN, e, unableToReceiveBroadcast$str(), target);
    }
    protected String unableToReceiveBroadcast$str() {
        return "AMQ212065: {0} getting exception when receiving broadcasting ";
    }
    @Override
    public final void unableToParseValue(final Throwable e) {
        super.log.logv(FQCN, WARN, e, unableToParseValue$str());
    }
    protected String unableToParseValue$str() {
        return "AMQ212066: failed to parse int property ";
    }
    @Override
    public final void unableToGetProperty(final Throwable e) {
        super.log.logv(FQCN, WARN, e, unableToGetProperty$str());
    }
    protected String unableToGetProperty$str() {
        return "AMQ212067: failed to get system property ";
    }
    @Override
    public final void unableToProcessGlobalThreadPoolIn10Sec() {
        super.log.logv(FQCN, WARN, null, unableToProcessGlobalThreadPoolIn10Sec$str());
    }
    protected String unableToProcessGlobalThreadPoolIn10Sec$str() {
        return "AMQ212068: Couldn't finish the client globalThreadPool in less than 10 seconds, interrupting it now ";
    }
    @Override
    public final void unableToProcessScheduledlIn10Sec() {
        super.log.logv(FQCN, WARN, null, unableToProcessScheduledlIn10Sec$str());
    }
    protected String unableToProcessScheduledlIn10Sec$str() {
        return "AMQ212069: Couldn't finish the client scheduled in less than 10 seconds, interrupting it now ";
    }
    @Override
    public final void unableToInitVersionLoader(final Throwable e) {
        super.log.logv(FQCN, WARN, e, unableToInitVersionLoader$str());
    }
    protected String unableToInitVersionLoader$str() {
        return "AMQ212070: Unable to initialize VersionLoader ";
    }
    @Override
    public final void unableToCheckEpollAvailability(final Throwable e) {
        super.log.logv(FQCN, WARN, e, unableToCheckEpollAvailability$str());
    }
    protected String unableToCheckEpollAvailability$str() {
        return "AMQ212071: Unable to check Epoll availability ";
    }
    @Override
    public final void failedToSetChannelReadyForWriting(final Throwable e) {
        super.log.logv(FQCN, WARN, e, failedToSetChannelReadyForWriting$str());
    }
    protected String failedToSetChannelReadyForWriting$str() {
        return "AMQ212072: Failed to change channel state to ReadyForWriting ";
    }
    @Override
    public final void unableToCheckKQueueAvailability(final Throwable e) {
        super.log.logv(FQCN, WARN, e, unableToCheckKQueueAvailability$str());
    }
    protected String unableToCheckKQueueAvailability$str() {
        return "AMQ212073: Unable to check KQueue availability ";
    }
    @Override
    public final void confirmationNotSet() {
        super.log.logv(FQCN, WARN, null, confirmationNotSet$str());
    }
    protected String confirmationNotSet$str() {
        return "AMQ212074: SendAcknowledgementHandler will not be asynchronous without setting up confirmation window size";
    }
    @Override
    public final void unableToCheckKQueueAvailabilityNoClass() {
        super.log.logv(FQCN, WARN, null, unableToCheckKQueueAvailabilityNoClass$str());
    }
    protected String unableToCheckKQueueAvailabilityNoClass$str() {
        return "AMQ212075: KQueue is not available, please add to the classpath or configure useKQueue=false to remove this warning";
    }
    @Override
    public final void unableToCheckEpollAvailabilitynoClass() {
        super.log.logv(FQCN, WARN, null, unableToCheckEpollAvailabilitynoClass$str());
    }
    protected String unableToCheckEpollAvailabilitynoClass$str() {
        return "AMQ212076: Epoll is not available, please add to the classpath or configure useEpoll=false to remove this warning";
    }
    @Override
    public final void broadcastTimeout(final int retry, final int maxretry) {
        super.log.logv(FQCN, WARN, null, broadcastTimeout$str(), retry, maxretry);
    }
    protected String broadcastTimeout$str() {
        return "AMQ212077: Timed out waiting to receive initial broadcast from cluster. Retry {0} of {1}";
    }
    @Override
    public final void ignoredParameterForDownstreamFederation(final String name) {
        super.log.logv(FQCN, WARN, null, ignoredParameterForDownstreamFederation$str(), name);
    }
    protected String ignoredParameterForDownstreamFederation$str() {
        return "AMQ212079: The upstream connector from the downstream federation will ignore url parameter {0}";
    }
    @Override
    public final void oldStoreProvider(final String value) {
        super.log.logv(FQCN, WARN, null, oldStoreProvider$str(), value);
    }
    protected String oldStoreProvider$str() {
        return "AMQ212080: Using legacy SSL store provider value: {0}. Please use either ''keyStoreType'' or ''trustStoreType'' instead as appropriate.";
    }
    @Override
    public final void onMessageError(final Throwable e) {
        super.log.logv(FQCN, ERROR, e, onMessageError$str());
    }
    protected String onMessageError$str() {
        return "AMQ214000: Failed to call onMessage";
    }
    @Override
    public final void failedToCleanupSession(final Exception e) {
        super.log.logv(FQCN, ERROR, e, failedToCleanupSession$str());
    }
    protected String failedToCleanupSession$str() {
        return "AMQ214001: failed to cleanup session";
    }
    @Override
    public final void failedToExecuteListener(final Throwable t) {
        super.log.logv(FQCN, ERROR, t, failedToExecuteListener$str());
    }
    protected String failedToExecuteListener$str() {
        return "AMQ214002: Failed to execute failure listener";
    }
    @Override
    public final void failedToHandleFailover(final Throwable t) {
        super.log.logv(FQCN, ERROR, t, failedToHandleFailover$str());
    }
    protected String failedToHandleFailover$str() {
        return "AMQ214003: Failed to handle failover";
    }
    @Override
    public final void errorCallingEnd(final Throwable t) {
        super.log.logv(FQCN, ERROR, t, errorCallingEnd$str());
    }
    protected String errorCallingEnd$str() {
        return "AMQ214004: XA end operation failed ";
    }
    @Override
    public final void errorCallingStart(final String message, final Integer code) {
        super.log.logv(FQCN, ERROR, null, errorCallingStart$str(), message, code);
    }
    protected String errorCallingStart$str() {
        return "AMQ214005: XA start operation failed {0} code:{1}";
    }
    @Override
    public final void sessionNotXA() {
        super.log.logv(FQCN, ERROR, null, sessionNotXA$str());
    }
    protected String sessionNotXA$str() {
        return "AMQ214006: Session is not XA";
    }
    @Override
    public final void receivedExceptionAsynchronously(final Exception e) {
        super.log.logv(FQCN, ERROR, e, receivedExceptionAsynchronously$str());
    }
    protected String receivedExceptionAsynchronously$str() {
        return "AMQ214007: Received exception asynchronously from server";
    }
    @Override
    public final void failedToHandlePacket(final Exception e) {
        super.log.logv(FQCN, ERROR, e, failedToHandlePacket$str());
    }
    protected String failedToHandlePacket$str() {
        return "AMQ214008: Failed to handle packet";
    }
    @Override
    public final void failedToStopDiscovery(final Throwable e) {
        super.log.logv(FQCN, ERROR, e, failedToStopDiscovery$str());
    }
    protected String failedToStopDiscovery$str() {
        return "AMQ214009: Failed to stop discovery group";
    }
    @Override
    public final void failedToReceiveDatagramInDiscovery(final Throwable e) {
        super.log.logv(FQCN, ERROR, e, failedToReceiveDatagramInDiscovery$str());
    }
    protected String failedToReceiveDatagramInDiscovery$str() {
        return "AMQ214010: Failed to receive datagram";
    }
    @Override
    public final void failedToCallListenerInDiscovery(final Throwable e) {
        super.log.logv(FQCN, ERROR, e, failedToCallListenerInDiscovery$str());
    }
    protected String failedToCallListenerInDiscovery$str() {
        return "AMQ214011: Failed to call discovery listener";
    }
    @Override
    public final void errorHandlingPacket(final Throwable t, final Packet packet) {
        super.log.logv(FQCN, ERROR, t, errorHandlingPacket$str(), packet);
    }
    protected String errorHandlingPacket$str() {
        return "AMQ214012: Unexpected error handling packet {0}";
    }
    @Override
    public final void errorDecodingPacket(final Throwable e) {
        super.log.logv(FQCN, ERROR, e, errorDecodingPacket$str());
    }
    protected String errorDecodingPacket$str() {
        return "AMQ214013: Failed to decode packet";
    }
    @Override
    public final void errorCallingFailureListener(final Throwable e) {
        super.log.logv(FQCN, ERROR, e, errorCallingFailureListener$str());
    }
    protected String errorCallingFailureListener$str() {
        return "AMQ214014: Failed to execute failure listener";
    }
    @Override
    public final void errorCallingLifeCycleListener(final Throwable e) {
        super.log.logv(FQCN, ERROR, e, errorCallingLifeCycleListener$str());
    }
    protected String errorCallingLifeCycleListener$str() {
        return "AMQ214015: Failed to execute connection life cycle listener";
    }
    @Override
    public final void errorCreatingNettyConnection(final Throwable e) {
        super.log.logv(FQCN, ERROR, e, errorCreatingNettyConnection$str());
    }
    protected String errorCreatingNettyConnection$str() {
        return "AMQ214016: Failed to create netty connection";
    }
    @Override
    public final void caughtunexpectedThrowable(final Throwable t) {
        super.log.logv(FQCN, ERROR, t, caughtunexpectedThrowable$str());
    }
    protected String caughtunexpectedThrowable$str() {
        return "AMQ214017: Caught unexpected Throwable";
    }
    @Override
    public final void errorOnXMLTransform(final Throwable t, final Node n) {
        super.log.logv(FQCN, ERROR, t, errorOnXMLTransform$str(), n);
    }
    protected String errorOnXMLTransform$str() {
        return "AMQ214018: Failed to invoke getTextContent() on node {0}";
    }
    @Override
    public final void errorOnXMLTransformInvalidConf(final Throwable t) {
        super.log.logv(FQCN, ERROR, t, errorOnXMLTransformInvalidConf$str());
    }
    protected String errorOnXMLTransformInvalidConf$str() {
        return "AMQ214019: Invalid configuration";
    }
    @Override
    public final void errorStoppingDiscoveryBroadcastEndpoint(final Object endpoint, final Throwable t) {
        super.log.logv(FQCN, ERROR, t, errorStoppingDiscoveryBroadcastEndpoint$str(), endpoint);
    }
    protected String errorStoppingDiscoveryBroadcastEndpoint$str() {
        return "AMQ214020: Exception happened while stopping Discovery BroadcastEndpoint {0}";
    }
    @Override
    public final void invalidCipherSuite(final String validSuites) {
        super.log.logv(FQCN, ERROR, null, invalidCipherSuite$str(), validSuites);
    }
    protected String invalidCipherSuite$str() {
        return "AMQ214021: Invalid cipher suite specified. Supported cipher suites are: {0}";
    }
    @Override
    public final void invalidProtocol(final String validProtocols) {
        super.log.logv(FQCN, ERROR, null, invalidProtocol$str(), validProtocols);
    }
    protected String invalidProtocol$str() {
        return "AMQ214022: Invalid protocol specified. Supported protocols are: {0}";
    }
    @Override
    public final void httpHandshakeFailed(final Object msg) {
        super.log.logf(FQCN, DEBUG, null, httpHandshakeFailed$str(), msg);
    }
    protected String httpHandshakeFailed$str() {
        return "AMQ214023: HTTP Handshake failed, received %s";
    }
    @Override
    public final void httpUpgradeNotSupportedByRemoteAcceptor() {
        super.log.logf(FQCN, ERROR, null, httpUpgradeNotSupportedByRemoteAcceptor$str());
    }
    protected String httpUpgradeNotSupportedByRemoteAcceptor$str() {
        return "AMQ214024: HTTP upgrade not supported by remote acceptor";
    }
    @Override
    public final void invalidCFType(final String type, final String uri) {
        super.log.logv(FQCN, ERROR, null, invalidCFType$str(), type, uri);
    }
    protected String invalidCFType$str() {
        return "AMQ214025: Invalid type {0}, Using default connection factory at {1}";
    }
    @Override
    public final void failoverOrReconnect(final Object connectionID, final Throwable cause) {
        super.log.logv(FQCN, TRACE, cause, failoverOrReconnect$str(), connectionID);
    }
    protected String failoverOrReconnect$str() {
        return "AMQ214026: Failure captured on connectionID={0}, performing failover or reconnection now";
    }
    @Override
    public final void replayingCommands(final Object connectionID, final int lastConfirmedCommandID) {
        super.log.logv(FQCN, DEBUG, null, replayingCommands$str(), connectionID, lastConfirmedCommandID);
    }
    protected String replayingCommands$str() {
        return "AMQ214027: Replaying commands for channelID={0} with lastCommandID from the server={1}";
    }
    @Override
    public final void reconnectCreatingNewSession(final long id) {
        super.log.logv(FQCN, DEBUG, null, reconnectCreatingNewSession$str(), id);
    }
    protected String reconnectCreatingNewSession$str() {
        return "AMQ214028: Couldn't reattach session {0}, performing as a failover operation now and recreating objects";
    }
    @Override
    public final void unexpectedResponseFromHttpServer(final Object response) {
        super.log.logf(FQCN, ERROR, null, unexpectedResponseFromHttpServer$str(), response);
    }
    protected String unexpectedResponseFromHttpServer$str() {
        return "AMQ214029: Unexpected response from HTTP server: %s";
    }
    @Override
    public final void failedToBind(final String p1, final String p2, final Throwable cause) {
        super.log.logv(FQCN, ERROR, cause, failedToBind$str(), p1, p2);
    }
    protected String failedToBind$str() {
        return "AMQ214030: Failed to bind {0}={1}";
    }
    @Override
    public final void disconnectOnErrorDecoding(final Throwable cause) {
        super.log.logv(FQCN, ERROR, cause, disconnectOnErrorDecoding$str());
    }
    protected String disconnectOnErrorDecoding$str() {
        return "AMQ214031: Failed to decode buffer, disconnect immediately.";
    }
    @Override
    public final void unableToInitVersionLoaderError(final Throwable e) {
        super.log.logv(FQCN, ERROR, e, unableToInitVersionLoaderError$str());
    }
    protected String unableToInitVersionLoaderError$str() {
        return "AMQ214032: Unable to initialize VersionLoader ";
    }
    @Override
    public final void unableToResolveHost(final UnknownHostException e) {
        super.log.logv(FQCN, ERROR, e, unableToResolveHost$str());
    }
    protected String unableToResolveHost$str() {
        return "AMQ214033: Cannot resolve host ";
    }
}
