/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.discovery;

import org.wildfly.discovery.AttributeValue;

final class NumericAttributeValue
extends AttributeValue {
    private static final long serialVersionUID = -5223377657098950186L;
    private final int value;

    NumericAttributeValue(int value) {
        this.value = value;
    }

    @Override
    String generateToString() {
        return Integer.toString(this.value);
    }

    @Override
    public int compareTo(AttributeValue other) {
        if (other instanceof NumericAttributeValue) {
            return Integer.signum(this.value - ((NumericAttributeValue)other).value);
        }
        return super.compareTo(other);
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof NumericAttributeValue && this.equals((NumericAttributeValue)obj);
    }

    @Override
    public boolean equals(AttributeValue obj) {
        return obj instanceof NumericAttributeValue && this.equals((NumericAttributeValue)obj);
    }

    public boolean equals(NumericAttributeValue obj) {
        return obj == this || obj != null && this.value == obj.value;
    }

    public int hashCode() {
        return this.value;
    }

    @Override
    int getKind() {
        return 1;
    }

    @Override
    public boolean isNumeric() {
        return true;
    }

    @Override
    public int asInt() {
        return this.value;
    }
}

