/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.kafka.admin;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.impl.JsonUtil;
import io.vertx.kafka.admin.ConsumerGroupDescription;
import io.vertx.kafka.admin.MemberDescription;
import io.vertx.kafka.client.common.Node;
import java.util.ArrayList;
import java.util.Base64;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.ConsumerGroupState;
import org.apache.kafka.common.acl.AclOperation;

public class ConsumerGroupDescriptionConverter {
    private static final Base64.Decoder BASE64_DECODER = JsonUtil.BASE64_DECODER;
    private static final Base64.Encoder BASE64_ENCODER = JsonUtil.BASE64_ENCODER;

    public static void fromJson(Iterable<Map.Entry<String, Object>> json, ConsumerGroupDescription obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "authorizedOperations": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    LinkedHashSet<AclOperation> list = new LinkedHashSet();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add(AclOperation.valueOf((String)((String)item)));
                        }
                    });
                    obj.setAuthorizedOperations(list);
                    break;
                }
                case "coordinator": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setCoordinator(new Node((JsonObject)member.getValue()));
                    break;
                }
                case "groupId": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setGroupId((String)member.getValue());
                    break;
                }
                case "members": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    LinkedHashSet<AclOperation> list = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof JsonObject) {
                            list.add((AclOperation)new MemberDescription((JsonObject)item));
                        }
                    });
                    obj.setMembers((List<MemberDescription>)((Object)list));
                    break;
                }
                case "partitionAssignor": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setPartitionAssignor((String)member.getValue());
                    break;
                }
                case "simpleConsumerGroup": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setSimpleConsumerGroup((Boolean)member.getValue());
                    break;
                }
                case "state": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setState(ConsumerGroupState.valueOf((String)((String)member.getValue())));
                }
            }
        }
    }

    public static void toJson(ConsumerGroupDescription obj, JsonObject json) {
        ConsumerGroupDescriptionConverter.toJson(obj, json.getMap());
    }

    public static void toJson(ConsumerGroupDescription obj, Map<String, Object> json) {
        JsonArray array;
        if (obj.getAuthorizedOperations() != null) {
            array = new JsonArray();
            obj.getAuthorizedOperations().forEach(item -> array.add((Object)item.name()));
            json.put("authorizedOperations", array);
        }
        if (obj.getCoordinator() != null) {
            json.put("coordinator", obj.getCoordinator().toJson());
        }
        if (obj.getGroupId() != null) {
            json.put("groupId", obj.getGroupId());
        }
        if (obj.getMembers() != null) {
            array = new JsonArray();
            obj.getMembers().forEach(item -> array.add((Object)item.toJson()));
            json.put("members", array);
        }
        if (obj.getPartitionAssignor() != null) {
            json.put("partitionAssignor", obj.getPartitionAssignor());
        }
        json.put("simpleConsumerGroup", obj.isSimpleConsumerGroup());
        if (obj.getState() != null) {
            json.put("state", obj.getState().name());
        }
    }
}

