/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands;

import io.airlift.airline.Command;
import io.airlift.airline.Option;
import java.io.File;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.cli.Artemis;
import org.apache.activemq.artemis.cli.commands.ActionContext;
import org.apache.activemq.artemis.cli.commands.tools.LockAbstract;
import org.apache.activemq.artemis.cli.factory.BrokerFactory;
import org.apache.activemq.artemis.cli.factory.jmx.ManagementFactory;
import org.apache.activemq.artemis.cli.factory.security.SecurityManagerFactory;
import org.apache.activemq.artemis.components.ExternalComponent;
import org.apache.activemq.artemis.core.server.ActivateCallback;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.management.ManagementContext;
import org.apache.activemq.artemis.dto.BrokerDTO;
import org.apache.activemq.artemis.dto.ComponentDTO;
import org.apache.activemq.artemis.dto.ManagementContextDTO;
import org.apache.activemq.artemis.integration.Broker;
import org.apache.activemq.artemis.integration.bootstrap.ActiveMQBootstrapLogger;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;
import org.apache.activemq.artemis.utils.ReusableLatch;

@Command(name="run", description="runs the broker instance")
public class Run
extends LockAbstract {
    @Option(name={"--allow-kill"}, description="This will allow the server to kill itself. Useful for tests (failover tests for instance)")
    boolean allowKill;
    @Option(name={"--properties"}, description="A file url to a properties file that is applied to the server's internal ConfigurationImpl bean")
    String properties;
    private static boolean embedded = false;
    public static final ReusableLatch latchRunning = new ReusableLatch(0);
    private ManagementContext managementContext;
    private Timer shutdownTimer;
    private Broker server;

    public static void setEmbedded(boolean embedded) {
        Run.embedded = true;
    }

    @Override
    public Object execute(ActionContext context) throws Exception {
        super.execute(context);
        AtomicReference<Throwable> serverActivationFailed = new AtomicReference<Throwable>();
        try {
            File propertiesFileFromEtc;
            BrokerDTO broker = this.getBrokerDTO();
            ActiveMQSecurityManager securityManager = SecurityManagerFactory.create(broker.security);
            ManagementContextDTO managementDTO = this.getManagementDTO();
            this.managementContext = ManagementFactory.create(managementDTO, securityManager);
            Artemis.printBanner(this.getActionContext().out);
            this.addShutdownHook(broker.server.getConfigurationFile().getParentFile());
            ActivateCallback activateCallback = new ActivateCallback(){

                public void preActivate() {
                    try {
                        Run.this.managementContext.start();
                    }
                    catch (Exception e) {
                        ActiveMQServerLogger.LOGGER.unableStartManagementContext(e);
                        return;
                    }
                    try {
                        Run.this.server.getServer().getManagementService().registerHawtioSecurity(Run.this.managementContext.getArtemisMBeanServerGuard());
                    }
                    catch (Exception e) {
                        ActiveMQServerLogger.LOGGER.unableToDeployHawtioMBean(e);
                    }
                }

                public void deActivate() {
                    try {
                        Run.this.server.getServer().getManagementService().unregisterHawtioSecurity();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            this.server = BrokerFactory.createServer(broker.server, securityManager, activateCallback);
            this.server.createComponents();
            this.server.getServer().registerActivationFailureListener(exception -> serverActivationFailed.set(exception));
            if (this.properties == null && (propertiesFileFromEtc = new File(this.getBrokerEtc(), "broker.properties")).exists()) {
                this.properties = propertiesFileFromEtc.getAbsolutePath();
            }
            this.server.getServer().setProperties(this.properties);
            this.server.start();
            this.server.getServer().addExternalComponent((ActiveMQComponent)this.managementContext, false);
            if (broker.web != null) {
                broker.components.add(broker.web);
            }
            for (ComponentDTO componentDTO : broker.components) {
                Class<?> clazz = this.getClass().getClassLoader().loadClass(componentDTO.componentClassName);
                ExternalComponent component = (ExternalComponent)clazz.getDeclaredConstructor(null).newInstance(new Object[0]);
                component.configure(componentDTO, this.getBrokerInstance(), this.getBrokerHome());
                this.server.getServer().addExternalComponent((ActiveMQComponent)component, true);
                assert (component.isStarted());
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            serverActivationFailed.set(t);
            latchRunning.countDown();
        }
        if (serverActivationFailed.get() != null) {
            this.stop();
            return serverActivationFailed.get();
        }
        return new Pair((Object)this.managementContext, (Object)this.server.getServer());
    }

    private void addShutdownHook(File configurationDir) {
        File fileKill;
        latchRunning.countUp();
        final File file = new File(configurationDir, "STOP_ME");
        if (file.exists() && !file.delete()) {
            ActiveMQBootstrapLogger.LOGGER.errorDeletingFile(file.getAbsolutePath());
        }
        if ((fileKill = new File(configurationDir, "KILL_ME")).exists() && !fileKill.delete()) {
            ActiveMQBootstrapLogger.LOGGER.errorDeletingFile(fileKill.getAbsolutePath());
        }
        this.shutdownTimer = new Timer("ActiveMQ Artemis Server Shutdown Timer", true);
        this.shutdownTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                if (Run.this.allowKill && fileKill.exists()) {
                    try {
                        System.err.println("Halting by user request");
                        fileKill.delete();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    Runtime.getRuntime().halt(0);
                }
                if (file.exists()) {
                    try {
                        Run.this.stop();
                        Run.this.shutdownTimer.cancel();
                    }
                    finally {
                        Run.this.getActionContext().out.println("Server stopped!");
                        Run.this.getActionContext().out.flush();
                        latchRunning.countDown();
                        if (!embedded) {
                            Runtime.getRuntime().exit(0);
                        }
                    }
                }
            }
        }, 500L, 500L);
        Runtime.getRuntime().addShutdownHook(new Thread("shutdown-hook"){

            @Override
            public void run() {
                Run.this.stop();
            }
        });
    }

    protected void stop() {
        try {
            if (this.server != null) {
                this.server.stop(true);
            }
            if (this.managementContext != null) {
                this.managementContext.stop();
            }
            if (this.shutdownTimer != null) {
                this.shutdownTimer.cancel();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

