/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jdr;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.CapabilityServiceTarget;
import org.jboss.as.controller.LocalModelControllerClient;
import org.jboss.as.controller.ModelControllerClientFactory;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.jdr.JdrReport;
import org.jboss.as.jdr.JdrReportCollector;
import org.jboss.as.jdr.JdrReportSubsystemDefinition;
import org.jboss.as.jdr.JdrRunner;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerEnvironmentService;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;

class JdrReportService
implements JdrReportCollector,
Service {
    private final Consumer<JdrReportCollector> subsystemConsumer;
    private final Consumer<JdrReportCollector> mscConsumer;
    private final Supplier<ServerEnvironment> serverEnvironmentSupplier;
    private final Supplier<ModelControllerClientFactory> clientFactorySupplier;
    private final Supplier<ExecutorService> executorServiceSupplier;

    static void addService(CapabilityServiceTarget target, Consumer<JdrReportCollector> subsystemConsumer) {
        CapabilityServiceBuilder builder = target.addCapability(JdrReportSubsystemDefinition.JDR_CAPABILITY);
        Consumer mscConsumer = builder.provides(new RuntimeCapability[]{JdrReportSubsystemDefinition.JDR_CAPABILITY});
        Supplier mcfSupplier = builder.requiresCapability("org.wildfly.management.model-controller-client-factory", ModelControllerClientFactory.class, new String[0]);
        Supplier esSupplier = builder.requiresCapability("org.wildfly.management.executor", ExecutorService.class, new String[0]);
        Supplier seSupplier = builder.requires(ServerEnvironmentService.SERVICE_NAME);
        builder.setInstance((Service)new JdrReportService(subsystemConsumer, mscConsumer, mcfSupplier, esSupplier, seSupplier)).setInitialMode(ServiceController.Mode.ACTIVE).install();
    }

    private JdrReportService(Consumer<JdrReportCollector> subsystemConsumer, Consumer<JdrReportCollector> consumer, Supplier<ModelControllerClientFactory> mcfSupplier, Supplier<ExecutorService> executorServiceSupplier, Supplier<ServerEnvironment> seSupplier) {
        this.subsystemConsumer = subsystemConsumer;
        this.mscConsumer = consumer;
        this.serverEnvironmentSupplier = seSupplier;
        this.clientFactorySupplier = mcfSupplier;
        this.executorServiceSupplier = executorServiceSupplier;
    }

    @Override
    public JdrReport collect() throws OperationFailedException {
        try (LocalModelControllerClient client = this.clientFactorySupplier.get().createSuperUserClient((Executor)this.executorServiceSupplier.get());){
            JdrRunner runner = new JdrRunner(true);
            ServerEnvironment serverEnvironment = this.serverEnvironmentSupplier.get();
            runner.setJbossHomeDir(serverEnvironment.getHomeDir().getAbsolutePath());
            runner.setReportLocationDir(serverEnvironment.getServerTempDir().getAbsolutePath());
            runner.setControllerClient((ModelControllerClient)client);
            runner.setHostControllerName(serverEnvironment.getHostControllerName());
            runner.setServerName(serverEnvironment.getServerName());
            JdrReport jdrReport = runner.collect();
            return jdrReport;
        }
    }

    public synchronized void start(StartContext context) {
        this.mscConsumer.accept(this);
        this.subsystemConsumer.accept(this);
    }

    public synchronized void stop(StopContext context) {
        this.mscConsumer.accept(null);
        this.subsystemConsumer.accept(null);
    }
}

