/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.addons.transports.udp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.URI;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.LoadingByteArrayOutputStream;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.AbstractDestination;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.workqueue.AutomaticWorkQueue;
import org.apache.cxf.workqueue.WorkQueueManager;
import org.apache.cxf.ws.addressing.EndpointReferenceType;

public class UDPDestination
extends AbstractDestination {
    private static final org.jboss.logging.Logger LOG = org.jboss.logging.Logger.getLogger(UDPDestination.class);
    private static final Logger JAVA_LOG = LogUtils.getL7dLogger(UDPDestination.class);
    AutomaticWorkQueue queue;
    volatile DatagramSocket socket;

    public UDPDestination(Bus b, EndpointReferenceType ref, EndpointInfo ei) {
        super(b, ref, ei);
    }

    protected Conduit getInbuiltBackChannel(Message inMessage) {
        if (inMessage.getExchange().isOneWay()) {
            return null;
        }
        final UDPConnectionInfo info = (UDPConnectionInfo)inMessage.get(UDPConnectionInfo.class);
        return new AbstractDestination.AbstractBackChannelConduit(){

            public void prepare(Message message) throws IOException {
                message.setContent(OutputStream.class, (Object)info.out);
            }
        };
    }

    protected Logger getLogger() {
        return JAVA_LOG;
    }

    protected void activate() {
        WorkQueueManager queuem = (WorkQueueManager)this.bus.getExtension(WorkQueueManager.class);
        this.queue = queuem.getNamedWorkQueue("udp-transport");
        if (this.queue == null) {
            this.queue = queuem.getAutomaticWorkQueue();
        }
        try {
            Object s;
            URI uri = new URI(this.getAddress().getAddress().getValue());
            InetSocketAddress isa = null;
            if (StringUtils.isEmpty((String)uri.getHost())) {
                s = uri.getSchemeSpecificPart();
                if (((String)s).startsWith("//:")) {
                    s = ((String)s).substring(3);
                }
                if (((String)s).indexOf(47) != -1) {
                    s = ((String)s).substring(0, ((String)s).indexOf(47));
                }
                int port = Integer.parseInt((String)s);
                isa = new InetSocketAddress(port);
            } else {
                isa = new InetSocketAddress(uri.getHost(), uri.getPort());
            }
            if (isa.getAddress().isMulticastAddress()) {
                s = new MulticastSocket(null);
                ((MulticastSocket)s).setTimeToLive(1);
                ((DatagramSocket)s).bind(new InetSocketAddress(isa.getPort()));
                ((MulticastSocket)s).joinGroup(isa.getAddress());
            } else {
                s = new DatagramSocket(null);
                ((DatagramSocket)s).bind(new InetSocketAddress(isa.getAddress(), isa.getPort()));
            }
            ((DatagramSocket)s).setReuseAddress(true);
            ((DatagramSocket)s).setReceiveBufferSize(65536);
            ((DatagramSocket)s).setSendBufferSize(65536);
            this.socket = s;
            this.queue.execute((Runnable)new SocketListener());
        }
        catch (Exception ex) {
            LOG.error((Object)ex.toString());
            throw new RuntimeException(ex);
        }
    }

    protected void deactivate() {
        if (this.socket != null) {
            DatagramSocket s = this.socket;
            this.socket = null;
            s.close();
        }
    }

    static class UDPConnectionInfo {
        final OutputStream out;
        final InputStream in;

        public UDPConnectionInfo(OutputStream o, InputStream i) {
            this.out = o;
            this.in = i;
        }
    }

    class SocketListener
    implements Runnable {
        SocketListener() {
        }

        @Override
        public void run() {
            while (UDPDestination.this.socket != null) {
                try {
                    byte[] bytes = new byte[65536];
                    final DatagramPacket p = new DatagramPacket(bytes, bytes.length);
                    UDPDestination.this.socket.receive(p);
                    LoadingByteArrayOutputStream out = new LoadingByteArrayOutputStream(){

                        public void close() throws IOException {
                            super.close();
                            DatagramPacket p2 = new DatagramPacket(this.getRawBytes(), 0, this.size(), p.getSocketAddress());
                            UDPDestination.this.socket.send(p2);
                        }
                    };
                    UDPConnectionInfo info = new UDPConnectionInfo((OutputStream)out, new ByteArrayInputStream(bytes, 0, p.getLength()));
                    final MessageImpl m = new MessageImpl();
                    ExchangeImpl exchange = new ExchangeImpl();
                    exchange.setDestination((Destination)UDPDestination.this);
                    m.setDestination((Destination)UDPDestination.this);
                    exchange.setInMessage((Message)m);
                    m.setContent(InputStream.class, (Object)info.in);
                    m.put(UDPConnectionInfo.class, (Object)info);
                    UDPDestination.this.queue.execute(new Runnable(){

                        @Override
                        public void run() {
                            UDPDestination.this.getMessageObserver().onMessage((Message)m);
                        }
                    });
                    continue;
                }
                catch (IOException e) {
                    if (UDPDestination.this.socket == null) continue;
                    LOG.error((Object)e.toString());
                    continue;
                }
                break;
            }
            return;
        }
    }
}

