/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.operators.multi.AbstractMultiOperator;
import io.smallrye.mutiny.operators.multi.MultiOperatorProcessor;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import java.util.concurrent.Executor;
import java.util.concurrent.Flow;
import java.util.concurrent.RejectedExecutionException;

public class MultiSubscribeOnOp<T>
extends AbstractMultiOperator<T, T> {
    private final Executor executor;

    public MultiSubscribeOnOp(Multi<? extends T> upstream, Executor executor) {
        super(upstream);
        this.executor = ParameterValidation.nonNull(executor, "executor");
    }

    @Override
    public void subscribe(MultiSubscriber<? super T> downstream) {
        SubscribeOnProcessor<? super T> sub = new SubscribeOnProcessor<T>(downstream, this.executor);
        sub.scheduleSubscription(this.upstream, downstream);
    }

    static final class SubscribeOnProcessor<T>
    extends MultiOperatorProcessor<T, T> {
        private final Executor executor;

        SubscribeOnProcessor(MultiSubscriber<? super T> downstream, Executor executor) {
            super(downstream);
            this.executor = executor;
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            if (this.compareAndSetUpstreamSubscription(null, subscription)) {
                this.downstream.onSubscribe(this);
            } else {
                subscription.cancel();
            }
        }

        void requestUpstream(long n, Flow.Subscription s) {
            try {
                this.executor.execute(() -> s.request(n));
            }
            catch (RejectedExecutionException rejected) {
                super.onFailure(rejected);
            }
        }

        void scheduleSubscription(Multi<? extends T> upstream, Flow.Subscriber<? super T> downstream) {
            block2: {
                try {
                    this.executor.execute(() -> upstream.subscribe().withSubscriber(this));
                }
                catch (RejectedExecutionException rejected) {
                    if (this.isDone()) break block2;
                    downstream.onError(rejected);
                }
            }
        }

        @Override
        public void onItem(T t) {
            this.downstream.onItem(t);
        }

        @Override
        public void request(long n) {
            if (n > 0L) {
                Flow.Subscription subscription = this.getUpstreamSubscription();
                this.requestUpstream(n, subscription);
            }
        }
    }
}

