/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl;

import java.util.List;
import java.util.NoSuchElementException;
import org.hibernate.search.engine.search.query.SearchScroll;
import org.hibernate.search.engine.search.query.SearchScrollResult;
import org.infinispan.commons.util.CloseableIterator;

public class ScrollerIteratorAdaptor<E>
implements CloseableIterator<E> {
    private final SearchScroll<E> scroll;
    private SearchScrollResult<E> scrollResult;
    private List<E> chunk;
    private int cursor = 0;

    public ScrollerIteratorAdaptor(SearchScroll<E> scroll) {
        this.scroll = scroll;
        this.scrollResult = scroll.next();
        this.chunk = this.scrollResult.hits();
    }

    public boolean hasNext() {
        this.tryFetchMore();
        return this.scrollResult.hasHits();
    }

    public E next() {
        if (this.hasNext()) {
            return this.chunk.get(this.cursor++);
        }
        throw new NoSuchElementException();
    }

    private void tryFetchMore() {
        if (this.cursor == this.chunk.size()) {
            this.scrollResult = this.scroll.next();
            this.chunk = this.scrollResult.hits();
            this.cursor = 0;
        }
    }

    public void close() {
        this.scroll.close();
    }
}

