/*
 * Decompiled with CFR 0.152.
 */
package mutiny.zero.operators;

import java.util.Objects;
import java.util.concurrent.Flow;
import java.util.function.Predicate;
import mutiny.zero.operators.ProcessorBase;

public class Retry<T>
implements Flow.Publisher<T> {
    private final Flow.Publisher<T> upstream;
    private final Predicate<Throwable> retryPredicate;

    public static Predicate<Throwable> always() {
        return err -> true;
    }

    public static Predicate<Throwable> atMost(final int count) {
        if (count <= 0) {
            throw new IllegalArgumentException("count must be strictly positive");
        }
        return new Predicate<Throwable>(){
            int n;

            @Override
            public boolean test(Throwable throwable) {
                if (this.n == count) {
                    return false;
                }
                ++this.n;
                return true;
            }
        };
    }

    public Retry(Flow.Publisher<T> upstream, Predicate<Throwable> retryPredicate) {
        this.upstream = Objects.requireNonNull(upstream, "The upstream cannot be null");
        this.retryPredicate = Objects.requireNonNull(retryPredicate, "The retry predicate cannot be null");
    }

    @Override
    public void subscribe(Flow.Subscriber<? super T> subscriber) {
        Objects.requireNonNull(subscriber, "The subscriber cannot be null");
        Processor processor = new Processor();
        processor.subscribe(subscriber);
        this.upstream.subscribe(processor);
    }

    private class Processor
    extends ProcessorBase<T, T> {
        private Processor() {
        }

        @Override
        public void onNext(T item) {
            if (!this.cancelled()) {
                this.downstream().onNext(item);
            }
        }

        @Override
        public void onError(Throwable err) {
            if (!this.cancelled()) {
                boolean retry;
                try {
                    retry = Retry.this.retryPredicate.test(err);
                }
                catch (Throwable t) {
                    this.cancel();
                    this.downstream().onError(t);
                    return;
                }
                if (retry) {
                    Retry.this.upstream.subscribe(this);
                } else {
                    this.cancel();
                    this.downstream().onError(err);
                }
            }
        }
    }
}

