/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys;

import java.io.IOException;
import java.net.ProtocolException;
import java.security.GeneralSecurityException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import javax.security.auth.login.FailedLoginException;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.GenericUtils;

@FunctionalInterface
public interface FilePasswordProvider {
    public static final FilePasswordProvider EMPTY = (session, resourceKey, retryIndex) -> null;

    public String getPassword(SessionContext var1, NamedResource var2, int var3) throws IOException;

    default public ResourceDecodeResult handleDecodeAttemptResult(SessionContext session, NamedResource resourceKey, int retryIndex, String password, Exception err) throws IOException, GeneralSecurityException {
        return ResourceDecodeResult.TERMINATE;
    }

    default public <T> T decode(SessionContext session, NamedResource resourceKey, Decoder<? extends T> decoder) throws IOException, GeneralSecurityException {
        int retryCount = 0;
        while (true) {
            String pwd2;
            if (GenericUtils.isEmpty(pwd2 = this.getPassword(session, resourceKey, retryCount))) {
                throw new FailedLoginException("No password data for encrypted resource=" + resourceKey);
            }
            try {
                T result = decoder.decode(pwd2);
                this.handleDecodeAttemptResult(session, resourceKey, retryCount, pwd2, null);
                return result;
            }
            catch (IOException | RuntimeException | GeneralSecurityException e) {
                ResourceDecodeResult result = this.handleDecodeAttemptResult(session, resourceKey, retryCount, pwd2, e);
                if (result == null) {
                    throw e;
                }
                switch (result) {
                    case TERMINATE: {
                        throw e;
                    }
                    case RETRY: {
                        break;
                    }
                    case IGNORE: {
                        return null;
                    }
                    default: {
                        throw new ProtocolException("Unsupported decode attempt result (" + (Object)((Object)result) + ") for " + resourceKey);
                    }
                }
                ++retryCount;
                continue;
            }
            break;
        }
    }

    public static FilePasswordProvider of(String password) {
        return (session, resource, index) -> password;
    }

    public static enum ResourceDecodeResult {
        TERMINATE,
        RETRY,
        IGNORE;

        public static final Set<ResourceDecodeResult> VALUES;

        static {
            VALUES = Collections.unmodifiableSet(EnumSet.allOf(ResourceDecodeResult.class));
        }
    }

    public static interface Decoder<T> {
        public T decode(String var1) throws IOException, GeneralSecurityException;
    }
}

