/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.as.cli.CommandHandler;

public class CommandRegistry {
    private final Map<String, CommandHandler> handlers = new HashMap<String, CommandHandler>();
    private final Set<String> tabCompletionCommands = new HashSet<String>();

    public void registerHandler(CommandHandler handler, String ... names) {
        this.registerHandler(handler, true, names);
    }

    public void registerHandler(CommandHandler handler, boolean tabComplete, String ... names) {
        for (String name : names) {
            CommandHandler previous = this.handlers.put(name, handler);
            if (previous == null) continue;
            throw new IllegalStateException("Duplicate command name '" + name + "'. Handlers: " + previous + ", " + handler);
        }
        if (tabComplete) {
            this.tabCompletionCommands.add(names[0]);
        }
    }

    public Set<String> getTabCompletionCommands() {
        return this.tabCompletionCommands;
    }

    public CommandHandler getCommandHandler(String command) {
        return this.handlers.get(command);
    }

    public CommandHandler remove(String cmdName) {
        if (cmdName == null) {
            throw new IllegalArgumentException();
        }
        CommandHandler handler = this.handlers.remove(cmdName);
        if (handler != null) {
            this.tabCompletionCommands.remove(cmdName);
        }
        return handler;
    }
}

