/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers.ifelse;

import java.io.IOException;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.batch.Batch;
import org.jboss.as.cli.batch.BatchManager;
import org.jboss.as.cli.handlers.CommandHandlerWithHelp;
import org.jboss.as.cli.handlers.ifelse.IfElseBlock;
import org.jboss.as.cli.handlers.ifelse.Operation;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;

public class EndIfHandler
extends CommandHandlerWithHelp {
    public EndIfHandler() {
        super("end-if", true);
    }

    @Override
    public boolean isAvailable(CommandContext ctx) {
        try {
            IfElseBlock ifBlock = IfElseBlock.get(ctx);
            return ifBlock != null;
        }
        catch (CommandLineException e) {
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void doHandle(CommandContext ctx) throws CommandLineException {
        ModelNode targetValue;
        IfElseBlock ifBlock = IfElseBlock.remove(ctx);
        BatchManager batchManager = ctx.getBatchManager();
        if (!batchManager.isBatchActive()) {
            if (!ifBlock.isInIf()) throw new CommandLineException("else block did not activate batch mode.");
            throw new CommandLineException("if block did not activate batch mode.");
        }
        Batch batch = batchManager.getActiveBatch();
        batchManager.discardActiveBatch();
        ModelControllerClient client = ctx.getModelControllerClient();
        if (client == null) {
            throw new CommandLineException("The connection to the controller has not been established.");
        }
        ModelNode conditionRequest = ifBlock.getConditionRequest();
        if (conditionRequest == null) {
            throw new CommandLineException("The condition request is not available.");
        }
        Operation expression = ifBlock.getConditionExpression();
        if (expression == null) {
            throw new CommandLineException("The if expression is not available.");
        }
        try {
            targetValue = client.execute(conditionRequest);
        }
        catch (IOException e) {
            throw new CommandLineException("condition request failed", e);
        }
        Object value = expression.resolveValue(ctx, targetValue);
        if (value == null) {
            throw new CommandLineException("if expression resolved to a null");
        }
        if (Boolean.TRUE.equals(value)) {
            ModelNode ifRequest = ifBlock.getIfRequest();
            if (ifRequest == null) {
                if (batch.size() == 0) {
                    throw new CommandLineException("if request is missing.");
                }
                ifRequest = batch.toRequest();
            }
            try {
                ModelNode response = client.execute(ifRequest);
                if (Util.isSuccess(response)) return;
                new CommandLineException("if request failed: " + Util.getFailureDescription(response));
                return;
            }
            catch (IOException e) {
                throw new CommandLineException("if request failed", e);
            }
        } else {
            if (!ifBlock.isInElse()) return;
            if (batch.size() == 0) {
                throw new CommandLineException("else block is empty.");
            }
            try {
                ModelNode response = client.execute(batch.toRequest());
                if (Util.isSuccess(response)) return;
                throw new CommandLineException("else request failed: " + Util.getFailureDescription(response));
            }
            catch (IOException e) {
                throw new CommandLineException("else request failed", e);
            }
        }
    }
}

