/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.List;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.FrameworkLogger;
import org.jboss.osgi.framework.FrameworkMessages;
import org.jboss.osgi.framework.internal.AbstractBundleState;
import org.jboss.osgi.framework.internal.BundleManagerPlugin;
import org.jboss.osgi.framework.internal.FrameworkState;
import org.jboss.osgi.framework.internal.ServiceReferenceWrapper;
import org.jboss.osgi.framework.internal.ServiceStateImpl;
import org.jboss.osgi.framework.spi.DeploymentProvider;
import org.jboss.osgi.framework.spi.FrameworkEvents;
import org.jboss.osgi.framework.spi.ServiceManager;
import org.jboss.osgi.framework.spi.ServiceState;
import org.jboss.osgi.framework.spi.StorageManager;
import org.jboss.osgi.resolver.XBundle;
import org.jboss.osgi.resolver.XBundleRevision;
import org.jboss.osgi.resolver.spi.RemoveOnlyCollection;
import org.jboss.osgi.vfs.AbstractVFS;
import org.jboss.osgi.vfs.VFSUtils;
import org.jboss.osgi.vfs.VirtualFile;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.hooks.bundle.FindHook;

abstract class AbstractBundleContext<T extends AbstractBundleState<?>>
implements BundleContext {
    private final T bundleState;
    private final FrameworkState frameworkState;
    private final BundleManagerPlugin bundleManager;
    private boolean destroyed;

    AbstractBundleContext(T bundleState) {
        assert (bundleState != null) : "Null bundleState";
        this.bundleState = bundleState;
        this.frameworkState = ((AbstractBundleState)bundleState).getFrameworkState();
        this.bundleManager = ((AbstractBundleState)bundleState).getBundleManager();
    }

    static AbstractBundleContext<?> assertBundleContext(BundleContext context) {
        assert (context != null) : "Null context";
        assert (context instanceof AbstractBundleContext) : "Not an AbstractBundleContext: " + context;
        return (AbstractBundleContext)context;
    }

    T getBundleState() {
        return this.bundleState;
    }

    BundleManagerPlugin getBundleManager() {
        return this.bundleManager;
    }

    FrameworkState getFrameworkState() {
        return this.frameworkState;
    }

    void destroy() {
        this.destroyed = true;
    }

    boolean isDestroyed() {
        return this.destroyed;
    }

    void asertNotDestroyed() {
        if (this.destroyed) {
            throw FrameworkMessages.MESSAGES.illegalStateInvalidBundleContext((Bundle)this.bundleState);
        }
    }

    public String getProperty(String key) {
        this.asertNotDestroyed();
        this.getBundleManager().assertFrameworkCreated();
        Object value = this.getBundleManager().getProperty(key);
        return value instanceof String ? (String)value : null;
    }

    public Bundle getBundle() {
        this.asertNotDestroyed();
        return this.bundleState;
    }

    public Bundle getBundle(String location) {
        this.asertNotDestroyed();
        return this.getBundleManager().getBundleByLocation(location);
    }

    public Bundle installBundle(String location) throws BundleException {
        return this.installBundleInternal(location, null);
    }

    public Bundle installBundle(String location, InputStream input) throws BundleException {
        return this.installBundleInternal(location, input);
    }

    private Bundle installBundleInternal(String location, InputStream input) throws BundleException {
        this.asertNotDestroyed();
        XBundle bundle2 = this.getBundleManager().getBundleByLocation(location);
        if (bundle2 != null) {
            FrameworkLogger.LOGGER.debugf("Installing an already existing bundle: %s", location);
            RemoveOnlyCollection hookBundles = new RemoveOnlyCollection((Object[])new Bundle[]{bundle2});
            this.callFindHooks((Collection<Bundle>)hookBundles);
            if (hookBundles.isEmpty()) {
                String message = FrameworkMessages.MESSAGES.cannotFindLocationBundleInContext(location, this);
                throw new BundleException(message, 12);
            }
            return bundle2;
        }
        VirtualFile rootFile = null;
        FrameworkState frameworkState = this.getFrameworkState();
        try {
            if (input != null) {
                try {
                    rootFile = AbstractVFS.toVirtualFile((InputStream)input);
                }
                catch (IOException ex) {
                    throw FrameworkMessages.MESSAGES.cannotObtainVirtualFile(ex);
                }
            }
            if (rootFile == null) {
                try {
                    URL url = new URL(location);
                    rootFile = AbstractVFS.toVirtualFile((InputStream)url.openStream());
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
            if (rootFile == null) {
                try {
                    File file = new File(location);
                    if (file.exists()) {
                        rootFile = AbstractVFS.toVirtualFile((URI)file.toURI());
                    }
                }
                catch (IOException ex) {
                    throw FrameworkMessages.MESSAGES.cannotObtainVirtualFileForLocation(ex, location);
                }
            }
            if (rootFile == null) {
                throw FrameworkMessages.MESSAGES.cannotObtainVirtualFileForLocation(null, location);
            }
            DeploymentProvider deploymentPlugin = frameworkState.getDeploymentProvider();
            Deployment dep = deploymentPlugin.createDeployment(location, rootFile);
            try {
                XBundleRevision brev = this.getBundleManager().createBundleRevisionLifecycle(this, dep);
                return brev.getBundle();
            }
            catch (BundleException ex) {
                FrameworkLogger.LOGGER.debugf(ex, "Cannot install bundle from deployment: %s", dep);
                throw ex;
            }
        }
        catch (RuntimeException rte) {
            VFSUtils.safeClose(rootFile);
            throw rte;
        }
        catch (BundleException ex) {
            VFSUtils.safeClose(rootFile);
            throw ex;
        }
    }

    public Bundle getBundle(long id) {
        this.asertNotDestroyed();
        XBundle result = this.getBundleManager().getBundleById(id);
        RemoveOnlyCollection hookBundles = new RemoveOnlyCollection((Object[])new Bundle[]{result});
        this.callFindHooks((Collection<Bundle>)hookBundles);
        return hookBundles.isEmpty() ? null : result;
    }

    public Bundle[] getBundles() {
        this.asertNotDestroyed();
        ArrayList<Bundle> result = new ArrayList<Bundle>();
        for (Bundle bundle2 : this.getBundleManager().getBundles()) {
            result.add(bundle2);
        }
        RemoveOnlyCollection hookBundles = new RemoveOnlyCollection(result);
        this.callFindHooks((Collection<Bundle>)hookBundles);
        return result.toArray(new Bundle[hookBundles.size()]);
    }

    private void callFindHooks(Collection<Bundle> bundles) {
        Collection<ServiceReference<FindHook>> srefs = null;
        try {
            srefs = this.getServiceReferences(FindHook.class, null);
        }
        catch (InvalidSyntaxException ex) {
            // empty catch block
        }
        if (srefs != null && !srefs.isEmpty()) {
            ArrayList<ServiceReference<FindHook>> sortedRefs = new ArrayList<ServiceReference<FindHook>>(srefs);
            Collections.reverse(sortedRefs);
            for (ServiceReference serviceReference : sortedRefs) {
                FindHook hook = (FindHook)this.getService(serviceReference);
                try {
                    hook.find((BundleContext)this, bundles);
                }
                catch (Exception ex) {
                    FrameworkLogger.LOGGER.warnErrorWhileCallingBundleFindHook(ex, hook);
                }
            }
        }
    }

    public void addServiceListener(ServiceListener listener, String filter) throws InvalidSyntaxException {
        this.asertNotDestroyed();
        if (listener == null) {
            throw FrameworkMessages.MESSAGES.illegalArgumentNull("listener");
        }
        this.getFrameworkEventsPlugin().addServiceListener((XBundle)this.bundleState, listener, filter);
    }

    public void addServiceListener(ServiceListener listener) {
        this.asertNotDestroyed();
        if (listener == null) {
            throw FrameworkMessages.MESSAGES.illegalArgumentNull("listener");
        }
        try {
            this.getFrameworkEventsPlugin().addServiceListener((XBundle)this.bundleState, listener, null);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
    }

    public void removeServiceListener(ServiceListener listener) {
        this.asertNotDestroyed();
        if (listener == null) {
            throw FrameworkMessages.MESSAGES.illegalArgumentNull("listener");
        }
        this.getFrameworkEventsPlugin().removeServiceListener((XBundle)this.bundleState, listener);
    }

    public void addBundleListener(BundleListener listener) {
        this.asertNotDestroyed();
        if (listener == null) {
            throw FrameworkMessages.MESSAGES.illegalArgumentNull("listener");
        }
        this.getFrameworkEventsPlugin().addBundleListener((XBundle)this.bundleState, listener);
    }

    public void removeBundleListener(BundleListener listener) {
        this.asertNotDestroyed();
        if (listener == null) {
            throw FrameworkMessages.MESSAGES.illegalArgumentNull("listener");
        }
        this.getFrameworkEventsPlugin().removeBundleListener((XBundle)this.bundleState, listener);
    }

    public void addFrameworkListener(FrameworkListener listener) {
        this.asertNotDestroyed();
        if (listener == null) {
            throw FrameworkMessages.MESSAGES.illegalArgumentNull("listener");
        }
        this.getFrameworkEventsPlugin().addFrameworkListener((XBundle)this.bundleState, listener);
    }

    public void removeFrameworkListener(FrameworkListener listener) {
        this.asertNotDestroyed();
        if (listener == null) {
            throw FrameworkMessages.MESSAGES.illegalArgumentNull("listener");
        }
        this.getFrameworkEventsPlugin().removeFrameworkListener((XBundle)this.bundleState, listener);
    }

    public ServiceRegistration<?> registerService(String clazz, Object service, Dictionary properties) {
        this.asertNotDestroyed();
        return this.registerService(new String[]{clazz}, service, properties);
    }

    public ServiceRegistration<?> registerService(String[] classNames, Object service, Dictionary properties) {
        if (classNames == null || classNames.length == 0) {
            throw FrameworkMessages.MESSAGES.illegalArgumentNull("classNames");
        }
        if (service == null) {
            throw FrameworkMessages.MESSAGES.illegalArgumentNull("service");
        }
        this.asertNotDestroyed();
        ServiceManager serviceManager = this.getFrameworkState().getServiceManagerPlugin();
        ServiceState serviceState = serviceManager.registerService((XBundle)this.bundleState, classNames, service, properties);
        return serviceState.getRegistration();
    }

    public <S> ServiceRegistration<S> registerService(Class<S> clazz, S service, Dictionary<String, ?> properties) {
        if (clazz == null) {
            throw FrameworkMessages.MESSAGES.illegalArgumentNull("class");
        }
        if (service == null) {
            throw FrameworkMessages.MESSAGES.illegalArgumentNull("service");
        }
        this.asertNotDestroyed();
        String[] classNames = new String[]{clazz.getName()};
        ServiceManager serviceManager = this.getFrameworkState().getServiceManagerPlugin();
        ServiceState serviceState = serviceManager.registerService((XBundle)this.bundleState, classNames, service, properties);
        return serviceState.getRegistration();
    }

    public ServiceReference<?> getServiceReference(String className) {
        if (className == null) {
            throw FrameworkMessages.MESSAGES.illegalArgumentNull("className");
        }
        this.asertNotDestroyed();
        ServiceManager serviceManager = this.getFrameworkState().getServiceManagerPlugin();
        ServiceState<?> serviceState = serviceManager.getServiceReference((XBundle)this.bundleState, className);
        return serviceState != null ? new ServiceReferenceWrapper(serviceState) : null;
    }

    public <S> ServiceReference<S> getServiceReference(Class<S> clazz) {
        if (clazz == null) {
            throw FrameworkMessages.MESSAGES.illegalArgumentNull("className");
        }
        this.asertNotDestroyed();
        ServiceManager serviceManager = this.getFrameworkState().getServiceManagerPlugin();
        ServiceState<?> serviceState = serviceManager.getServiceReference((XBundle)this.bundleState, clazz.getName());
        return serviceState != null ? new ServiceReferenceWrapper(serviceState) : null;
    }

    public ServiceReference<?>[] getServiceReferences(String className, String filter) throws InvalidSyntaxException {
        this.asertNotDestroyed();
        ServiceManager serviceManager = this.getFrameworkState().getServiceManagerPlugin();
        List<ServiceState<?>> srefs = serviceManager.getServiceReferences((XBundle)this.bundleState, className, filter, true);
        if (srefs.isEmpty()) {
            return null;
        }
        ArrayList<ServiceReference> result = new ArrayList<ServiceReference>();
        for (ServiceState<?> serviceState : srefs) {
            result.add(serviceState.getReference());
        }
        return result.toArray(new ServiceReference[result.size()]);
    }

    public <S> Collection<ServiceReference<S>> getServiceReferences(Class<S> clazz, String filter) throws InvalidSyntaxException {
        this.asertNotDestroyed();
        String className = clazz != null ? clazz.getName() : null;
        ServiceManager serviceManager = this.getFrameworkState().getServiceManagerPlugin();
        List<ServiceState<?>> srefs = serviceManager.getServiceReferences((XBundle)this.bundleState, className, filter, true);
        ArrayList<ServiceReference> result = new ArrayList<ServiceReference>();
        for (ServiceState<?> serviceState : srefs) {
            result.add(serviceState.getReference());
        }
        return Collections.unmodifiableList(result);
    }

    public ServiceReference<?>[] getAllServiceReferences(String className, String filter) throws InvalidSyntaxException {
        this.asertNotDestroyed();
        ServiceManager serviceManager = this.getFrameworkState().getServiceManagerPlugin();
        List<ServiceState<?>> srefs = serviceManager.getServiceReferences((XBundle)this.bundleState, className, filter, false);
        if (srefs.isEmpty()) {
            return null;
        }
        ArrayList<ServiceReference> result = new ArrayList<ServiceReference>();
        for (ServiceState<?> serviceState : srefs) {
            result.add(serviceState.getReference());
        }
        return result.toArray(new ServiceReference[result.size()]);
    }

    public <S> S getService(ServiceReference<S> sref) {
        if (sref == null) {
            throw FrameworkMessages.MESSAGES.illegalArgumentNull("sref");
        }
        this.asertNotDestroyed();
        ServiceStateImpl serviceState = ServiceStateImpl.assertServiceState(sref);
        ServiceManager serviceManager = this.getFrameworkState().getServiceManagerPlugin();
        Object service = serviceManager.getService((XBundle)this.bundleState, serviceState);
        return service;
    }

    public boolean ungetService(ServiceReference<?> sref) {
        if (sref == null) {
            throw FrameworkMessages.MESSAGES.illegalArgumentNull("sref");
        }
        this.asertNotDestroyed();
        ServiceStateImpl serviceState = ServiceStateImpl.assertServiceState(sref);
        return this.getServiceManager().ungetService((XBundle)this.bundleState, serviceState);
    }

    public File getDataFile(String filename) {
        this.asertNotDestroyed();
        StorageManager storagePlugin = this.getFrameworkState().getStorageManager();
        return storagePlugin.getDataFile(((AbstractBundleState)this.bundleState).getBundleId(), filename);
    }

    public Filter createFilter(String filter) throws InvalidSyntaxException {
        this.asertNotDestroyed();
        return FrameworkUtil.createFilter((String)filter);
    }

    private ServiceManager getServiceManager() {
        return this.getFrameworkState().getServiceManagerPlugin();
    }

    private FrameworkEvents getFrameworkEventsPlugin() {
        return this.getFrameworkState().getFrameworkEvents();
    }

    public String toString() {
        return "BundleContext[" + this.bundleState + "]";
    }
}

