/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.io.Closeable;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.FrameworkLogger;
import org.jboss.osgi.framework.FrameworkMessages;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.internal.AbstractBundleState;
import org.jboss.osgi.framework.internal.FragmentBundleRevisionFactory;
import org.jboss.osgi.framework.internal.FrameworkState;
import org.jboss.osgi.framework.internal.HostBundleRevisionFactory;
import org.jboss.osgi.framework.internal.InternalConstants;
import org.jboss.osgi.framework.internal.Java;
import org.jboss.osgi.framework.internal.RevisionIdentifier;
import org.jboss.osgi.framework.internal.SecurityActions;
import org.jboss.osgi.framework.internal.SystemBundleState;
import org.jboss.osgi.framework.internal.UserBundleRevision;
import org.jboss.osgi.framework.internal.UserBundleState;
import org.jboss.osgi.framework.spi.AbstractIntegrationService;
import org.jboss.osgi.framework.spi.BundleLifecycle;
import org.jboss.osgi.framework.spi.BundleManager;
import org.jboss.osgi.framework.spi.DeploymentProvider;
import org.jboss.osgi.framework.spi.FrameworkBuilder;
import org.jboss.osgi.framework.spi.FrameworkEvents;
import org.jboss.osgi.framework.spi.FrameworkStartLevelSupport;
import org.jboss.osgi.framework.spi.FrameworkWiringLock;
import org.jboss.osgi.framework.spi.IntegrationConstants;
import org.jboss.osgi.framework.spi.IntegrationServices;
import org.jboss.osgi.framework.spi.LockManager;
import org.jboss.osgi.framework.spi.ModuleManager;
import org.jboss.osgi.framework.spi.StorageState;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.resolver.XBundle;
import org.jboss.osgi.resolver.XBundleRevision;
import org.jboss.osgi.resolver.XEnvironment;
import org.jboss.osgi.resolver.XResolveContext;
import org.jboss.osgi.resolver.XResolver;
import org.jboss.osgi.resolver.XResource;
import org.jboss.osgi.vfs.VFSUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;
import org.osgi.framework.hooks.bundle.CollisionHook;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.startlevel.FrameworkStartLevel;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.resource.Resource;
import org.osgi.service.resolver.ResolutionException;

final class BundleManagerPlugin
extends AbstractIntegrationService<BundleManager>
implements BundleManager {
    private static String OSGi_FRAMEWORK_EXECUTIONENVIRONMENT;
    private static String OSGi_FRAMEWORK_LANGUAGE;
    private static String OSGi_FRAMEWORK_OS_NAME;
    private static String OSGi_FRAMEWORK_OS_VERSION;
    private static String OSGi_FRAMEWORK_PROCESSOR;
    private static String OSGi_FRAMEWORK_VENDOR;
    private static String OSGi_FRAMEWORK_VERSION;
    private static String implementationVersion;
    private final InjectedValue<XEnvironment> injectedEnvironment = new InjectedValue();
    private final InjectedValue<LockManager> injectedLockManager = new InjectedValue();
    final InjectedValue<FrameworkState> injectedFramework = new InjectedValue();
    final InjectedValue<SystemBundleState> injectedSystemBundle = new InjectedValue();
    final InjectedValue<Boolean> injectedFrameworkActive = new InjectedValue();
    private final FrameworkBuilder frameworkBuilder;
    private final ShutdownContainer shutdownContainer;
    private final Set<ExecutorService> executorServices = new HashSet<ExecutorService>();
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private final AtomicInteger managerState = new AtomicInteger(2);
    private final AtomicBoolean managerStopped = new AtomicBoolean();
    private final ServiceContainer serviceContainer;
    private final UniquenessPolicy uniquenessPolicy;
    private Framework framework;
    private SystemBundleState cachedSystemBundle;
    private ServiceTarget serviceTarget;
    private int stoppedEvent;

    BundleManagerPlugin(ServiceContainer serviceContainer, FrameworkBuilder frameworkBuilder) {
        super(Services.BUNDLE_MANAGER);
        this.serviceContainer = serviceContainer;
        this.frameworkBuilder = frameworkBuilder;
        this.stoppedEvent = 64;
        this.properties.putAll(frameworkBuilder.getProperties());
        if (this.getProperty("org.osgi.framework.executionenvironment") == null) {
            this.setProperty("org.osgi.framework.executionenvironment", OSGi_FRAMEWORK_EXECUTIONENVIRONMENT);
        }
        if (this.getProperty("org.osgi.framework.language") == null) {
            this.setProperty("org.osgi.framework.language", OSGi_FRAMEWORK_LANGUAGE);
        }
        if (this.getProperty("org.osgi.framework.os.name") == null) {
            this.setProperty("org.osgi.framework.os.name", OSGi_FRAMEWORK_OS_NAME);
        }
        if (this.getProperty("org.osgi.framework.os.version") == null) {
            this.setProperty("org.osgi.framework.os.version", OSGi_FRAMEWORK_OS_VERSION);
        }
        if (this.getProperty("org.osgi.framework.processor") == null) {
            this.setProperty("org.osgi.framework.processor", OSGi_FRAMEWORK_PROCESSOR);
        }
        if (this.getProperty("org.osgi.framework.uuid") == null) {
            this.setProperty("org.osgi.framework.uuid", UUID.randomUUID().toString());
        }
        if (this.getProperty("org.osgi.framework.bsnversion") == null) {
            this.setProperty("org.osgi.framework.bsnversion", "managed");
        }
        this.setProperty("org.osgi.framework.vendor", OSGi_FRAMEWORK_VENDOR);
        this.setProperty("org.osgi.framework.version", OSGi_FRAMEWORK_VERSION);
        this.uniquenessPolicy = UniquenessPolicy.valueOf((String)this.getProperty("org.osgi.framework.bsnversion"));
        boolean allowContainerShutdown = frameworkBuilder.getServiceContainer() == null;
        this.shutdownContainer = new ShutdownContainer(serviceContainer, allowContainerShutdown);
    }

    @Override
    protected void addServiceDependencies(ServiceBuilder<BundleManager> builder) {
        builder.addDependency(Services.ENVIRONMENT, XEnvironment.class, this.injectedEnvironment);
        builder.addDependency(IntegrationServices.LOCK_MANAGER_PLUGIN, LockManager.class, this.injectedLockManager);
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    @Override
    public void start(StartContext context) throws StartException {
        super.start(context);
        FrameworkLogger.LOGGER.infoFrameworkImplementation(implementationVersion);
        this.serviceTarget = context.getChildTarget();
        FrameworkLogger.LOGGER.debugf("Framework properties", new Object[0]);
        for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
            FrameworkLogger.LOGGER.debugf(" %s = %s", entry.getKey(), entry.getValue());
        }
    }

    public void stop(StopContext context) {
        XEnvironment env = (XEnvironment)this.injectedEnvironment.getValue();
        for (XResource res : env.getResources(XEnvironment.ALL_IDENTITY_TYPES)) {
            if (!(res instanceof UserBundleRevision)) continue;
            UserBundleRevision userRev = (UserBundleRevision)res;
            userRev.close();
        }
    }

    @Override
    protected BundleManager createServiceValue(StartContext startContext) {
        return this;
    }

    FrameworkBuilder getFrameworkBuilder() {
        return this.frameworkBuilder;
    }

    @Override
    public ServiceContainer getServiceContainer() {
        return this.serviceContainer;
    }

    @Override
    public ServiceTarget getServiceTarget() {
        return this.serviceTarget;
    }

    @Override
    public SystemBundleState getSystemBundle() {
        return (SystemBundleState)this.injectedSystemBundle.getOptionalValue();
    }

    BundleContext getSystemContext() {
        SystemBundleState sysbundle = (SystemBundleState)this.injectedSystemBundle.getOptionalValue();
        return sysbundle != null ? sysbundle.getBundleContext() : null;
    }

    FrameworkStartLevel getFrameworkStartLevel() {
        return this.getFrameworkState().getFrameworkStartLevel();
    }

    Framework getFramework() {
        return this.framework;
    }

    void setFramework(Framework framework) {
        this.framework = framework;
    }

    UniquenessPolicy getUniquenessPolicy() {
        return this.uniquenessPolicy;
    }

    <T> T adapt(Class<T> type) {
        if (!this.hasStopped()) {
            if (type.isAssignableFrom(FrameworkStartLevel.class)) {
                return (T)this.getFrameworkStartLevel();
            }
            if (type.isAssignableFrom(Framework.class)) {
                return (T)this.getFramework();
            }
            if (type.isAssignableFrom(FrameworkWiring.class)) {
                return (T)this.getFrameworkState().getFrameworkWiring();
            }
            if (type.isAssignableFrom(ServiceContainer.class)) {
                return (T)this.getServiceContainer();
            }
            if (type.isAssignableFrom(XEnvironment.class)) {
                return (T)this.getFrameworkState().getEnvironment();
            }
        }
        return null;
    }

    boolean isFrameworkCreated() {
        return this.getFrameworkState() != null;
    }

    void assertFrameworkCreated() {
        if (!this.isFrameworkCreated()) {
            throw FrameworkMessages.MESSAGES.illegalStateFrameworkNotActive();
        }
    }

    @Override
    public boolean isFrameworkActive() {
        return Boolean.TRUE.equals(this.injectedFrameworkActive.getOptionalValue());
    }

    FrameworkState getFrameworkState() {
        return (FrameworkState)this.injectedFramework.getOptionalValue();
    }

    static Version getFrameworkVersion() {
        Version version;
        String versionSpec = BundleManagerPlugin.class.getPackage().getImplementationVersion();
        try {
            version = Version.parseVersion((String)versionSpec);
        }
        catch (IllegalArgumentException ex) {
            if (versionSpec.endsWith("-SNAPSHOT")) {
                versionSpec = versionSpec.substring(0, versionSpec.length() - 9);
            }
            version = Version.parseVersion((String)versionSpec);
        }
        return version;
    }

    int getManagerState() {
        return this.managerState.get();
    }

    void setManagerState(int state) {
        this.managerState.set(state);
    }

    @Override
    public Object getProperty(String key) {
        Object value = this.properties.get(key);
        if (value == null) {
            value = SecurityActions.getSystemProperty(key, null);
        }
        return value;
    }

    @Override
    public Map<String, Object> getProperties() {
        HashMap<String, Object> m = new HashMap<String, Object>();
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            m.put(entry.getKey().toString(), entry.getValue());
        }
        m.putAll(this.properties);
        return m;
    }

    void setProperty(String key, Object value) {
        if (this.isFrameworkCreated()) {
            throw FrameworkMessages.MESSAGES.illegalStateCannotAddProperty();
        }
        this.properties.put(key, value);
    }

    @Override
    public Set<XBundle> getBundles() {
        HashSet<XBundle> result = new HashSet<XBundle>();
        XEnvironment env = (XEnvironment)this.injectedEnvironment.getValue();
        for (Resource aux : env.getResources(XEnvironment.ALL_IDENTITY_TYPES)) {
            XBundle bundle2 = ((XBundleRevision)aux).getBundle();
            if (bundle2.getState() == 1) continue;
            result.add(bundle2);
        }
        return Collections.unmodifiableSet(result);
    }

    @Override
    public Set<XBundle> getBundles(Integer states) {
        HashSet<XBundle> result = new HashSet<XBundle>();
        XEnvironment env = (XEnvironment)this.injectedEnvironment.getValue();
        for (Resource aux : env.getResources(XEnvironment.ALL_IDENTITY_TYPES)) {
            XBundle bundle2 = ((XBundleRevision)aux).getBundle();
            if (states != null && (bundle2.getState() & states) == 0) continue;
            result.add(bundle2);
        }
        return Collections.unmodifiableSet(result);
    }

    @Override
    public XBundle getBundleById(long bundleId) {
        XEnvironment env = (XEnvironment)this.injectedEnvironment.getValue();
        XBundleRevision brev = (XBundleRevision)env.getResourceById(bundleId);
        return brev != null ? brev.getBundle() : null;
    }

    @Override
    public XBundle getBundleByLocation(String location) {
        assert (location != null) : "Null location";
        if ("System Bundle".equals(location)) {
            return this.getSystemBundle();
        }
        for (XBundle aux : this.getBundles()) {
            String auxLocation = aux.getLocation();
            if (!location.equals(auxLocation)) continue;
            return aux;
        }
        return null;
    }

    @Override
    public Set<XBundle> getBundles(String symbolicName, VersionRange versionRange) {
        HashSet<XBundle> resultSet = new HashSet<XBundle>();
        if ("system.bundle".equals(symbolicName) && versionRange == null) {
            resultSet.add(this.getSystemBundle());
        } else {
            for (XBundle aux : this.getBundles(null)) {
                if (symbolicName != null && !symbolicName.equals(aux.getSymbolicName()) || versionRange != null && !versionRange.includes(aux.getVersion())) continue;
                resultSet.add(aux);
            }
        }
        return Collections.unmodifiableSet(resultSet);
    }

    XBundleRevision createBundleRevisionLifecycle(BundleContext context, Deployment dep) throws BundleException {
        XBundleRevision brev = this.getBundleLifecycle().createBundleRevision(context, dep);
        if (brev == null) {
            throw FrameworkMessages.MESSAGES.illegalStateCannotObtainBundleRevision(dep);
        }
        return brev;
    }

    @Override
    public XBundleRevision createBundleRevision(BundleContext context, Deployment deployment, ServiceTarget serviceTarget) throws BundleException {
        Object brev;
        if (context == null) {
            throw FrameworkMessages.MESSAGES.illegalArgumentNull("context");
        }
        if (deployment == null) {
            throw FrameworkMessages.MESSAGES.illegalArgumentNull("deployment");
        }
        if (serviceTarget == null) {
            serviceTarget = this.getServiceTarget();
        }
        String symbolicName = deployment.getSymbolicName();
        Version version = Version.parseVersion((String)deployment.getVersion());
        if (!this.isUpdateOrRefresh(deployment)) {
            XBundle bundle2 = this.getBundleByLocation(deployment.getLocation());
            if (bundle2 != null) {
                FrameworkLogger.LOGGER.debugf("Installing an already existing bundle: %s", deployment);
                XBundleRevision brev2 = bundle2.getBundleRevision();
                VFSUtils.safeClose((Closeable)deployment.getRoot());
                return brev2;
            }
            this.checkUniqunessPolicy(context.getBundle(), symbolicName, version, 1);
        }
        try {
            OSGiMetaData metadata;
            RevisionIdentifier revIdentifier = (RevisionIdentifier)deployment.getAttachment(InternalConstants.REVISION_IDENTIFIER_KEY);
            if (revIdentifier == null) {
                revIdentifier = this.createRevisionIdentifier(symbolicName, deployment);
                deployment.putAttachment(InternalConstants.REVISION_IDENTIFIER_KEY, (Object)revIdentifier);
            }
            if ((metadata = (OSGiMetaData)deployment.getAttachment(IntegrationConstants.OSGI_METADATA_KEY)) == null) {
                DeploymentProvider plugin = this.getFrameworkState().getDeploymentProvider();
                metadata = plugin.createOSGiMetaData(deployment);
            }
            brev = metadata.getFragmentHost() == null ? new HostBundleRevisionFactory(this.getFrameworkState(), context, deployment, serviceTarget).create() : new FragmentBundleRevisionFactory(this.getFrameworkState(), context, deployment, serviceTarget).create();
        }
        catch (RuntimeException rte) {
            VFSUtils.safeClose((Closeable)deployment.getRoot());
            throw rte;
        }
        catch (BundleException ex) {
            VFSUtils.safeClose((Closeable)deployment.getRoot());
            throw ex;
        }
        return brev;
    }

    private boolean isUpdateOrRefresh(Deployment dep) {
        return dep.isBundleUpdate() || dep.getAttachment(IntegrationConstants.BUNDLE_KEY) != null;
    }

    private RevisionIdentifier createRevisionIdentifier(String symbolicName, Deployment dep) {
        Long resourceId;
        StorageState storageState = (StorageState)dep.getAttachment(IntegrationConstants.STORAGE_STATE_KEY);
        if (!dep.isBundleUpdate() && storageState != null) {
            resourceId = new Long(storageState.getBundleId());
        } else {
            XEnvironment env = (XEnvironment)this.injectedEnvironment.getValue();
            resourceId = env.nextResourceIdentifier(null, symbolicName);
        }
        return new RevisionIdentifier(resourceId);
    }

    void resolveBundleLifecycle(XBundle bundle2) throws ResolutionException {
        this.getBundleLifecycle().resolve(bundle2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resolveBundle(XBundle bundle2) throws ResolutionException {
        LockManager lockManager = this.getFrameworkState().getLockManager();
        LockManager.LockContext lockContext = null;
        try {
            LockManager.LockableItem[] items = this.getLockableItems(lockManager, LockManager.Method.RESOLVE, bundle2);
            lockContext = lockManager.lockItems(LockManager.Method.RESOLVE, items);
            FrameworkLogger.LOGGER.debugf("Resolving bundle: %s", bundle2);
            Set<XBundleRevision> mandatory = Collections.singleton(bundle2.getBundleRevision());
            XEnvironment environment = this.getFrameworkState().getEnvironment();
            XResolver resolver = this.getFrameworkState().getResolver();
            XResolveContext context = resolver.createResolveContext(environment, mandatory, null);
            resolver.resolveAndApply(context);
            FrameworkLogger.LOGGER.debugf("Resolved bundle: %s", bundle2);
            lockManager.unlockItems(lockContext);
        }
        catch (Throwable throwable) {
            lockManager.unlockItems(lockContext);
            throw throwable;
        }
    }

    void startBundleLifecycle(XBundle bundle2, int options) throws BundleException {
        BundleLifecycle bundleLifecycle = this.getBundleLifecycle();
        bundleLifecycle.start(bundle2, options);
    }

    @Override
    public void startBundle(XBundle bundle2, int options) throws BundleException {
        LockManager lockManager = this.getFrameworkState().getLockManager();
        LockManager.LockContext lockContext = null;
        try {
            LockManager.LockableItem[] items = this.getLockableItems(lockManager, LockManager.Method.START, bundle2);
            lockContext = lockManager.lockItems(LockManager.Method.START, items);
            AbstractBundleState.assertBundleState((Bundle)bundle2).startInternal(options);
            lockManager.unlockItems(lockContext);
        }
        catch (BundleException ex) {
            try {
                FrameworkLogger.LOGGER.debugf(ex, "Cannot start bundle: %s", bundle2);
                throw ex;
            }
            catch (Throwable throwable) {
                lockManager.unlockItems(lockContext);
                throw throwable;
            }
        }
    }

    void stopBundleLifecycle(XBundle bundle2, int options) throws BundleException {
        BundleLifecycle bundleLifecycle = this.getBundleLifecycle();
        bundleLifecycle.stop(bundle2, options);
    }

    @Override
    public void stopBundle(XBundle bundle2, int options) throws BundleException {
        LockManager lockManager = this.getFrameworkState().getLockManager();
        LockManager.LockContext lockContext = null;
        try {
            LockManager.LockableItem[] items = this.getLockableItems(lockManager, LockManager.Method.STOP, bundle2);
            lockContext = lockManager.lockItems(LockManager.Method.STOP, items);
            AbstractBundleState.assertBundleState((Bundle)bundle2).stopInternal(options);
            lockManager.unlockItems(lockContext);
        }
        catch (BundleException ex) {
            try {
                FrameworkLogger.LOGGER.debugf(ex, "Cannot stop bundle: %s", bundle2);
                throw ex;
            }
            catch (Throwable throwable) {
                lockManager.unlockItems(lockContext);
                throw throwable;
            }
        }
    }

    @Override
    public void updateBundle(XBundle bundle2, InputStream input) throws BundleException {
        LockManager lockManager = this.getFrameworkState().getLockManager();
        LockManager.LockContext lockContext = null;
        try {
            LockManager.LockableItem[] items = this.getLockableItems(lockManager, LockManager.Method.UPDATE, bundle2);
            lockContext = lockManager.lockItems(LockManager.Method.UPDATE, items);
            AbstractBundleState.assertBundleState((Bundle)bundle2).updateInternal(input);
            lockManager.unlockItems(lockContext);
        }
        catch (BundleException ex) {
            try {
                FrameworkLogger.LOGGER.debugf(ex, "Cannot update bundle: %s", bundle2);
                throw ex;
            }
            catch (Throwable throwable) {
                lockManager.unlockItems(lockContext);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uninstallBundle(XBundle bundle2, int options) throws BundleException {
        LockManager lockManager = this.getFrameworkState().getLockManager();
        LockManager.LockContext lockContext = null;
        try {
            LockManager.LockableItem[] items = this.getLockableItems(lockManager, LockManager.Method.UNINSTALL, bundle2);
            lockContext = lockManager.lockItems(LockManager.Method.UNINSTALL, items);
            LockManager.LockContext transitiveClosureLock = null;
            try {
                items = this.getTransitiveLockForUninstall(lockManager, bundle2);
                transitiveClosureLock = lockManager.lockItems(LockManager.Method.UNINSTALL, items);
                AbstractBundleState.assertBundleState((Bundle)bundle2).uninstallInternal(options);
                lockManager.unlockItems(transitiveClosureLock);
            }
            catch (Throwable throwable) {
                lockManager.unlockItems(transitiveClosureLock);
                throw throwable;
            }
            lockManager.unlockItems(lockContext);
        }
        catch (BundleException ex) {
            try {
                FrameworkLogger.LOGGER.errorCannotUninstallBundle(ex, (Bundle)bundle2);
                throw ex;
            }
            catch (Throwable throwable) {
                lockManager.unlockItems(lockContext);
                throw throwable;
            }
        }
    }

    void removeBundle(UserBundleState userBundle, int options) {
        FrameworkLogger.LOGGER.debugf("Removing bundle: %s", userBundle);
        for (XBundleRevision brev : userBundle.getAllBundleRevisions()) {
            if ((options & 0x100) != 0) {
                this.removeRevisionLifecycle(brev, options);
                continue;
            }
            this.removeRevision(brev, options);
        }
        FrameworkLogger.LOGGER.debugf("Removed bundle: %s", userBundle);
    }

    void removeRevisionLifecycle(XBundleRevision brev, int options) {
        BundleLifecycle bundleLifecycle = this.getBundleLifecycle();
        bundleLifecycle.removeRevision(brev, options);
    }

    @Override
    public void removeRevision(XBundleRevision brev, int options) {
        FrameworkLogger.LOGGER.debugf("Removing revision: %s", brev);
        XEnvironment env = this.getFrameworkState().getEnvironment();
        env.uninstallResources(new XResource[]{brev});
        if (brev instanceof UserBundleRevision) {
            UserBundleRevision userRev = (UserBundleRevision)brev;
            userRev.getBundleState().removeRevision(userRev);
            userRev.close();
        }
        FrameworkLogger.LOGGER.debugf("Removed revision: %s", brev);
    }

    private LockManager.LockableItem[] getLockableItems(LockManager lockManager, LockManager.Method method, XBundle bundle2) {
        FrameworkWiringLock wireLock = lockManager.getItemForType(FrameworkWiringLock.class);
        LockManager.LockableItem[] items = null;
        switch (method) {
            case RESOLVE: 
            case UPDATE: 
            case REFRESH: 
            case UNINSTALL: {
                items = new LockManager.LockableItem[]{wireLock, (LockManager.LockableItem)bundle2};
                break;
            }
            case START: {
                items = new LockManager.LockableItem[]{bundle2.isResolved() ? (LockManager.LockableItem)bundle2 : wireLock, (LockManager.LockableItem)bundle2};
                break;
            }
            case STOP: {
                items = new LockManager.LockableItem[]{(LockManager.LockableItem)bundle2};
            }
        }
        return items;
    }

    private BundleLifecycle getBundleLifecycle() {
        return this.getFrameworkState().getCoreServices().getBundleLifecycle();
    }

    void checkUniqunessPolicy(Bundle targetBundle, String symbolicName, Version version, int policy) throws BundleException {
        if (this.uniquenessPolicy == UniquenessPolicy.multiple) {
            return;
        }
        HashSet<XBundle> candidates = new HashSet<XBundle>();
        if (symbolicName != null) {
            VersionRange versionRange = null;
            if (!Version.emptyVersion.equals((Object)version)) {
                versionRange = new VersionRange("[" + version + "," + version + "]");
            }
            for (XBundle aux : this.getBundles(symbolicName, versionRange)) {
                if (aux == targetBundle || aux.getState() == 1) continue;
                candidates.add(aux);
            }
        }
        if (candidates.isEmpty()) {
            return;
        }
        if (this.uniquenessPolicy == UniquenessPolicy.managed) {
            BundleContext syscontext = this.getFrameworkState().getSystemBundle().getBundleContext();
            Collection srefs = null;
            try {
                srefs = syscontext.getServiceReferences(CollisionHook.class, null);
            }
            catch (InvalidSyntaxException ex) {
                // empty catch block
            }
            for (ServiceReference sref : srefs) {
                CollisionHook hook = (CollisionHook)syscontext.getService(sref);
                hook.filterCollisions(policy, targetBundle, candidates);
            }
        }
        if (!candidates.isEmpty()) {
            throw new BundleException(FrameworkMessages.MESSAGES.nameAndVersionAlreadyInstalled(symbolicName, version), 9);
        }
    }

    void unresolveBundle(UserBundleState userBundle) {
        FrameworkLogger.LOGGER.debugf("Unresolving bundle: %s", userBundle);
        ModuleManager moduleManager = this.getFrameworkState().getModuleManager();
        for (XBundleRevision brev : userBundle.getAllBundleRevisions()) {
            UserBundleRevision userRev = (UserBundleRevision)brev;
            if (userRev.isFragment()) continue;
            ModuleIdentifier identifier = moduleManager.getModuleIdentifier(brev);
            moduleManager.removeModule(brev, identifier);
        }
    }

    private LockManager.LockableItem[] getTransitiveLockForUninstall(LockManager lockManager, XBundle bundle2) {
        HashSet<LockManager.LockableItem> lockableItems = new HashSet<LockManager.LockableItem>();
        lockableItems.add(lockManager.getItemForType(FrameworkWiringLock.class));
        this.getTransitiveSetOfLockableItemsForUninstall(lockableItems, (Bundle)bundle2);
        return lockableItems.toArray(new LockManager.LockableItem[lockableItems.size()]);
    }

    private void getTransitiveSetOfLockableItemsForUninstall(Set<LockManager.LockableItem> lockableItems, Bundle bundle2) {
        if (!lockableItems.contains(bundle2) && bundle2.getBundleId() > 0L) {
            lockableItems.add((LockManager.LockableItem)bundle2);
            BundleWiring wiring = (BundleWiring)bundle2.adapt(BundleWiring.class);
            if (wiring != null) {
                for (BundleWire wire : wiring.getRequiredWires(null)) {
                    Bundle provider = wire.getProvider().getBundle();
                    if (provider.getState() != 1) continue;
                    this.getTransitiveSetOfLockableItemsForUninstall(lockableItems, provider);
                }
                for (BundleWire wire : wiring.getProvidedWires(null)) {
                    Bundle requirer = wire.getRequirer().getBundle();
                    if (requirer.getState() != 1) continue;
                    this.getTransitiveSetOfLockableItemsForUninstall(lockableItems, requirer);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerExecutorService(ExecutorService executorService) {
        Set<ExecutorService> set = this.executorServices;
        synchronized (set) {
            this.executorServices.add(executorService);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterExecutorService(ExecutorService executorService) {
        Set<ExecutorService> set = this.executorServices;
        synchronized (set) {
            this.executorServices.remove(executorService);
        }
    }

    void fireFrameworkError(XBundle bundle2, String context, Throwable t) {
        FrameworkEvents plugin = this.getFrameworkState().getFrameworkEvents();
        if (t instanceof BundleException) {
            plugin.fireFrameworkEvent(bundle2, 2, t, new FrameworkListener[0]);
        } else if (bundle2 != null) {
            plugin.fireFrameworkEvent(bundle2, 2, new BundleException("Error " + context + " bundle: " + bundle2, t), new FrameworkListener[0]);
        } else {
            SystemBundleState systemBundle = (SystemBundleState)this.injectedSystemBundle.getValue();
            plugin.fireFrameworkEvent(systemBundle, 2, new BundleException("Error " + context, t), new FrameworkListener[0]);
        }
    }

    void fireFrameworkWarning(AbstractBundleState<?> bundleState, String context, Throwable t) {
        FrameworkEvents plugin = this.getFrameworkState().getFrameworkEvents();
        if (t instanceof BundleException) {
            plugin.fireFrameworkEvent(bundleState, 16, t, new FrameworkListener[0]);
        } else if (bundleState != null) {
            plugin.fireFrameworkEvent(bundleState, 16, new BundleException("Error " + context + " bundle: " + bundleState, t), new FrameworkListener[0]);
        } else {
            SystemBundleState systemBundle = (SystemBundleState)this.injectedSystemBundle.getValue();
            plugin.fireFrameworkEvent(systemBundle, 16, new BundleException("Error " + context, t), new FrameworkListener[0]);
        }
    }

    boolean hasStopped() {
        return this.shutdownContainer.isShutdownInitiated() || this.managerStopped.get();
    }

    void assertNotStopped() {
        if (this.hasStopped()) {
            throw FrameworkMessages.MESSAGES.illegalStateFrameworkAlreadyStopped();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdownManager(boolean stopForUpdate) {
        int state = this.getManagerState();
        if (state != 8 && state != 32) {
            return;
        }
        FrameworkLogger.LOGGER.debugf("Stop framework", new Object[0]);
        this.stoppedEvent = stopForUpdate ? 128 : 64;
        this.getSystemBundle().changeState(16);
        this.setManagerState(16);
        final CountDownLatch latch = new CountDownLatch(1);
        FrameworkListener listener = new FrameworkListener(){

            public void frameworkEvent(FrameworkEvent event) {
                if (event.getType() == 8) {
                    latch.countDown();
                }
            }
        };
        FrameworkStartLevel startLevel = this.getSystemBundle().adapt(FrameworkStartLevel.class);
        ((FrameworkStartLevelSupport)startLevel).shutdownFramework(listener);
        try {
            latch.await(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        Set<ExecutorService> set = this.executorServices;
        synchronized (set) {
            for (ExecutorService service : this.executorServices) {
                service.shutdown();
            }
            for (ExecutorService service : this.executorServices) {
                try {
                    service.awaitTermination(10L, TimeUnit.SECONDS);
                }
                catch (InterruptedException ex) {}
            }
        }
        this.cachedSystemBundle = this.getSystemBundle();
        this.shutdownContainer.shutdown();
        this.setManagerState(4);
    }

    FrameworkEvent waitForStop(long timeout) throws InterruptedException {
        SystemBundleState systemBundle = this.getSystemBundle();
        SystemBundleState eventSource = systemBundle != null ? systemBundle : this.cachedSystemBundle;
        FrameworkEvent frameworkEvent = null;
        this.shutdownContainer.awaitTermination(timeout, TimeUnit.MILLISECONDS);
        if (eventSource != null) {
            int eventType = this.shutdownContainer.isShutdownComplete() ? this.stoppedEvent : 512;
            frameworkEvent = new FrameworkEvent(eventType, (Bundle)eventSource, null);
        }
        return frameworkEvent;
    }

    static String getOSVersionInOSGiFormat() {
        int i;
        StringBuilder osgiVersion = new StringBuilder();
        String sysVersion = SecurityActions.getSystemProperty("os.version", null);
        String[] elements = sysVersion.split("\\.");
        for (i = 0; i < 3 && i < elements.length; ++i) {
            try {
                Integer.parseInt(elements[i]);
                if (i > 0) {
                    osgiVersion.append('.');
                }
                osgiVersion.append(elements[i]);
                continue;
            }
            catch (NumberFormatException nfe) {
                break;
            }
        }
        if (i == 3 && elements.length > 3) {
            osgiVersion.append('.');
            osgiVersion.append(elements[3]);
        }
        return osgiVersion.toString();
    }

    static {
        OSGi_FRAMEWORK_LANGUAGE = Locale.getDefault().getLanguage();
        OSGi_FRAMEWORK_VENDOR = "jboss.org";
        OSGi_FRAMEWORK_VERSION = "1.7";
        implementationVersion = BundleManagerPlugin.class.getPackage().getImplementationVersion();
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                ArrayList<String> execEnvironments = new ArrayList<String>();
                if (Java.isCompatible(2)) {
                    execEnvironments.add("OSGi/Minimum-1.1");
                    execEnvironments.add("J2SE-1.1");
                }
                if (Java.isCompatible(3)) {
                    execEnvironments.add("OSGi/Minimum-1.2");
                    execEnvironments.add("J2SE-1.2");
                }
                if (Java.isCompatible(4)) {
                    execEnvironments.add("J2SE-1.3");
                }
                if (Java.isCompatible(5)) {
                    execEnvironments.add("J2SE-1.4");
                }
                if (Java.isCompatible(6)) {
                    execEnvironments.add("J2SE-1.5");
                }
                if (Java.isCompatible(7)) {
                    execEnvironments.add("JavaSE-1.6");
                }
                if (Java.isCompatible(8)) {
                    execEnvironments.add("JavaSE-1.7");
                }
                String envlist = ((Object)execEnvironments).toString();
                envlist = envlist.substring(1, envlist.length() - 1);
                OSGi_FRAMEWORK_EXECUTIONENVIRONMENT = envlist;
                OSGi_FRAMEWORK_OS_NAME = SecurityActions.getSystemProperty("os.name", null);
                OSGi_FRAMEWORK_OS_VERSION = BundleManagerPlugin.getOSVersionInOSGiFormat();
                OSGi_FRAMEWORK_PROCESSOR = SecurityActions.getSystemProperty("os.arch", null);
                return null;
            }
        });
    }

    static class ShutdownContainer {
        private final ServiceContainer serviceContainer;
        private final AtomicBoolean shutdownInitiated;
        private final boolean allowContainerShutdown;

        ShutdownContainer(ServiceContainer serviceContainer, boolean allowContainerShutdown) {
            this.serviceContainer = serviceContainer;
            this.allowContainerShutdown = allowContainerShutdown;
            this.shutdownInitiated = new AtomicBoolean(false);
        }

        ServiceController<?> getRequiredService(ServiceName serviceName) {
            return this.serviceContainer.getRequiredService(serviceName);
        }

        boolean isShutdownInitiated() {
            return this.shutdownInitiated.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void shutdown() {
            if (this.allowContainerShutdown) {
                this.serviceContainer.shutdown();
                AtomicBoolean atomicBoolean = this.shutdownInitiated;
                synchronized (atomicBoolean) {
                    this.shutdownInitiated.set(true);
                    FrameworkLogger.LOGGER.debugf("shutdownInitiated.notifyAll", new Object[0]);
                    this.shutdownInitiated.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            FrameworkLogger.LOGGER.debugf("awaitTermination: %dms", unit.toMillis(timeout));
            AtomicBoolean atomicBoolean = this.shutdownInitiated;
            synchronized (atomicBoolean) {
                if (!this.shutdownInitiated.get()) {
                    FrameworkLogger.LOGGER.debugf("shutdownInitiated.wait", new Object[0]);
                    this.shutdownInitiated.wait(2000L);
                }
            }
            this.serviceContainer.awaitTermination(timeout == 0L ? Long.MAX_VALUE : timeout, unit);
        }

        boolean isShutdownComplete() {
            return this.serviceContainer.isShutdownComplete();
        }
    }

    static enum UniquenessPolicy {
        multiple,
        single,
        managed;

    }
}

