/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.util.HashSet;
import java.util.List;
import org.jboss.osgi.framework.FrameworkMessages;
import org.jboss.osgi.framework.internal.BundleRevisionValidator;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.metadata.PackageAttribute;
import org.jboss.osgi.metadata.ParameterizedAttribute;
import org.jboss.osgi.resolver.XBundleRevision;
import org.osgi.framework.BundleException;

final class BundleRevisionValidatorR4
implements BundleRevisionValidator {
    BundleRevisionValidatorR4() {
    }

    @Override
    public void validateBundleRevision(XBundleRevision brev, OSGiMetaData metadata) throws BundleException {
        List dynamicImports;
        List exportPackages;
        String packageName;
        String symbolicName = metadata.getBundleSymbolicName();
        if (symbolicName == null) {
            throw FrameworkMessages.MESSAGES.missingBundleSymbolicName(brev);
        }
        int manifestVersion = metadata.getBundleManifestVersion();
        if (manifestVersion > 2) {
            throw FrameworkMessages.MESSAGES.unsupportedBundleManifestVersion(manifestVersion, brev);
        }
        List importPackages = metadata.getImportPackages();
        if (importPackages != null) {
            HashSet<String> packages = new HashSet<String>();
            for (PackageAttribute packageAttribute : importPackages) {
                packageName = packageAttribute.getAttribute();
                if (packages.contains(packageName)) {
                    throw FrameworkMessages.MESSAGES.duplicatePackageImport(packageName, brev);
                }
                packages.add(packageName);
                if (packageName.startsWith("java.")) {
                    throw FrameworkMessages.MESSAGES.notAllowdToImportJavaPackage(brev);
                }
                String version = (String)packageAttribute.getAttributeValue("version", String.class);
                String specificationVersion = (String)packageAttribute.getAttributeValue("specification-version", String.class);
                if (version == null || specificationVersion == null || version.equals(specificationVersion)) continue;
                throw FrameworkMessages.MESSAGES.packageVersionAndSpecificationVersionMissmatch(packageName, brev);
            }
        }
        if ((exportPackages = metadata.getExportPackages()) != null) {
            for (PackageAttribute packageAttr : exportPackages) {
                packageName = packageAttr.getAttribute();
                if (packageName.startsWith("java.")) {
                    throw FrameworkMessages.MESSAGES.notAllowdToExportJavaPackage(brev);
                }
                String versionAttr = (String)packageAttr.getAttributeValue("version", String.class);
                String specificationAttr = (String)packageAttr.getAttributeValue("specification-version", String.class);
                if (versionAttr != null && specificationAttr != null && !versionAttr.equals(specificationAttr)) {
                    throw FrameworkMessages.MESSAGES.packageVersionAndSpecificationVersionMissmatch(packageName, brev);
                }
                String symbolicNameAttr = (String)packageAttr.getAttributeValue("bundle-symbolic-name", String.class);
                if (symbolicNameAttr != null) {
                    throw FrameworkMessages.MESSAGES.packageCannotSpecifyBundleSymbolicName(packageName, brev);
                }
                String bundleVersionAttr = (String)packageAttr.getAttributeValue("bundle-version", String.class);
                if (bundleVersionAttr == null) continue;
                throw FrameworkMessages.MESSAGES.packageCannotSpecifyBundleVersion(packageName, brev);
            }
        }
        if ((dynamicImports = metadata.getDynamicImports()) != null) {
            for (PackageAttribute packageAttr : dynamicImports) {
                String packageName2 = packageAttr.getAttribute();
                String versionAttr = (String)packageAttr.getAttributeValue("version", String.class);
                String specificationAttr = (String)packageAttr.getAttributeValue("specification-version", String.class);
                if (versionAttr == null || specificationAttr == null || versionAttr.equals(specificationAttr)) continue;
                throw FrameworkMessages.MESSAGES.packageVersionAndSpecificationVersionMissmatch(packageName2, brev);
            }
        }
        if (brev.isFragment()) {
            ParameterizedAttribute hostAttr = metadata.getFragmentHost();
            String fragmentHost = hostAttr.getAttribute();
            String extension = (String)hostAttr.getDirectiveValue("extension", String.class);
            if (extension != null) {
                if (!"system.bundle".equals(fragmentHost)) {
                    throw FrameworkMessages.MESSAGES.invalidFragmentHostForExtensionFragment(brev);
                }
                if ("bootclasspath".equals(extension)) {
                    throw FrameworkMessages.MESSAGES.unsupportedBootClasspathExtension();
                }
                if ("framework".equals(extension)) {
                    throw FrameworkMessages.MESSAGES.unsupportedFrameworkExtension();
                }
            }
        }
    }
}

