/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.deployment.interceptor.AbstractInvocationContext;
import org.jboss.osgi.deployment.interceptor.AbstractLifecycleInterceptorService;
import org.jboss.osgi.deployment.interceptor.InvocationContext;
import org.jboss.osgi.framework.FrameworkMessages;
import org.jboss.osgi.framework.internal.UserBundleState;
import org.jboss.osgi.spi.Attachable;
import org.jboss.osgi.spi.AttachableSupport;
import org.jboss.osgi.spi.AttachmentKey;
import org.jboss.osgi.vfs.VirtualFile;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public final class LifecycleInterceptorServiceImpl
extends AbstractLifecycleInterceptorService {
    private AttachmentKey<InvocationContext> INVOCATION_CONTEXT_KEY = AttachmentKey.create(InvocationContext.class);
    private final BundleContext systemContext;

    public LifecycleInterceptorServiceImpl(BundleContext systemContext) {
        this.systemContext = systemContext;
    }

    protected InvocationContext getInvocationContext(Bundle bundle2) {
        if (bundle2 == null) {
            throw FrameworkMessages.MESSAGES.illegalArgumentNull("bundle");
        }
        UserBundleState userBundle = UserBundleState.assertBundleState(bundle2);
        Deployment dep = userBundle.getDeployment();
        InvocationContext inv = (InvocationContext)dep.getAttachment(this.INVOCATION_CONTEXT_KEY);
        if (inv == null) {
            VirtualFile rootFile = userBundle.getDeployment().getRoot();
            AttachableSupport att = new AttachableSupport(){};
            inv = new AbstractInvocationContext(this.systemContext, (Bundle)userBundle, rootFile, (Attachable)att);
            dep.putAttachment(this.INVOCATION_CONTEXT_KEY, (Object)inv);
        }
        return inv;
    }
}

