/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantLock;
import org.jboss.osgi.framework.FrameworkLogger;
import org.jboss.osgi.framework.FrameworkMessages;
import org.jboss.osgi.framework.spi.FrameworkWiringLock;
import org.jboss.osgi.framework.spi.LockException;
import org.jboss.osgi.framework.spi.LockManager;

public final class LockManagerImpl
implements LockManager {
    private final FrameworkWiringLock wiringLock = new FrameworkWiringLock();
    private final Map<Class<? extends LockManager.LockableItem>, LockManager.LockableItem> otherLocks = new HashMap<Class<? extends LockManager.LockableItem>, LockManager.LockableItem>();
    private static ThreadLocal<Stack<LockManager.LockContext>> lockContextAssociation = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends LockManager.LockableItem> T getItemForType(Class<T> type) {
        Map<Class<? extends LockManager.LockableItem>, LockManager.LockableItem> map = this.otherLocks;
        synchronized (map) {
            if (type == FrameworkWiringLock.class) {
                return (T)this.wiringLock;
            }
            LockManager.LockableItem lock = this.otherLocks.get(type);
            if (lock == null) {
                try {
                    lock = (LockManager.LockableItem)type.newInstance();
                    this.otherLocks.put(type, lock);
                }
                catch (Exception ex) {
                    throw new LockException(ex);
                }
            }
            return (T)lock;
        }
    }

    @Override
    public LockManager.LockContext getCurrentLockContext() {
        Stack<LockManager.LockContext> stack = lockContextAssociation.get();
        return stack != null ? stack.peek() : null;
    }

    @Override
    public LockManager.LockContext lockItems(LockManager.Method method, LockManager.LockableItem ... items) {
        return this.lockItemsInternal(method, 30L, TimeUnit.SECONDS, items);
    }

    @Override
    public LockManager.LockContext lockItems(LockManager.Method method, long timeout, TimeUnit unit, LockManager.LockableItem ... items) {
        return this.lockItemsInternal(method, timeout, unit, items);
    }

    private synchronized LockManager.LockContext lockItemsInternal(LockManager.Method method, long timeout, TimeUnit unit, LockManager.LockableItem ... items) {
        LockContextImpl context = new LockContextImpl(method, items);
        long start = System.currentTimeMillis();
        while (!context.lockItems()) {
            long now = System.currentTimeMillis();
            if (now >= start + unit.toMillis(timeout)) {
                throw FrameworkMessages.MESSAGES.cannotObtainLockTimely(new TimeoutException(), context);
            }
            FrameworkLogger.LOGGER.tracef("LockManager lock: %s waiting ...", context);
            try {
                this.wait(unit.toMillis(timeout));
                FrameworkLogger.LOGGER.tracef("LockManager continue ...", new Object[0]);
            }
            catch (InterruptedException ex) {
                throw FrameworkMessages.MESSAGES.cannotObtainLockTimely(ex, context);
            }
        }
        FrameworkLogger.LOGGER.tracef("LockManager locked: %s", context);
        Stack<LockManager.LockContext> contextStack = lockContextAssociation.get();
        if (contextStack == null) {
            contextStack = new Stack();
            lockContextAssociation.set(contextStack);
        }
        contextStack.push(context);
        return context;
    }

    @Override
    public synchronized void unlockItems(LockManager.LockContext context) {
        if (context != null) {
            for (LockManager.LockableItem item : context.getItems()) {
                ReentrantLock lock = item.getReentrantLock();
                lock.unlock();
            }
            FrameworkLogger.LOGGER.tracef("LockManager unlocked: %s", context);
            Stack<LockManager.LockContext> contextStack = lockContextAssociation.get();
            contextStack.pop();
            if (contextStack.isEmpty()) {
                lockContextAssociation.remove();
            }
        }
        this.notifyAll();
    }

    static class LockContextImpl
    implements LockManager.LockContext {
        final List<LockManager.LockableItem> items;
        final LockManager.Method method;

        LockContextImpl(LockManager.Method method, LockManager.LockableItem ... items) {
            this.items = Arrays.asList(items);
            this.method = method;
        }

        @Override
        public List<LockManager.LockableItem> getItems() {
            return this.items;
        }

        @Override
        public LockManager.Method getMethod() {
            return this.method;
        }

        boolean lockItems() {
            LockManager.LockableItem item;
            ReentrantLock lock;
            int index = -1;
            Iterator<LockManager.LockableItem> i$ = this.items.iterator();
            while (i$.hasNext() && (lock = (item = i$.next()).getReentrantLock()).tryLock()) {
                ++index;
            }
            if (index + 1 == this.items.size()) {
                return true;
            }
            while (index >= 0) {
                LockManager.LockableItem item2 = this.items.get(index);
                ReentrantLock lock2 = item2.getReentrantLock();
                lock2.unlock();
                --index;
            }
            return false;
        }

        public String toString() {
            return "(" + (Object)((Object)this.method) + ") " + this.items;
        }
    }
}

