/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.net.ContentHandler;
import java.net.ContentHandlerFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jboss.osgi.framework.internal.OSGiContentHandlerFactory;
import org.jboss.osgi.framework.internal.ServiceReferenceComparator;
import org.osgi.framework.ServiceReference;

final class OSGiContentHandlerFactoryDelegate
implements ContentHandlerFactory {
    private ContentHandlerFactory delegate;
    private Map<String, List<ServiceReference<ContentHandler>>> contentHandlers = new HashMap<String, List<ServiceReference<ContentHandler>>>();

    OSGiContentHandlerFactoryDelegate() {
    }

    void setDelegateFactory(OSGiContentHandlerFactory factory) {
        this.delegate = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addHandler(String mimeType, ServiceReference<ContentHandler> reference) {
        Map<String, List<ServiceReference<ContentHandler>>> map = this.contentHandlers;
        synchronized (map) {
            List<ServiceReference<ContentHandler>> list = this.contentHandlers.get(mimeType);
            if (list == null) {
                list = new ArrayList<ServiceReference<ContentHandler>>();
                this.contentHandlers.put(mimeType, list);
            }
            list.add(reference);
            Collections.sort(list, Collections.reverseOrder(ServiceReferenceComparator.getInstance()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<ServiceReference<ContentHandler>> getContentHandlers(String mimetype) {
        Map<String, List<ServiceReference<ContentHandler>>> map = this.contentHandlers;
        synchronized (map) {
            return this.contentHandlers.get(mimetype);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeHandler(ServiceReference<ContentHandler> reference) {
        Map<String, List<ServiceReference<ContentHandler>>> map = this.contentHandlers;
        synchronized (map) {
            block3: for (List<ServiceReference<ContentHandler>> list : this.contentHandlers.values()) {
                Iterator<ServiceReference<ContentHandler>> it = list.iterator();
                while (it.hasNext()) {
                    if (!it.next().equals(reference)) continue;
                    it.remove();
                    continue block3;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearHandlers() {
        Map<String, List<ServiceReference<ContentHandler>>> map = this.contentHandlers;
        synchronized (map) {
            for (List<ServiceReference<ContentHandler>> list : this.contentHandlers.values()) {
                list.clear();
            }
        }
    }

    @Override
    public ContentHandler createContentHandler(String mimetype) {
        return this.delegate != null ? this.delegate.createContentHandler(mimetype) : null;
    }
}

