/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.io.IOException;
import java.io.InputStream;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.FrameworkMessages;
import org.jboss.osgi.framework.internal.BundleManagerPlugin;
import org.jboss.osgi.framework.internal.UserBundleRevision;
import org.jboss.osgi.framework.spi.BundleLifecycle;
import org.jboss.osgi.framework.spi.BundleManager;
import org.jboss.osgi.framework.spi.DeploymentProvider;
import org.jboss.osgi.framework.spi.IntegrationConstants;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.resolver.XBundle;
import org.jboss.osgi.resolver.XBundleRevision;
import org.jboss.osgi.vfs.AbstractVFS;
import org.jboss.osgi.vfs.VirtualFile;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.wiring.BundleRevision;

final class RecreateCurrentRevisionPolicy
implements BundleLifecycle.BundleRefreshPolicy {
    private final BundleManagerPlugin bundleManager;
    private VirtualFile rootFile;
    private XBundle bundle;

    RecreateCurrentRevisionPolicy(BundleManager bundleManager) {
        this.bundleManager = (BundleManagerPlugin)bundleManager;
    }

    @Override
    public void startBundleRefresh(XBundle bundle2) throws BundleException {
        this.bundle = bundle2;
        XBundleRevision brev = bundle2.getBundleRevision();
        UserBundleRevision userRev = UserBundleRevision.assertBundleRevision((BundleRevision)brev);
        Deployment dep = userRev.getDeployment();
        try {
            InputStream inputStream = dep.getRoot().getStreamURL().openStream();
            this.rootFile = AbstractVFS.toVirtualFile((InputStream)inputStream);
        }
        catch (IOException ex) {
            throw FrameworkMessages.MESSAGES.cannotObtainVirtualFile(ex);
        }
        this.bundleManager.removeRevisionLifecycle(brev, 0);
    }

    @Override
    public void refreshCurrentRevision(XBundleRevision brev) throws BundleException {
        DeploymentProvider deploymentManager = this.bundleManager.getFrameworkState().getDeploymentProvider();
        Deployment dep = deploymentManager.createDeployment(this.bundle.getLocation(), this.rootFile);
        OSGiMetaData metadata = deploymentManager.createOSGiMetaData(dep);
        dep.putAttachment(IntegrationConstants.OSGI_METADATA_KEY, (Object)metadata);
        dep.putAttachment(IntegrationConstants.BUNDLE_KEY, (Object)this.bundle);
        dep.setAutoStart(false);
        BundleContext context = this.bundleManager.getSystemBundle().getBundleContext();
        this.bundleManager.createBundleRevision(context, dep, null);
    }

    @Override
    public void endBundleRefresh(XBundle bundle2) {
    }
}

