/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.FrameworkLogger;
import org.jboss.osgi.framework.internal.AbstractBundleState;
import org.jboss.osgi.framework.internal.BundleManagerPlugin;
import org.jboss.osgi.framework.internal.FragmentBundleRevision;
import org.jboss.osgi.framework.internal.HostBundleRevision;
import org.jboss.osgi.framework.internal.InternalConstants;
import org.jboss.osgi.framework.internal.UserBundleRevision;
import org.jboss.osgi.framework.spi.BundleManager;
import org.jboss.osgi.framework.spi.FrameworkModuleLoader;
import org.jboss.osgi.framework.spi.FrameworkWiringLock;
import org.jboss.osgi.framework.spi.LockManager;
import org.jboss.osgi.framework.spi.ModuleManager;
import org.jboss.osgi.framework.spi.NativeCode;
import org.jboss.osgi.metadata.NativeLibraryMetaData;
import org.jboss.osgi.resolver.ResolverMessages;
import org.jboss.osgi.resolver.XBundle;
import org.jboss.osgi.resolver.XBundleRevision;
import org.jboss.osgi.resolver.XEnvironment;
import org.jboss.osgi.resolver.XIdentityCapability;
import org.jboss.osgi.resolver.XPackageRequirement;
import org.jboss.osgi.resolver.XRequirement;
import org.jboss.osgi.resolver.XResolveContext;
import org.jboss.osgi.resolver.XResolver;
import org.jboss.osgi.resolver.XResolverFactory;
import org.jboss.osgi.resolver.XResource;
import org.jboss.osgi.resolver.XResourceCapability;
import org.jboss.osgi.resolver.spi.AbstractBundleWire;
import org.jboss.osgi.resolver.spi.ResolverHookProcessor;
import org.jboss.osgi.resolver.spi.XResolverFactoryLocator;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.resource.Wire;
import org.osgi.resource.Wiring;
import org.osgi.service.resolver.ResolutionException;
import org.osgi.service.resolver.ResolveContext;

public final class ResolverImpl
implements XResolver {
    private final BundleManagerPlugin bundleManager;
    private final NativeCode nativeCode;
    private final ModuleManager moduleManager;
    private final FrameworkModuleLoader moduleLoader;
    private final XEnvironment environment;
    private final LockManager lockManager;
    private final XResolver delegate;

    public ResolverImpl(BundleManager bundleManager, NativeCode nativeCode, ModuleManager moduleManager, FrameworkModuleLoader moduleLoader, XEnvironment environment, LockManager lockManager) {
        this.bundleManager = (BundleManagerPlugin)bundleManager;
        this.nativeCode = nativeCode;
        this.moduleManager = moduleManager;
        this.moduleLoader = moduleLoader;
        this.environment = environment;
        this.lockManager = lockManager;
        XResolverFactory resolverFactory = XResolverFactoryLocator.getResolverFactory();
        this.delegate = resolverFactory.createResolver();
    }

    public XResolveContext createResolveContext(XEnvironment environment, Collection<? extends Resource> mandatory, Collection<? extends Resource> optional) {
        HashSet<Resource> manres = new HashSet<Resource>(mandatory != null ? mandatory : Collections.emptySet());
        HashSet<Resource> optres = new HashSet<Resource>(optional != null ? optional : Collections.emptySet());
        this.removeUninstalled(manres, optres);
        this.appendOptionalFragments(manres, optres);
        this.appendOptionalHostBundles(manres, optres);
        return this.delegate.createResolveContext(environment, manres, optres);
    }

    public synchronized Map<Resource, List<Wire>> resolve(ResolveContext resolveContext) throws ResolutionException {
        return this.resolveInternal(resolveContext, false);
    }

    public synchronized Map<Resource, List<Wire>> resolveAndApply(XResolveContext resolveContext) throws ResolutionException {
        return this.resolveInternal((ResolveContext)resolveContext, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Resource, List<Wire>> resolveInternal(ResolveContext resolveContext, boolean applyResults) throws ResolutionException {
        if (ResolverHookProcessor.getCurrentProcessor() != null) {
            throw ResolverMessages.MESSAGES.illegalStateResolverHookCannotTriggerResolveOperation();
        }
        BundleContext syscontext = this.bundleManager.getSystemContext();
        HashSet manres = new HashSet(resolveContext.getMandatoryResources());
        HashSet<Resource> optres = new HashSet<Resource>(resolveContext.getOptionalResources());
        ResolverHookProcessor hookregs = new ResolverHookProcessor(syscontext, this.bundleManager.getBundles(2));
        try {
            Map wiremap;
            if (hookregs.hasResolverHooks()) {
                hookregs.begin(manres, optres);
                hookregs.filterResolvable();
                hookregs.filterSingletonCollisions(new ResolverHookProcessor.SingletonLocator(){

                    public Collection<BundleCapability> findCollisionCandidates(BundleCapability viewpoint) {
                        HashSet<BundleCapability> result = new HashSet<BundleCapability>();
                        if (viewpoint instanceof XResourceCapability) {
                            String symbolicName = ((XResourceCapability)viewpoint).getSymbolicName();
                            for (XBundle bundle2 : ResolverImpl.this.bundleManager.getBundles(symbolicName, null)) {
                                XBundleRevision xres = bundle2.getBundleRevision();
                                List bcaps = xres.getDeclaredCapabilities(viewpoint.getNamespace());
                                if (bcaps.size() != 1) continue;
                                BundleCapability bcap = (BundleCapability)bcaps.get(0);
                                String spec = (String)bcap.getDirectives().get("singleton");
                                if (bcap == viewpoint || !Boolean.parseBoolean(spec)) continue;
                                result.add(bcap);
                            }
                        }
                        return result;
                    }
                });
                resolveContext = this.delegate.createResolveContext(this.environment, this.getFilteredResources(hookregs, manres), this.getFilteredResources(hookregs, optres));
            } else {
                this.filterSingletons(manres, optres);
                resolveContext = this.delegate.createResolveContext(this.environment, manres, optres);
            }
            LockManager.LockContext lockContext = null;
            try {
                FrameworkWiringLock wireLock = this.lockManager.getItemForType(FrameworkWiringLock.class);
                lockContext = this.lockManager.lockItems(LockManager.Method.RESOLVE, wireLock);
                wiremap = this.delegate.resolve(resolveContext);
                if (applyResults) {
                    this.applyResolverResults(wiremap);
                }
                this.lockManager.unlockItems(lockContext);
            }
            catch (Throwable throwable) {
                this.lockManager.unlockItems(lockContext);
                throw throwable;
            }
            this.sendBundleResolvedEvents(wiremap);
            Map map = wiremap;
            return map;
        }
        finally {
            hookregs.end();
        }
    }

    private Collection<? extends Resource> getFilteredResources(ResolverHookProcessor hookregs, Collection<? extends Resource> resources) {
        ArrayList<? extends Resource> filtered = null;
        if (resources != null) {
            filtered = new ArrayList<Resource>(resources);
            Iterator iterator = filtered.iterator();
            while (iterator.hasNext()) {
                Resource res = (Resource)iterator.next();
                if (hookregs.hasResource(res)) continue;
                iterator.remove();
            }
        }
        return filtered;
    }

    private void removeUninstalled(Collection<Resource> manres, Collection<Resource> optres) {
        for (Resource res : this.getCombinedResources(manres, optres)) {
            XBundleRevision brev = (XBundleRevision)res;
            if (brev.getBundle().getState() != 1) continue;
            manres.remove(brev);
            optres.remove(brev);
        }
    }

    private void appendOptionalFragments(Collection<? extends Resource> manres, Collection<Resource> optres) {
        HashSet<Capability> hostcaps = new HashSet<Capability>();
        HashSet<Resource> combined = this.getCombinedResources(manres, optres);
        for (Resource res : combined) {
            for (Capability hostcap : res.getCapabilities("osgi.wiring.host")) {
                hostcaps.add(hostcap);
            }
        }
        HashSet<XBundleRevision> fragments = new HashSet<XBundleRevision>();
        for (XResource res : this.environment.getResources(new String[]{"osgi.fragment"})) {
            XBundleRevision brev = (XBundleRevision)res;
            if (brev.getBundle().getState() == 1) continue;
            XRequirement xreq = (XRequirement)res.getRequirements("osgi.wiring.host").get(0);
            for (Capability cap : hostcaps) {
                if (!xreq.matches(cap) || combined.contains(brev)) continue;
                fragments.add(brev);
            }
        }
        if (!fragments.isEmpty()) {
            FrameworkLogger.LOGGER.debugf("Adding attachable fragments: %s", fragments);
            optres.addAll(fragments);
        }
    }

    private void appendOptionalHostBundles(Collection<? extends Resource> manres, Collection<Resource> optres) {
        for (Resource res : this.getCombinedResources(manres, optres)) {
            for (Requirement req : res.getRequirements("osgi.wiring.package")) {
                XPackageRequirement preq = (XPackageRequirement)req;
                if (!preq.isOptional()) continue;
                for (XBundle bundle2 : this.bundleManager.getBundles(2)) {
                    XBundleRevision auxrev = bundle2.getBundleRevision();
                    if (bundle2.isFragment() || manres.contains(auxrev)) continue;
                    optres.add((Resource)auxrev);
                }
                return;
            }
        }
    }

    private HashSet<Resource> getCombinedResources(Collection<? extends Resource> manres, Collection<Resource> optres) {
        HashSet<Resource> combined = new HashSet<Resource>(manres);
        combined.addAll(optres);
        return combined;
    }

    private void filterSingletons(Collection<? extends Resource> manres, Collection<Resource> optres) {
        HashMap<String, XResource> singletons = new HashMap<String, XResource>();
        for (Resource res : this.getCombinedResources(manres, optres)) {
            XResource xres = (XResource)res;
            XIdentityCapability icap = xres.getIdentityCapability();
            if (!icap.isSingleton()) continue;
            if (singletons.get(icap.getSymbolicName()) != null) {
                manres.remove(res);
                optres.remove(res);
                continue;
            }
            singletons.put(icap.getSymbolicName(), xres);
        }
    }

    private Map<Resource, Wiring> applyResolverResults(Map<Resource, List<Wire>> wiremap) throws ResolutionException {
        LinkedHashMap<BundleRevision, List<BundleWire>> brevmap = new LinkedHashMap<BundleRevision, List<BundleWire>>();
        for (Map.Entry<Resource, List<Wire>> entry : wiremap.entrySet()) {
            ArrayList<AbstractBundleWire> bwires = new ArrayList<AbstractBundleWire>();
            ArrayList<AbstractBundleWire> wires = new ArrayList<AbstractBundleWire>();
            for (Wire wire : entry.getValue()) {
                AbstractBundleWire bwire = new AbstractBundleWire(wire);
                bwires.add(bwire);
                wires.add(bwire);
            }
            Resource res = entry.getKey();
            brevmap.put((BundleRevision)res, bwires);
            wiremap.put(res, wires);
        }
        this.attachFragmentsToHost(brevmap);
        try {
            this.resolveNativeCodeLibraries(brevmap);
        }
        catch (BundleException ex) {
            throw new ResolutionException((Throwable)ex);
        }
        this.addModules(brevmap);
        this.createModuleServices(brevmap);
        Map wirings = this.environment.updateWiring(wiremap);
        for (Map.Entry entry : wirings.entrySet()) {
            XBundleRevision res = (XBundleRevision)entry.getKey();
            res.getWiringSupport().setWiring((Wiring)entry.getValue());
        }
        this.setBundleStatesToResolved(brevmap);
        return wirings;
    }

    private void attachFragmentsToHost(Map<BundleRevision, List<BundleWire>> wiremap) {
        for (Map.Entry<BundleRevision, List<BundleWire>> entry : wiremap.entrySet()) {
            XBundleRevision brev = (XBundleRevision)entry.getKey();
            if (!brev.isFragment()) continue;
            FragmentBundleRevision fragRev = (FragmentBundleRevision)brev;
            for (BundleWire wire : entry.getValue()) {
                BundleCapability cap = wire.getCapability();
                if (!"osgi.wiring.host".equals(cap.getNamespace())) continue;
                HostBundleRevision hostRev = (HostBundleRevision)cap.getResource();
                fragRev.attachToHost(hostRev);
            }
        }
    }

    private void resolveNativeCodeLibraries(Map<BundleRevision, List<BundleWire>> wiremap) throws BundleException {
        for (Map.Entry<BundleRevision, List<BundleWire>> entry : wiremap.entrySet()) {
            UserBundleRevision userRev;
            Deployment deployment;
            NativeLibraryMetaData libMetaData;
            XBundleRevision brev = (XBundleRevision)entry.getKey();
            if (!(brev instanceof UserBundleRevision) || (libMetaData = (NativeLibraryMetaData)(deployment = (userRev = (UserBundleRevision)brev).getDeployment()).getAttachment(InternalConstants.NATIVE_LIBRARY_METADATA_KEY)) == null) continue;
            this.nativeCode.resolveNativeCode((XBundleRevision)userRev);
        }
    }

    private void addModules(Map<BundleRevision, List<BundleWire>> wiremap) {
        for (Map.Entry<BundleRevision, List<BundleWire>> entry : wiremap.entrySet()) {
            XBundleRevision brev = (XBundleRevision)entry.getKey();
            if (brev.isFragment()) continue;
            List<BundleWire> wires = wiremap.get(brev);
            this.moduleManager.addModule(brev, wires);
        }
    }

    private void createModuleServices(Map<BundleRevision, List<BundleWire>> wiremap) {
        for (Map.Entry<BundleRevision, List<BundleWire>> entry : wiremap.entrySet()) {
            XBundleRevision brev = (XBundleRevision)entry.getKey();
            List<BundleWire> wires = entry.getValue();
            XBundle bundle2 = brev.getBundle();
            if (bundle2 == null || bundle2.getBundleId() == 0L || brev.isFragment()) continue;
            this.moduleLoader.createModuleService(brev, wires);
        }
    }

    private void setBundleStatesToResolved(Map<BundleRevision, List<BundleWire>> wiremap) {
        for (Map.Entry<BundleRevision, List<BundleWire>> entry : wiremap.entrySet()) {
            Bundle bundle2 = entry.getKey().getBundle();
            if (!(bundle2 instanceof AbstractBundleState)) continue;
            AbstractBundleState bundleState = (AbstractBundleState)bundle2;
            bundleState.changeState(4, 0);
        }
    }

    private void sendBundleResolvedEvents(Map<Resource, List<Wire>> wiremap) {
        for (Map.Entry<Resource, List<Wire>> entry : wiremap.entrySet()) {
            XBundleRevision brev = (XBundleRevision)entry.getKey();
            XBundle bundle2 = brev.getBundle();
            if (!(bundle2 instanceof AbstractBundleState)) continue;
            AbstractBundleState bundleState = (AbstractBundleState)bundle2;
            if (!this.bundleManager.isFrameworkCreated()) continue;
            bundleState.fireBundleEvent(32);
        }
    }
}

