/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.io.Closeable;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jboss.osgi.framework.FrameworkLogger;
import org.jboss.osgi.framework.FrameworkMessages;
import org.jboss.osgi.framework.internal.BundleManagerPlugin;
import org.jboss.osgi.framework.spi.BundleManager;
import org.jboss.osgi.framework.spi.StartLevelManager;
import org.jboss.osgi.framework.spi.StorageManager;
import org.jboss.osgi.framework.spi.StorageState;
import org.jboss.osgi.vfs.VFSUtils;
import org.jboss.osgi.vfs.VirtualFile;

public final class StorageManagerImpl
implements StorageManager {
    private final BundleManagerPlugin bundleManager;
    private final Map<String, StorageState> storageStates = new HashMap<String, StorageState>();
    private File storageArea;

    public StorageManagerImpl(BundleManager bundleManager) {
        this.bundleManager = (BundleManagerPlugin)bundleManager;
    }

    @Override
    public void initialize(Map<String, Object> props, boolean firstInit) throws IOException {
        String storageClean = (String)props.get("org.osgi.framework.storage.clean");
        if (firstInit && "onFirstInit".equals(storageClean)) {
            File storage = this.getStorageArea();
            FrameworkLogger.LOGGER.debugf("Deleting storage: %s", storage.getAbsolutePath());
            this.deleteRecursive(storage);
        }
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("bundle-");
            }
        };
        File[] storageDirs = this.getStorageArea().listFiles(filter);
        if (storageDirs != null) {
            for (File storageDir : storageDirs) {
                StorageState storageState = StorageState.createStorageState(storageDir);
                if (storageState.getBundleId() == 0L) continue;
                this.storageStates.put(storageState.getLocation(), storageState);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StorageState createStorageState(long bundleId, String location, Integer initialStartlevel, VirtualFile rootFile) throws IOException {
        int startlevel;
        assert (location != null) : "Null location";
        if (initialStartlevel != null) {
            startlevel = initialStartlevel;
        } else {
            StartLevelManager startLevelManager = this.bundleManager.getFrameworkState().getStartLevelManager();
            startlevel = startLevelManager.getInitialBundleStartLevel();
        }
        File bundleDir = this.getStorageDir(bundleId);
        Properties props = StorageState.loadProperties(bundleDir);
        String previousRev = props.getProperty("BundleRev");
        int revision = bundleId != 0L && previousRev != null ? Integer.parseInt(previousRev) + 1 : 0;
        props.put("Location", location);
        props.put("BundleId", new Long(bundleId).toString());
        props.put("BundleRev", new Integer(revision).toString());
        props.put("StartLevel", new Integer(startlevel).toString());
        props.put("LastModified", new Long(System.currentTimeMillis()).toString());
        StorageState storageState = StorageState.createStorageState(bundleDir, rootFile, props);
        Map<String, StorageState> map = this.storageStates;
        synchronized (map) {
            if (storageState.getBundleId() != 0L) {
                this.storageStates.put(storageState.getLocation(), storageState);
            }
        }
        return storageState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteStorageState(StorageState storageState) {
        FrameworkLogger.LOGGER.debugf("Deleting storage state: %s", storageState);
        VFSUtils.safeClose((Closeable)storageState.getRootFile());
        this.deleteRecursive(storageState.getStorageDir());
        Map<String, StorageState> map = this.storageStates;
        synchronized (map) {
            this.storageStates.remove(storageState.getLocation());
        }
    }

    @Override
    public Set<StorageState> getStorageStates() {
        return Collections.unmodifiableSet(new HashSet<StorageState>(this.storageStates.values()));
    }

    @Override
    public StorageState getStorageState(String location) {
        return location != null ? this.storageStates.get(location) : null;
    }

    @Override
    public File getStorageDir(long bundleId) {
        File bundleDir = new File(this.getStorageArea() + "/bundle-" + bundleId);
        if (!bundleDir.exists()) {
            bundleDir.mkdirs();
        }
        String filePath = bundleDir.getAbsolutePath();
        try {
            filePath = bundleDir.getCanonicalPath();
        }
        catch (IOException ex) {
            // empty catch block
        }
        return new File(filePath);
    }

    @Override
    public File getStorageArea() {
        if (this.storageArea == null) {
            String dirName = (String)this.bundleManager.getProperty("org.osgi.framework.storage");
            if (dirName == null) {
                try {
                    File storageDir = new File("./osgi-store");
                    dirName = storageDir.getCanonicalPath();
                }
                catch (IOException ex) {
                    throw FrameworkMessages.MESSAGES.illegalStateCannotCreateStorageArea(ex);
                }
            }
            this.storageArea = new File(dirName).getAbsoluteFile();
        }
        return this.storageArea;
    }

    @Override
    public File getDataFile(long bundleId, String filename) {
        File bundleDir = this.getStorageDir(bundleId);
        File dataFile = new File(bundleDir.getAbsolutePath() + File.separator + filename);
        dataFile.getParentFile().mkdirs();
        String filePath = dataFile.getAbsolutePath();
        try {
            filePath = dataFile.getCanonicalPath();
        }
        catch (IOException ex) {
            // empty catch block
        }
        return new File(filePath);
    }

    private void deleteRecursive(File file) {
        if (file.isDirectory()) {
            for (File aux : file.listFiles()) {
                this.deleteRecursive(aux);
            }
        }
        file.delete();
    }
}

