/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.osgi.framework.FrameworkMessages;
import org.jboss.osgi.framework.internal.BundleManagerPlugin;
import org.jboss.osgi.framework.internal.UserBundleState;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.hooks.weaving.WeavingHook;
import org.osgi.framework.hooks.weaving.WovenClass;
import org.osgi.framework.wiring.BundleWiring;

class WeavingContext {
    private static final ThreadLocal<WeavingContext> contextAssociation = new ThreadLocal();
    private static final Set<ServiceReference<WeavingHook>> blacklist = new HashSet<ServiceReference<WeavingHook>>();
    private final UserBundleState hostState;
    private final List<HookRegistration> weavingHooks;
    private final List<String> weavingImports = new ArrayList<String>();
    private Map<String, ContextClass> wovenClasses = new HashMap<String, ContextClass>();

    static WeavingContext getCurrentContext() {
        return contextAssociation.get();
    }

    static WeavingContext create(UserBundleState hostState) {
        WeavingContext context = new WeavingContext(hostState);
        contextAssociation.set(context);
        return context;
    }

    private WeavingContext(UserBundleState hostState) {
        this.hostState = hostState;
        BundleManagerPlugin bundleManager = hostState.getBundleManager();
        BundleContext syscontext = bundleManager.getSystemContext();
        Iterator<ServiceReference<WeavingHook>> iterator = blacklist.iterator();
        while (iterator.hasNext()) {
            ServiceReference<WeavingHook> sref = iterator.next();
            if (syscontext.getService(sref) != null) continue;
            iterator.remove();
        }
        Collection srefs = null;
        try {
            srefs = syscontext.getServiceReferences(WeavingHook.class, null);
        }
        catch (InvalidSyntaxException e) {
            // empty catch block
        }
        ArrayList sorted = new ArrayList(srefs);
        Collections.reverse(sorted);
        this.weavingHooks = new ArrayList<HookRegistration>();
        for (ServiceReference sref : sorted) {
            if (blacklist.contains(sref)) continue;
            WeavingHook hook = (WeavingHook)syscontext.getService(sref);
            this.weavingHooks.add(new HookRegistration((ServiceReference<WeavingHook>)sref, hook));
        }
    }

    List<HookRegistration> getWeavingHooks() {
        return this.weavingHooks;
    }

    void blacklist(ServiceReference<WeavingHook> sref) {
        blacklist.add(sref);
    }

    synchronized ContextClass createContextClass(String className, Class<?> redefinedClass, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
        ContextClass contextClass = new ContextClass(className, redefinedClass, protectionDomain, classfileBuffer);
        this.wovenClasses.put(contextClass.getClassName(), contextClass);
        return contextClass;
    }

    synchronized ContextClass getContextClass(String className) {
        return this.wovenClasses.get(className.replace('/', '.'));
    }

    void close() {
        contextAssociation.remove();
    }

    class ContextClass
    implements WovenClass {
        private final String className;
        private Class<?> redefinedClass;
        private ProtectionDomain protectionDomain;
        private boolean complete;
        private byte[] classfileBuffer;

        ContextClass(String className, Class<?> redefinedClass, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
            this.className = className.replace('/', '.');
            this.redefinedClass = redefinedClass;
            this.protectionDomain = protectionDomain;
            this.classfileBuffer = classfileBuffer;
        }

        public byte[] getBytes() {
            return this.classfileBuffer;
        }

        public void setBytes(byte[] newBytes) {
            this.assertNotComplete();
            this.classfileBuffer = newBytes;
        }

        public List<String> getDynamicImports() {
            return this.complete ? Collections.unmodifiableList(WeavingContext.this.weavingImports) : WeavingContext.this.weavingImports;
        }

        public boolean isWeavingComplete() {
            return this.complete;
        }

        void markComplete() {
            if (!this.complete) {
                this.classfileBuffer = Arrays.copyOf(this.classfileBuffer, this.classfileBuffer.length);
                this.complete = true;
            }
        }

        public String getClassName() {
            return this.className;
        }

        public ProtectionDomain getProtectionDomain() {
            return this.protectionDomain;
        }

        void setProtectionDomain(ProtectionDomain protectionDomain) {
            this.assertNotComplete();
            this.protectionDomain = protectionDomain;
        }

        public Class<?> getDefinedClass() {
            return this.redefinedClass;
        }

        void setDefinedClass(Class<?> definedClass) {
            this.assertNotComplete();
            this.redefinedClass = definedClass;
        }

        public BundleWiring getBundleWiring() {
            return WeavingContext.this.hostState.adapt(BundleWiring.class);
        }

        private void assertNotComplete() {
            if (this.complete) {
                throw FrameworkMessages.MESSAGES.illegalStateWeavingAlreadyComplete(this.className);
            }
        }
    }

    static class HookRegistration {
        final WeavingHook hook;
        final ServiceReference<WeavingHook> sref;

        HookRegistration(ServiceReference<WeavingHook> sref, WeavingHook hook) {
            this.sref = sref;
            this.hook = hook;
        }
    }
}

