/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.spi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.osgi.framework.FrameworkLogger;
import org.jboss.osgi.framework.spi.BootstrapBundlesComplete;
import org.jboss.osgi.framework.spi.BootstrapBundlesService;
import org.jboss.osgi.framework.spi.IntegrationServices;
import org.jboss.osgi.resolver.XBundle;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class BootstrapBundlesActivate<T>
extends BootstrapBundlesService<T> {
    private final Set<XBundle> resolvedBundles;

    public BootstrapBundlesActivate(ServiceName baseName, Set<XBundle> resolvedBundles) {
        super(baseName, IntegrationServices.BootstrapPhase.ACTIVATE);
        this.resolvedBundles = resolvedBundles;
    }

    @Override
    protected void addServiceDependencies(ServiceBuilder<T> builder) {
        builder.addDependencies(new ServiceName[]{this.getPreviousService()});
    }

    @Override
    public void start(StartContext startContext) throws StartException {
        super.start(startContext);
        ArrayList<XBundle> bundles = new ArrayList<XBundle>(this.resolvedBundles);
        Collections.sort(bundles, new Comparator<XBundle>(){

            @Override
            public int compare(XBundle o1, XBundle o2) {
                return (int)(o1.getBundleId() - o2.getBundleId());
            }
        });
        for (XBundle bundle2 : bundles) {
            try {
                bundle2.start(2);
            }
            catch (BundleException ex) {
                FrameworkLogger.LOGGER.errorCannotStartBundle(ex, (Bundle)bundle2);
            }
        }
        this.installCompleteService(startContext.getChildTarget());
    }

    protected ServiceController<T> installCompleteService(ServiceTarget serviceTarget) {
        return new BootstrapBundlesComplete(this.getServiceName().getParent()).install(serviceTarget, this.getServiceListener());
    }
}

