/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.spi;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.spi.AbstractIntegrationService;
import org.jboss.osgi.framework.spi.BundleManager;

public abstract class ExecutorServicePlugin<T>
extends AbstractIntegrationService<T> {
    private final InjectedValue<BundleManager> injectedBundleManager = new InjectedValue();
    private final String threadName;
    private ExecutorService executorService;

    protected ExecutorServicePlugin(ServiceName serviceName, String threadName) {
        super(serviceName);
        this.threadName = threadName;
    }

    @Override
    protected void addServiceDependencies(ServiceBuilder<T> builder) {
        builder.addDependency(Services.BUNDLE_MANAGER, BundleManager.class, this.injectedBundleManager);
    }

    @Override
    public void start(StartContext startContext) throws StartException {
        this.executorService = this.createExecutorService(this.threadName);
        this.getBundleManager().registerExecutorService(this.executorService);
        super.start(startContext);
    }

    public void stop(StopContext context) {
        this.executorService.shutdown();
        this.getBundleManager().unregisterExecutorService(this.executorService);
        super.stop(context);
    }

    protected BundleManager getBundleManager() {
        return (BundleManager)this.injectedBundleManager.getValue();
    }

    protected ExecutorService getExecutorService() {
        return this.executorService;
    }

    private ExecutorService createExecutorService(final String threadName) {
        ExecutorService service = Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable run) {
                Thread thread = new Thread(run);
                thread.setName(threadName);
                return thread;
            }
        });
        return service;
    }
}

