/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.spi;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.StartException;
import org.jboss.osgi.framework.FrameworkLogger;
import org.jboss.osgi.framework.FrameworkMessages;

public final class FutureServiceValue<T>
implements Future<T> {
    private final ServiceController<T> controller;
    private final ServiceController.State expectedState;

    public FutureServiceValue(ServiceController<T> controller) {
        this(controller, ServiceController.State.UP);
    }

    public FutureServiceValue(ServiceController<T> controller, ServiceController.State state) {
        if (controller == null) {
            throw FrameworkMessages.MESSAGES.illegalArgumentNull("controller");
        }
        if (state == null) {
            throw FrameworkMessages.MESSAGES.illegalArgumentNull("state");
        }
        this.controller = controller;
        this.expectedState = state;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return this.controller.getState() == this.expectedState;
    }

    @Override
    public T get() throws ExecutionException {
        try {
            return this.get(5L, TimeUnit.SECONDS);
        }
        catch (TimeoutException ex) {
            throw new ExecutionException(ex);
        }
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws ExecutionException, TimeoutException {
        return this.getValue(timeout, unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T getValue(long timeout, TimeUnit unit) throws ExecutionException, TimeoutException {
        if (this.controller.getState() == this.expectedState) {
            return (T)(ServiceController.State.UP == this.expectedState ? this.controller.getValue() : null);
        }
        final CountDownLatch latch = new CountDownLatch(1);
        final FutureServiceValue futureServiceValue = this;
        final String serviceName = this.controller.getName().getCanonicalName();
        AbstractServiceListener listener = new AbstractServiceListener<T>(){

            public void listenerAdded(ServiceController<? extends T> controller) {
                ServiceController.State state = controller.getState();
                if (state == FutureServiceValue.this.expectedState || state == ServiceController.State.START_FAILED) {
                    this.listenerDone(controller);
                }
            }

            public void transition(ServiceController<? extends T> controller, ServiceController.Transition transition) {
                FrameworkLogger.LOGGER.tracef("transition %s %s => %s", futureServiceValue, serviceName, transition);
                ServiceController.Substate targetState = transition.getAfter();
                switch (FutureServiceValue.this.expectedState) {
                    case UP: {
                        if (targetState != ServiceController.Substate.UP && targetState != ServiceController.Substate.START_FAILED) break;
                        this.listenerDone(controller);
                        break;
                    }
                    case DOWN: {
                        if (targetState != ServiceController.Substate.DOWN) break;
                        this.listenerDone(controller);
                        break;
                    }
                    case REMOVED: {
                        if (targetState != ServiceController.Substate.REMOVED) break;
                        this.listenerDone(controller);
                    }
                }
            }

            private void listenerDone(ServiceController<? extends T> controller) {
                latch.countDown();
            }
        };
        this.controller.addListener((ServiceListener)listener);
        try {
            if (!latch.await(timeout, unit)) {
                TimeoutException ex = FrameworkMessages.MESSAGES.timeoutGettingService(serviceName);
                throw ex;
            }
        }
        catch (InterruptedException e) {
        }
        finally {
            this.controller.removeListener((ServiceListener)listener);
        }
        if (this.controller.getState() == this.expectedState) {
            return (T)(this.expectedState == ServiceController.State.UP ? this.controller.getValue() : null);
        }
        Object cause = this.controller.getStartException();
        while (cause instanceof StartException && cause.getCause() != null) {
            cause = cause.getCause();
        }
        if (cause instanceof RuntimeException) {
            throw (RuntimeException)cause;
        }
        throw FrameworkMessages.MESSAGES.cannotGetServiceValue((Throwable)cause, serviceName);
    }
}

