/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.spi;

import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.internal.StartLevelImpl;
import org.jboss.osgi.framework.spi.AbstractIntegrationService;
import org.jboss.osgi.framework.spi.BundleManager;
import org.jboss.osgi.framework.spi.IntegrationServices;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.startlevel.StartLevel;

public class StartLevelPlugin
extends AbstractIntegrationService<StartLevel> {
    private final InjectedValue<BundleManager> injectedBundleManager = new InjectedValue();
    private final InjectedValue<BundleContext> injectedSystemContext = new InjectedValue();
    private ServiceRegistration<StartLevel> registration;

    public StartLevelPlugin() {
        super(IntegrationServices.DEPRECATED_START_LEVEL_PLUGIN);
    }

    @Override
    protected void addServiceDependencies(ServiceBuilder<StartLevel> builder) {
        builder.addDependency(Services.BUNDLE_MANAGER, BundleManager.class, this.injectedBundleManager);
        builder.addDependency(Services.FRAMEWORK_CREATE, BundleContext.class, this.injectedSystemContext);
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    @Override
    public void start(StartContext startContext) throws StartException {
        super.start(startContext);
        BundleContext systemContext = (BundleContext)this.injectedSystemContext.getValue();
        this.registration = systemContext.registerService(StartLevel.class, this.getValue(), null);
    }

    @Override
    protected StartLevel createServiceValue(StartContext startContext) throws StartException {
        BundleManager bundleManager = (BundleManager)this.injectedBundleManager.getValue();
        return new StartLevelImpl(bundleManager);
    }

    public void stop(StopContext context) {
        this.registration.unregister();
    }
}

