/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.json;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.json.JsonException;
import javax.json.stream.JsonLocation;
import javax.json.stream.JsonParser;
import javax.json.stream.JsonParsingException;
import org.glassfish.json.JsonLocationImpl;
import org.glassfish.json.JsonTokenizer;
import org.glassfish.json.UnicodeDetectingInputStream;

public class JsonParserImpl
implements JsonParser {
    private State currentState = State.START_DOCUMENT;
    private State enclosingState = State.START_DOCUMENT;
    private JsonParser.Event currentEvent;
    private final Deque<State> stack = new ArrayDeque<State>();
    private final StateIterator stateIterator;
    private final JsonTokenizer tokenizer;
    private int depth = 0;

    public JsonParserImpl(Reader reader) {
        this.tokenizer = new JsonTokenizer(reader);
        this.stateIterator = new StateIterator();
    }

    public JsonParserImpl(InputStream in) {
        UnicodeDetectingInputStream uin = new UnicodeDetectingInputStream(in);
        this.tokenizer = new JsonTokenizer(new InputStreamReader((InputStream)uin, uin.getCharset()));
        this.stateIterator = new StateIterator();
    }

    public JsonParserImpl(InputStream in, Charset encoding) {
        this.tokenizer = new JsonTokenizer(new InputStreamReader(in, encoding));
        this.stateIterator = new StateIterator();
    }

    @Override
    public String getString() {
        if (this.currentEvent == JsonParser.Event.KEY_NAME || this.currentEvent == JsonParser.Event.VALUE_STRING || this.currentEvent == JsonParser.Event.VALUE_NUMBER) {
            return this.tokenizer.getValue();
        }
        throw new IllegalStateException("JsonParser#getString() is valid only KEY_NAME, VALUE_STRING, VALUE_NUMBER parser states. But current parser state is " + (Object)((Object)this.currentEvent));
    }

    @Override
    public boolean isIntegralNumber() {
        if (this.currentEvent != JsonParser.Event.VALUE_NUMBER) {
            throw new IllegalStateException("JsonParser#isIntegralNumber() is valid only VALUE_NUMBER parser state. But current parser state is " + (Object)((Object)this.currentEvent));
        }
        BigDecimal bigDecimal = new BigDecimal(this.tokenizer.getValue());
        return bigDecimal.scale() == 0;
    }

    @Override
    public int getInt() {
        if (this.currentEvent != JsonParser.Event.VALUE_NUMBER) {
            throw new IllegalStateException("JsonParser#getNumberType() is valid only VALUE_NUMBER parser state. But current parser state is " + (Object)((Object)this.currentEvent));
        }
        return new BigDecimal(this.tokenizer.getValue()).intValue();
    }

    @Override
    public long getLong() {
        if (this.currentEvent != JsonParser.Event.VALUE_NUMBER) {
            throw new IllegalStateException("JsonParser#getNumberType() is valid only VALUE_NUMBER parser state. But current parser state is " + (Object)((Object)this.currentEvent));
        }
        return new BigDecimal(this.tokenizer.getValue()).longValue();
    }

    @Override
    public BigDecimal getBigDecimal() {
        if (this.currentEvent != JsonParser.Event.VALUE_NUMBER) {
            throw new IllegalStateException("JsonParser#getNumberType() is valid only VALUE_NUMBER parser state. But current parser state is " + (Object)((Object)this.currentEvent));
        }
        return new BigDecimal(this.tokenizer.getValue());
    }

    @Override
    public JsonLocation getLocation() {
        return JsonLocationImpl.UNKNOWN;
    }

    @Override
    public boolean hasNext() {
        return this.stateIterator.hasNext();
    }

    @Override
    public JsonParser.Event next() {
        return this.stateIterator.next();
    }

    @Override
    public void close() {
        try {
            this.tokenizer.close();
        }
        catch (IOException e) {
            throw new JsonException("I/O error while closing JSON tokenizer", e);
        }
    }

    private static enum State {
        START_DOCUMENT,
        START_OBJECT,
        KEY,
        COLON,
        OBJECT_STRING,
        OBJECT_NUMBER,
        OBJECT_TRUE,
        OBJECT_FALSE,
        OBJECT_NULL,
        OBJECT_COMMA,
        END_OBJECT{

            @Override
            State getTransition(JsonTokenizer.JsonToken token, State enclosingState) {
                if (token == JsonTokenizer.JsonToken.COMMA) {
                    return enclosingState == COLON ? OBJECT_COMMA : ARRAY_COMMA;
                }
                return (State)((Object)this.transitions.get((Object)token));
            }
        }
        ,
        START_ARRAY,
        ARRAY_STRING,
        ARRAY_NUMBER,
        ARRAY_TRUE,
        ARRAY_FALSE,
        ARRAY_NULL,
        ARRAY_COMMA,
        END_ARRAY{

            @Override
            State getTransition(JsonTokenizer.JsonToken token, State enclosingState) {
                if (token == JsonTokenizer.JsonToken.COMMA) {
                    return enclosingState == COLON ? OBJECT_COMMA : ARRAY_COMMA;
                }
                return (State)((Object)this.transitions.get((Object)token));
            }
        }
        ,
        END_DOCUMENT;

        final EnumMap<JsonTokenizer.JsonToken, State> transitions = new EnumMap(JsonTokenizer.JsonToken.class);

        private void transition(JsonTokenizer.JsonToken token, State state) {
            this.transitions.put(token, state);
        }

        State getTransition(JsonTokenizer.JsonToken token, State enclosingState) {
            return this.transitions.get((Object)token);
        }

        static {
            START_DOCUMENT.transition(JsonTokenizer.JsonToken.CURLYOPEN, START_OBJECT);
            START_DOCUMENT.transition(JsonTokenizer.JsonToken.SQUAREOPEN, START_ARRAY);
            START_OBJECT.transition(JsonTokenizer.JsonToken.CURLYCLOSE, END_OBJECT);
            START_OBJECT.transition(JsonTokenizer.JsonToken.STRING, KEY);
            KEY.transition(JsonTokenizer.JsonToken.COLON, COLON);
            COLON.transition(JsonTokenizer.JsonToken.STRING, OBJECT_STRING);
            COLON.transition(JsonTokenizer.JsonToken.NUMBER, OBJECT_NUMBER);
            COLON.transition(JsonTokenizer.JsonToken.TRUE, OBJECT_TRUE);
            COLON.transition(JsonTokenizer.JsonToken.FALSE, OBJECT_FALSE);
            COLON.transition(JsonTokenizer.JsonToken.NULL, OBJECT_NULL);
            COLON.transition(JsonTokenizer.JsonToken.CURLYOPEN, START_OBJECT);
            COLON.transition(JsonTokenizer.JsonToken.SQUAREOPEN, START_ARRAY);
            OBJECT_STRING.transition(JsonTokenizer.JsonToken.CURLYCLOSE, END_OBJECT);
            OBJECT_STRING.transition(JsonTokenizer.JsonToken.COMMA, OBJECT_COMMA);
            OBJECT_NUMBER.transition(JsonTokenizer.JsonToken.CURLYCLOSE, END_OBJECT);
            OBJECT_NUMBER.transition(JsonTokenizer.JsonToken.COMMA, OBJECT_COMMA);
            OBJECT_TRUE.transition(JsonTokenizer.JsonToken.CURLYCLOSE, END_OBJECT);
            OBJECT_TRUE.transition(JsonTokenizer.JsonToken.COMMA, OBJECT_COMMA);
            OBJECT_FALSE.transition(JsonTokenizer.JsonToken.CURLYCLOSE, END_OBJECT);
            OBJECT_FALSE.transition(JsonTokenizer.JsonToken.COMMA, OBJECT_COMMA);
            OBJECT_NULL.transition(JsonTokenizer.JsonToken.CURLYCLOSE, END_OBJECT);
            OBJECT_NULL.transition(JsonTokenizer.JsonToken.COMMA, OBJECT_COMMA);
            OBJECT_COMMA.transition(JsonTokenizer.JsonToken.STRING, KEY);
            END_OBJECT.transition(JsonTokenizer.JsonToken.CURLYCLOSE, END_OBJECT);
            END_OBJECT.transition(JsonTokenizer.JsonToken.SQUARECLOSE, END_ARRAY);
            END_OBJECT.transition(JsonTokenizer.JsonToken.EOF, END_DOCUMENT);
            START_ARRAY.transition(JsonTokenizer.JsonToken.STRING, ARRAY_STRING);
            START_ARRAY.transition(JsonTokenizer.JsonToken.NUMBER, ARRAY_NUMBER);
            START_ARRAY.transition(JsonTokenizer.JsonToken.TRUE, ARRAY_TRUE);
            START_ARRAY.transition(JsonTokenizer.JsonToken.FALSE, ARRAY_FALSE);
            START_ARRAY.transition(JsonTokenizer.JsonToken.NULL, ARRAY_NULL);
            START_ARRAY.transition(JsonTokenizer.JsonToken.CURLYOPEN, START_OBJECT);
            START_ARRAY.transition(JsonTokenizer.JsonToken.SQUAREOPEN, START_ARRAY);
            START_ARRAY.transition(JsonTokenizer.JsonToken.SQUARECLOSE, END_ARRAY);
            ARRAY_STRING.transition(JsonTokenizer.JsonToken.COMMA, ARRAY_COMMA);
            ARRAY_STRING.transition(JsonTokenizer.JsonToken.SQUARECLOSE, END_ARRAY);
            ARRAY_NUMBER.transition(JsonTokenizer.JsonToken.COMMA, ARRAY_COMMA);
            ARRAY_NUMBER.transition(JsonTokenizer.JsonToken.SQUARECLOSE, END_ARRAY);
            ARRAY_TRUE.transition(JsonTokenizer.JsonToken.COMMA, ARRAY_COMMA);
            ARRAY_TRUE.transition(JsonTokenizer.JsonToken.SQUARECLOSE, END_ARRAY);
            ARRAY_FALSE.transition(JsonTokenizer.JsonToken.COMMA, ARRAY_COMMA);
            ARRAY_FALSE.transition(JsonTokenizer.JsonToken.SQUARECLOSE, END_ARRAY);
            ARRAY_NULL.transition(JsonTokenizer.JsonToken.COMMA, ARRAY_COMMA);
            ARRAY_NULL.transition(JsonTokenizer.JsonToken.SQUARECLOSE, END_ARRAY);
            ARRAY_COMMA.transition(JsonTokenizer.JsonToken.STRING, ARRAY_STRING);
            ARRAY_COMMA.transition(JsonTokenizer.JsonToken.NUMBER, ARRAY_NUMBER);
            ARRAY_COMMA.transition(JsonTokenizer.JsonToken.TRUE, ARRAY_TRUE);
            ARRAY_COMMA.transition(JsonTokenizer.JsonToken.FALSE, ARRAY_FALSE);
            ARRAY_COMMA.transition(JsonTokenizer.JsonToken.NULL, ARRAY_NULL);
            ARRAY_COMMA.transition(JsonTokenizer.JsonToken.CURLYOPEN, START_OBJECT);
            ARRAY_COMMA.transition(JsonTokenizer.JsonToken.SQUAREOPEN, START_ARRAY);
            END_ARRAY.transition(JsonTokenizer.JsonToken.CURLYCLOSE, END_OBJECT);
            END_ARRAY.transition(JsonTokenizer.JsonToken.SQUARECLOSE, END_ARRAY);
            END_ARRAY.transition(JsonTokenizer.JsonToken.EOF, END_DOCUMENT);
        }
    }

    private class StateIterator
    implements Iterator<JsonParser.Event> {
        JsonTokenizer.JsonToken token;

        private StateIterator() {
        }

        @Override
        public boolean hasNext() {
            if (this.token == JsonTokenizer.JsonToken.EOF) {
                return false;
            }
            return JsonParserImpl.this.depth != 0 || JsonParserImpl.this.currentState != State.END_OBJECT && JsonParserImpl.this.currentState != State.END_ARRAY;
        }

        @Override
        public JsonParser.Event next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            block23: while (true) {
                try {
                    this.token = JsonParserImpl.this.tokenizer.nextToken();
                }
                catch (IOException ioe) {
                    throw new JsonException("I/O error while moving parser to next state", ioe);
                }
                State nextState = JsonParserImpl.this.currentState.getTransition(this.token, JsonParserImpl.this.enclosingState);
                if (nextState == null) {
                    throw new JsonParsingException("Expecting Tokens=" + ((JsonParserImpl)JsonParserImpl.this).currentState.transitions.keySet() + "Got =" + (Object)((Object)this.token), JsonLocationImpl.UNKNOWN);
                }
                if (nextState == State.START_OBJECT || nextState == State.START_ARRAY) {
                    JsonParserImpl.this.stack.addFirst(JsonParserImpl.this.currentState);
                }
                JsonParserImpl.this.currentState = nextState;
                switch (JsonParserImpl.this.currentState) {
                    case START_DOCUMENT: {
                        continue block23;
                    }
                    case START_OBJECT: {
                        JsonParserImpl.this.depth++;
                        return JsonParserImpl.this.currentEvent = JsonParser.Event.START_OBJECT;
                    }
                    case KEY: {
                        return JsonParserImpl.this.currentEvent = JsonParser.Event.KEY_NAME;
                    }
                    case COLON: {
                        continue block23;
                    }
                    case OBJECT_STRING: {
                        return JsonParserImpl.this.currentEvent = JsonParser.Event.VALUE_STRING;
                    }
                    case OBJECT_NUMBER: {
                        return JsonParserImpl.this.currentEvent = JsonParser.Event.VALUE_NUMBER;
                    }
                    case OBJECT_TRUE: {
                        return JsonParserImpl.this.currentEvent = JsonParser.Event.VALUE_TRUE;
                    }
                    case OBJECT_FALSE: {
                        return JsonParserImpl.this.currentEvent = JsonParser.Event.VALUE_FALSE;
                    }
                    case OBJECT_NULL: {
                        return JsonParserImpl.this.currentEvent = JsonParser.Event.VALUE_NULL;
                    }
                    case OBJECT_COMMA: {
                        continue block23;
                    }
                    case END_OBJECT: {
                        JsonParserImpl.this.depth--;
                        JsonParserImpl.this.enclosingState = (State)((Object)JsonParserImpl.this.stack.removeFirst());
                        return JsonParserImpl.this.currentEvent = JsonParser.Event.END_OBJECT;
                    }
                    case START_ARRAY: {
                        JsonParserImpl.this.depth++;
                        return JsonParserImpl.this.currentEvent = JsonParser.Event.START_ARRAY;
                    }
                    case ARRAY_STRING: {
                        return JsonParserImpl.this.currentEvent = JsonParser.Event.VALUE_STRING;
                    }
                    case ARRAY_NUMBER: {
                        return JsonParserImpl.this.currentEvent = JsonParser.Event.VALUE_NUMBER;
                    }
                    case ARRAY_TRUE: {
                        return JsonParserImpl.this.currentEvent = JsonParser.Event.VALUE_TRUE;
                    }
                    case ARRAY_FALSE: {
                        return JsonParserImpl.this.currentEvent = JsonParser.Event.VALUE_FALSE;
                    }
                    case ARRAY_NULL: {
                        return JsonParserImpl.this.currentEvent = JsonParser.Event.VALUE_NULL;
                    }
                    case ARRAY_COMMA: {
                        continue block23;
                    }
                    case END_ARRAY: {
                        JsonParserImpl.this.depth--;
                        JsonParserImpl.this.enclosingState = (State)((Object)JsonParserImpl.this.stack.removeFirst());
                        return JsonParserImpl.this.currentEvent = JsonParser.Event.END_ARRAY;
                    }
                }
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

