/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.deployment.interceptor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jboss.osgi.deployment.DeploymentLogger;
import org.jboss.osgi.deployment.DeploymentMessages;
import org.jboss.osgi.deployment.interceptor.InterceptorWrapper;
import org.jboss.osgi.deployment.interceptor.InvocationContext;
import org.jboss.osgi.deployment.interceptor.LifecycleInterceptor;
import org.jboss.osgi.deployment.interceptor.LifecycleInterceptorService;
import org.jboss.osgi.spi.AttachmentKey;
import org.jboss.osgi.spi.ConstantsHelper;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public abstract class AbstractLifecycleInterceptorService
implements LifecycleInterceptorService {
    private final List<LifecycleInterceptor> interceptorChain = new ArrayList<LifecycleInterceptor>();
    private ServiceTracker<LifecycleInterceptor, LifecycleInterceptor> tracker;

    @Override
    public void start(BundleContext context) {
        if (context == null) {
            throw DeploymentMessages.MESSAGES.illegalArgumentNull("context");
        }
        this.tracker = new ServiceTracker<LifecycleInterceptor, LifecycleInterceptor>(context, LifecycleInterceptor.class, null){

            public LifecycleInterceptor addingService(ServiceReference<LifecycleInterceptor> sref) {
                LifecycleInterceptor interceptor = (LifecycleInterceptor)super.addingService(sref);
                AbstractLifecycleInterceptorService.this.addInterceptor(interceptor);
                return interceptor;
            }

            public void removedService(ServiceReference<LifecycleInterceptor> sref, LifecycleInterceptor service) {
                LifecycleInterceptor interceptor = service;
                AbstractLifecycleInterceptorService.this.removeInterceptor(interceptor);
            }
        };
        this.tracker.open();
    }

    @Override
    public void stop() {
        if (this.tracker != null) {
            this.tracker.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addInterceptor(LifecycleInterceptor interceptor) {
        if (interceptor == null) {
            throw DeploymentMessages.MESSAGES.illegalArgumentNull("interceptor");
        }
        DeploymentLogger.LOGGER.debugf("Add interceptor: %s", new InterceptorWrapper(interceptor));
        List<LifecycleInterceptor> list = this.interceptorChain;
        synchronized (list) {
            HashSet<LifecycleInterceptor> unsortedSet = new HashSet<LifecycleInterceptor>();
            unsortedSet.addAll(this.interceptorChain);
            unsortedSet.add(interceptor);
            ArrayList<LifecycleInterceptor> sortedList = new ArrayList<LifecycleInterceptor>();
            Iterator itUnsorted = unsortedSet.iterator();
            while (itUnsorted.hasNext()) {
                LifecycleInterceptor aux = (LifecycleInterceptor)itUnsorted.next();
                if (aux.getInput() != null) continue;
                this.addWithRelativeOrder(sortedList, aux);
                itUnsorted.remove();
            }
            HashSet providedOutputs = new HashSet();
            for (LifecycleInterceptor aux : sortedList) {
                Set<AttachmentKey<?>> auxOutput = aux.getOutput();
                if (auxOutput == null) continue;
                providedOutputs.addAll(auxOutput);
            }
            itUnsorted = unsortedSet.iterator();
            while (itUnsorted.hasNext()) {
                LifecycleInterceptor aux = (LifecycleInterceptor)itUnsorted.next();
                Set<AttachmentKey<?>> input = aux.getInput();
                if (input == null) {
                    throw DeploymentMessages.MESSAGES.illegalStateInterceptorWithNoInputsAdded();
                }
                if (!providedOutputs.containsAll(input)) continue;
                this.addWithRelativeOrder(sortedList, aux);
                itUnsorted.remove();
            }
            for (LifecycleInterceptor aux : unsortedSet) {
                this.addWithRelativeOrder(sortedList, aux);
            }
            if (DeploymentLogger.LOGGER.isTraceEnabled()) {
                StringBuffer buffer = new StringBuffer();
                for (LifecycleInterceptor aux : sortedList) {
                    InterceptorWrapper wrapper = new InterceptorWrapper(aux);
                    buffer.append("\n  " + wrapper.toLongString());
                }
                DeploymentLogger.LOGGER.tracef("Resulting interceptor chain %s", buffer);
            }
            this.interceptorChain.clear();
            this.interceptorChain.addAll(sortedList);
        }
    }

    private void addWithRelativeOrder(List<LifecycleInterceptor> sortedList, LifecycleInterceptor interceptor) {
        HashSet providedOutputs = new HashSet();
        int relOrder = interceptor.getRelativeOrder();
        Set<AttachmentKey<?>> input = interceptor.getInput();
        for (int i = 0; i < sortedList.size(); ++i) {
            boolean inputsProvided;
            LifecycleInterceptor aux = sortedList.get(i);
            int auxOrder = aux.getRelativeOrder();
            boolean bl = inputsProvided = input == null || providedOutputs.containsAll(input);
            if (inputsProvided && relOrder <= auxOrder) {
                sortedList.add(i, interceptor);
                return;
            }
            Set<AttachmentKey<?>> auxOutput = aux.getOutput();
            if (auxOutput == null) continue;
            providedOutputs.addAll(auxOutput);
        }
        sortedList.add(interceptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeInterceptor(LifecycleInterceptor interceptor) {
        if (interceptor == null) {
            throw DeploymentMessages.MESSAGES.illegalArgumentNull("interceptor");
        }
        DeploymentLogger.LOGGER.debugf("Remove interceptor: %s", new InterceptorWrapper(interceptor));
        List<LifecycleInterceptor> list = this.interceptorChain;
        synchronized (list) {
            this.interceptorChain.remove(interceptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<LifecycleInterceptor> getInterceptorChain() {
        List<LifecycleInterceptor> list = this.interceptorChain;
        synchronized (list) {
            return Collections.unmodifiableList(this.interceptorChain);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleStateChange(int state, Bundle bundle2) {
        List<LifecycleInterceptor> list = this.interceptorChain;
        synchronized (list) {
            if (this.interceptorChain.size() == 0) {
                return;
            }
            InvocationContext inv = this.getInvocationContext(bundle2);
            if (inv == null) {
                throw DeploymentMessages.MESSAGES.illegalStateCannotObtainInvocationContext(bundle2);
            }
            for (LifecycleInterceptor aux : this.interceptorChain) {
                Set<AttachmentKey<?>> input = aux.getInput();
                boolean doInvocation = true;
                if (input != null) {
                    for (AttachmentKey<?> key : input) {
                        if (inv.getAttachment(key) != null) continue;
                        doInvocation = false;
                        break;
                    }
                }
                if (!doInvocation) continue;
                InterceptorWrapper wrapper = new InterceptorWrapper(aux);
                String stateName = ConstantsHelper.bundleState((int)state);
                String location = inv.getBundle().getLocation();
                DeploymentLogger.LOGGER.tracef("Invoke: %s with state %s on %s", wrapper, stateName, location);
                aux.invoke(state, inv);
            }
        }
    }

    protected abstract InvocationContext getInvocationContext(Bundle var1);
}

