/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.vfs30;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import java.util.WeakHashMap;
import org.jboss.osgi.vfs.VFSAdaptor;
import org.jboss.osgi.vfs.VFSMessages;
import org.jboss.osgi.vfs.VirtualFile;
import org.jboss.osgi.vfs30.VirtualFileAdaptor30;
import org.jboss.vfs.VFS;

public final class VFSAdaptor30
implements VFSAdaptor {
    private static Map<org.jboss.vfs.VirtualFile, VirtualFile> registry = new WeakHashMap<org.jboss.vfs.VirtualFile, VirtualFile>();

    public VirtualFile toVirtualFile(URL url) throws IOException {
        try {
            return this.toVirtualFile(url.toURI());
        }
        catch (URISyntaxException ex) {
            throw new IOException(ex);
        }
    }

    public VirtualFile toVirtualFile(URI uri) throws IOException {
        org.jboss.vfs.VirtualFile vfsFile = VFS.getChild((URI)uri);
        return (VirtualFileAdaptor30)this.adapt(vfsFile);
    }

    public VirtualFile toVirtualFile(String name, InputStream inputStream) throws IOException {
        return new VirtualFileAdaptor30(name, inputStream);
    }

    public VirtualFile toVirtualFile(InputStream inputStream) throws IOException {
        String name = "stream" + System.currentTimeMillis();
        return new VirtualFileAdaptor30(name, inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VirtualFile adapt(Object other) {
        VirtualFile absFile;
        if (other == null) {
            return null;
        }
        if (!(other instanceof org.jboss.vfs.VirtualFile)) {
            throw VFSMessages.MESSAGES.illegalArgumentNoVirtualFile(other);
        }
        Map<org.jboss.vfs.VirtualFile, VirtualFile> map = registry;
        synchronized (map) {
            org.jboss.vfs.VirtualFile vfsFile = (org.jboss.vfs.VirtualFile)other;
            absFile = registry.get(other);
            if (absFile == null) {
                absFile = new VirtualFileAdaptor30(vfsFile);
                registry.put(vfsFile, absFile);
            }
        }
        return absFile;
    }

    public Object adapt(VirtualFile absFile) {
        if (absFile == null) {
            return null;
        }
        VirtualFileAdaptor30 adaptor = (VirtualFileAdaptor30)absFile;
        return adaptor.getVirtualFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void unregister(VirtualFileAdaptor30 absFile) {
        Map<org.jboss.vfs.VirtualFile, VirtualFile> map = registry;
        synchronized (map) {
            registry.remove(absFile.getVirtualFile());
        }
    }
}

