/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap;

import com.google.common.base.Function;
import com.google.common.collect.ConcurrentHashMultiset;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.enterprise.inject.spi.Bean;
import org.jboss.weld.bean.AbstractBean;
import org.jboss.weld.bean.AbstractClassBean;
import org.jboss.weld.bean.AbstractProducerBean;
import org.jboss.weld.bean.ProducerMethod;
import org.jboss.weld.bean.RIBean;
import org.jboss.weld.bootstrap.BeanDeployerEnvironment;
import org.jboss.weld.bootstrap.SpecializedBeanResolver;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.reflection.Reflections;

public class SpecializationAndEnablementRegistry
implements Service {
    private final Map<BeanManagerImpl, SpecializedBeanResolver> specializedBeanResolvers;
    private final Map<BeanManagerImpl, BeanDeployerEnvironment> environmentByManager = new ConcurrentHashMap<BeanManagerImpl, BeanDeployerEnvironment>();
    private final ConcurrentMap<Bean<?>, Set<? extends AbstractBean<?, ?>>> specializedBeans;
    private final Multiset<AbstractBean<?, ?>> specializedBeansSet = ConcurrentHashMultiset.create();

    public SpecializationAndEnablementRegistry() {
        this.specializedBeanResolvers = new MapMaker().makeComputingMap((Function)new SpecializedBeanResolverForBeanManager());
        this.specializedBeans = new MapMaker().makeComputingMap((Function)new BeansSpecializedByBean());
    }

    public Set<? extends AbstractBean<?, ?>> resolveSpecializedBeans(Bean<?> specializingBean) {
        ProducerMethod producerMethod;
        AbstractClassBean abstractClassBean;
        if (specializingBean instanceof AbstractClassBean && (abstractClassBean = (AbstractClassBean)specializingBean).isSpecializing()) {
            return (Set)this.specializedBeans.get(specializingBean);
        }
        if (specializingBean instanceof ProducerMethod && (producerMethod = (ProducerMethod)specializingBean).isSpecializing()) {
            return (Set)this.specializedBeans.get(specializingBean);
        }
        return Collections.emptySet();
    }

    public void vetoSpecializingBean(Bean<?> bean) {
        Set noLongerSpecializedBeans = (Set)this.specializedBeans.remove(bean);
        if (noLongerSpecializedBeans != null) {
            for (AbstractBean noLongerSpecializedBean : noLongerSpecializedBeans) {
                this.specializedBeansSet.remove((Object)noLongerSpecializedBean);
            }
        }
    }

    public boolean isSpecializedInAnyBeanDeployment(Bean<?> bean) {
        return this.specializedBeansSet.contains(bean);
    }

    public boolean isEnabledInAnyBeanDeployment(Bean<?> bean) {
        for (BeanManagerImpl manager : this.environmentByManager.keySet()) {
            if (!manager.isBeanEnabled(bean)) continue;
            return true;
        }
        return false;
    }

    public boolean isCandidateForLifecycleEvent(Bean<?> bean) {
        AbstractProducerBean producer;
        if (bean instanceof AbstractProducerBean && !this.isCandidateForLifecycleEvent((producer = (AbstractProducerBean)Reflections.cast(bean)).getDeclaringBean())) {
            return false;
        }
        return this.isEnabledInAnyBeanDeployment(bean) && !this.isSpecializedInAnyBeanDeployment(bean);
    }

    public void registerEnvironment(BeanManagerImpl manager, BeanDeployerEnvironment environment, boolean additionalBeanArchive) {
        if (!this.specializedBeanResolvers.isEmpty() && !additionalBeanArchive) {
            throw new IllegalStateException(this.getClass().getName() + ".registerEnvironment() must not be called after specialization resolution begins");
        }
        if (environment == null) {
            throw new IllegalArgumentException("Environment must not be null");
        }
        this.environmentByManager.put(manager, environment);
    }

    public void cleanup() {
        this.specializedBeanResolvers.clear();
        this.environmentByManager.clear();
        this.specializedBeans.clear();
        this.specializedBeansSet.clear();
    }

    public Set<AbstractBean<?, ?>> getBeansSpecializedInAnyDeployment() {
        return this.specializedBeansSet.elementSet();
    }

    public Multiset<AbstractBean<?, ?>> getBeansSpecializedInAnyDeploymentAsMultiset() {
        return Multisets.unmodifiableMultiset(this.specializedBeansSet);
    }

    private class BeansSpecializedByBean
    implements Function<Bean<?>, Set<? extends AbstractBean<?, ?>>> {
        private BeansSpecializedByBean() {
        }

        public Set<? extends AbstractBean<?, ?>> apply(Bean<?> specializingBean) {
            Set<AbstractBean> result = null;
            if (specializingBean instanceof AbstractClassBean) {
                result = this.apply((AbstractClassBean)specializingBean);
            }
            if (specializingBean instanceof ProducerMethod) {
                result = this.apply((ProducerMethod)specializingBean);
            }
            if (result != null) {
                if (SpecializationAndEnablementRegistry.this.isEnabledInAnyBeanDeployment(specializingBean)) {
                    SpecializationAndEnablementRegistry.this.specializedBeansSet.addAll(result);
                }
                return result;
            }
            throw new IllegalArgumentException("Unsupported bean type " + specializingBean);
        }

        private Set<AbstractClassBean<?>> apply(AbstractClassBean<?> bean) {
            return this.getSpecializedBeanResolver(bean).resolveSpecializedBeans(bean);
        }

        private Set<ProducerMethod<?, ?>> apply(ProducerMethod<?, ?> bean) {
            return this.getSpecializedBeanResolver(bean).resolveSpecializedBeans(bean);
        }

        private SpecializedBeanResolver getSpecializedBeanResolver(RIBean<?> bean) {
            return (SpecializedBeanResolver)SpecializationAndEnablementRegistry.this.specializedBeanResolvers.get(bean.getBeanManager());
        }
    }

    private class SpecializedBeanResolverForBeanManager
    implements Function<BeanManagerImpl, SpecializedBeanResolver> {
        private SpecializedBeanResolverForBeanManager() {
        }

        public SpecializedBeanResolver apply(BeanManagerImpl manager) {
            return new SpecializedBeanResolver(this.buildAccessibleBeanDeployerEnvironments(manager));
        }

        private Set<BeanDeployerEnvironment> buildAccessibleBeanDeployerEnvironments(BeanManagerImpl manager) {
            HashSet<BeanDeployerEnvironment> result = new HashSet<BeanDeployerEnvironment>();
            result.add((BeanDeployerEnvironment)SpecializationAndEnablementRegistry.this.environmentByManager.get(manager));
            this.buildAccessibleBeanDeployerEnvironments(manager, result);
            return result;
        }

        private void buildAccessibleBeanDeployerEnvironments(BeanManagerImpl manager, Collection<BeanDeployerEnvironment> result) {
            for (BeanManagerImpl accessibleManager : manager.getAccessibleManagers()) {
                BeanDeployerEnvironment environment = (BeanDeployerEnvironment)SpecializationAndEnablementRegistry.this.environmentByManager.get(accessibleManager);
                if (result.contains(environment)) continue;
                result.add(environment);
                this.buildAccessibleBeanDeployerEnvironments(accessibleManager, result);
            }
        }
    }
}

