/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap;

import com.google.common.collect.Iterables;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.spi.Bean;
import org.jboss.weld.bean.AbstractClassBean;
import org.jboss.weld.bean.ProducerMethod;
import org.jboss.weld.bootstrap.BeanDeployerEnvironment;

public class SpecializedBeanResolver {
    private final Set<BeanDeployerEnvironment> accessibleEnvironments;
    private static final BootstrapTransform<AbstractClassBean<?>> CLASS_BEAN_TRANSFORM = new BootstrapTransform<AbstractClassBean<?>>(){

        @Override
        public Iterable<AbstractClassBean<?>> transform(AbstractClassBean<?> bean, BeanDeployerEnvironment environment) {
            return environment.getClassBeans(bean.getBeanClass().getSuperclass());
        }
    };
    private static final BootstrapTransform<ProducerMethod<?, ?>> PRODUCER_METHOD_TRANSFORM = new BootstrapTransform<ProducerMethod<?, ?>>(){

        @Override
        public Iterable<ProducerMethod<?, ?>> transform(ProducerMethod<?, ?> bean, BeanDeployerEnvironment environment) {
            return environment.getProducerMethod(bean.getBeanClass().getSuperclass(), bean.getEnhancedAnnotated().getSignature());
        }
    };

    public SpecializedBeanResolver(Set<BeanDeployerEnvironment> accessibleEnvironments) {
        this.accessibleEnvironments = accessibleEnvironments;
    }

    private <T extends Bean<?>> Set<T> getSpecializedBeans(T bean, BootstrapTransform<T> transform) {
        HashSet beans = new HashSet();
        for (BeanDeployerEnvironment environment : this.accessibleEnvironments) {
            Iterables.addAll(beans, transform.transform(bean, environment));
        }
        return beans;
    }

    protected Set<AbstractClassBean<?>> resolveSpecializedBeans(AbstractClassBean<?> bean) {
        if (!bean.isSpecializing()) {
            throw new IllegalArgumentException(bean + " is not a specializing bean");
        }
        return this.getSpecializedBeans(bean, CLASS_BEAN_TRANSFORM);
    }

    protected Set<ProducerMethod<?, ?>> resolveSpecializedBeans(ProducerMethod<?, ?> bean) {
        if (!bean.isSpecializing()) {
            throw new IllegalArgumentException(bean + " is not a specializing bean");
        }
        return this.getSpecializedBeans(bean, PRODUCER_METHOD_TRANSFORM);
    }

    private static interface BootstrapTransform<T extends Bean<?>> {
        public Iterable<T> transform(T var1, BeanDeployerEnvironment var2);
    }
}

