/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.resources;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.collect.ComputationException;
import com.google.common.collect.MapMaker;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.enterprise.inject.spi.AnnotatedType;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotation;
import org.jboss.weld.annotated.enhanced.jlr.EnhancedAnnotatedTypeImpl;
import org.jboss.weld.annotated.enhanced.jlr.EnhancedAnnotationImpl;
import org.jboss.weld.annotated.slim.AnnotatedTypeIdentifier;
import org.jboss.weld.annotated.slim.SlimAnnotatedType;
import org.jboss.weld.annotated.slim.backed.BackedAnnotatedType;
import org.jboss.weld.annotated.slim.unbacked.UnbackedAnnotatedType;
import org.jboss.weld.bootstrap.api.BootstrapService;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.metadata.TypeStore;
import org.jboss.weld.resources.ReflectionCache;
import org.jboss.weld.resources.SharedObjectCache;
import org.jboss.weld.resources.spi.ResourceLoadingException;
import org.jboss.weld.util.AnnotatedTypes;
import org.jboss.weld.util.reflection.Reflections;
import org.slf4j.Logger;

public class ClassTransformer
implements BootstrapService {
    private static Logger log = LoggerFactory.loggerFactory().getLogger(Category.CLASS_LOADING);
    private final ConcurrentMap<Class<? extends Annotation>, UnbackedAnnotatedType<? extends Annotation>> syntheticAnnotationsAnnotatedTypes = new ConcurrentHashMap<Class<? extends Annotation>, UnbackedAnnotatedType<? extends Annotation>>();
    private final ConcurrentMap<AnnotatedTypeIdentifier, SlimAnnotatedType<?>> slimAnnotatedTypesById;
    private final ConcurrentMap<TypeHolder<?>, BackedAnnotatedType<?>> backedAnnotatedTypes;
    private final ConcurrentMap<SlimAnnotatedType<?>, EnhancedAnnotatedType<?>> enhancedAnnotatedTypes;
    private final ConcurrentMap<Class<? extends Annotation>, EnhancedAnnotation<?>> annotations;
    private final TypeStore typeStore;
    private final SharedObjectCache cache;
    private final ReflectionCache reflectionCache;

    public static ClassTransformer instance(BeanManagerImpl manager) {
        return (ClassTransformer)manager.getServices().get(ClassTransformer.class);
    }

    public ClassTransformer(TypeStore typeStore, SharedObjectCache cache, ReflectionCache reflectionCache) {
        MapMaker defaultMaker = new MapMaker();
        MapMaker weakValuesMaker = new MapMaker().weakValues();
        this.backedAnnotatedTypes = weakValuesMaker.makeComputingMap((Function)new TransformClassToBackedAnnotatedType());
        this.enhancedAnnotatedTypes = defaultMaker.makeComputingMap((Function)new TransformSlimAnnotatedTypeToEnhancedAnnotatedType());
        this.annotations = defaultMaker.makeComputingMap((Function)new TransformClassToWeldAnnotation());
        this.typeStore = typeStore;
        this.cache = cache;
        this.reflectionCache = reflectionCache;
        this.slimAnnotatedTypesById = new ConcurrentHashMap();
    }

    public <T> BackedAnnotatedType<T> getBackedAnnotatedType(Class<T> rawType, Type baseType, String bdaId) {
        try {
            return (BackedAnnotatedType)Reflections.cast(this.backedAnnotatedTypes.get(new TypeHolder(rawType, baseType, bdaId)));
        }
        catch (ComputationException e) {
            Throwable cause = e.getCause();
            if (cause instanceof NoClassDefFoundError || cause instanceof TypeNotPresentException || cause instanceof ResourceLoadingException || cause instanceof LinkageError) {
                throw new ResourceLoadingException("Error loading class " + rawType.getName(), cause);
            }
            log.trace("Error loading class '{}' : {}", (Object)rawType.getName(), (Object)cause);
            throw e;
        }
    }

    public <T> BackedAnnotatedType<T> getBackedAnnotatedType(Class<T> rawType, String bdaId) {
        return this.getBackedAnnotatedType(rawType, rawType, bdaId);
    }

    public <T> SlimAnnotatedType<T> getSlimAnnotatedTypeById(AnnotatedTypeIdentifier id) {
        return (SlimAnnotatedType)Reflections.cast(this.slimAnnotatedTypesById.get(id));
    }

    public <T> UnbackedAnnotatedType<T> getUnbackedAnnotatedType(AnnotatedType<T> source, String bdaId, String suffix) {
        UnbackedAnnotatedType<T> type = UnbackedAnnotatedType.additionalAnnotatedType(source, bdaId, suffix);
        return this.updateLookupTable(type);
    }

    public <T> UnbackedAnnotatedType<T> getUnbackedAnnotatedType(SlimAnnotatedType<T> originalType, AnnotatedType<T> source) {
        UnbackedAnnotatedType<T> type = UnbackedAnnotatedType.modifiedAnnotatedType(originalType, source);
        return this.updateLookupTable(type);
    }

    public UnbackedAnnotatedType<? extends Annotation> getSyntheticAnnotationAnnotatedType(Class<? extends Annotation> annotationType) {
        return (UnbackedAnnotatedType)this.syntheticAnnotationsAnnotatedTypes.get(annotationType);
    }

    private <T, S extends SlimAnnotatedType<T>> S updateLookupTable(S annotatedType) {
        SlimAnnotatedType<?> previousValue = this.slimAnnotatedTypesById.putIfAbsent((AnnotatedTypeIdentifier)annotatedType.getIdentifier(), annotatedType);
        if (previousValue == null) {
            return annotatedType;
        }
        return (S)((SlimAnnotatedType)Reflections.cast(previousValue));
    }

    public <T> EnhancedAnnotatedType<T> getEnhancedAnnotatedType(Class<T> rawType, String bdaId) {
        return this.getEnhancedAnnotatedType(this.getBackedAnnotatedType(rawType, bdaId));
    }

    public <T> EnhancedAnnotatedType<T> getEnhancedAnnotatedType(Class<T> rawType, Type baseType, String bdaId) {
        return this.getEnhancedAnnotatedType(this.getBackedAnnotatedType(rawType, baseType, bdaId));
    }

    public <T> EnhancedAnnotatedType<T> getEnhancedAnnotatedType(AnnotatedType<T> annotatedType, String bdaId) {
        if (annotatedType instanceof EnhancedAnnotatedType) {
            return (EnhancedAnnotatedType)Reflections.cast(annotatedType);
        }
        if (annotatedType instanceof SlimAnnotatedType) {
            return (EnhancedAnnotatedType)Reflections.cast(this.getEnhancedAnnotatedType((SlimAnnotatedType)annotatedType));
        }
        return this.getEnhancedAnnotatedType(this.getUnbackedAnnotatedType(annotatedType, bdaId, AnnotatedTypes.createTypeId(annotatedType)));
    }

    public <T> EnhancedAnnotatedType<T> getEnhancedAnnotatedType(SlimAnnotatedType<T> annotatedType) {
        return (EnhancedAnnotatedType)Reflections.cast(this.enhancedAnnotatedTypes.get(annotatedType));
    }

    public <T extends Annotation> EnhancedAnnotation<T> getEnhancedAnnotation(Class<T> clazz) {
        return (EnhancedAnnotation)this.annotations.get(clazz);
    }

    public void clearAnnotationData(Class<? extends Annotation> annotationClass) {
        this.annotations.remove(annotationClass);
    }

    public TypeStore getTypeStore() {
        return this.typeStore;
    }

    public SharedObjectCache getSharedObjectCache() {
        return this.cache;
    }

    public ReflectionCache getReflectionCache() {
        return this.reflectionCache;
    }

    public void addSyntheticAnnotation(AnnotatedType<? extends Annotation> annotation, String bdaId) {
        this.syntheticAnnotationsAnnotatedTypes.put(annotation.getJavaClass(), this.getUnbackedAnnotatedType(annotation, bdaId, "syntheticAnnotation"));
        this.clearAnnotationData(annotation.getJavaClass());
    }

    public void cleanupAfterBoot() {
        this.enhancedAnnotatedTypes.clear();
        this.annotations.clear();
        for (BackedAnnotatedType annotatedType : this.backedAnnotatedTypes.values()) {
            annotatedType.clear();
        }
        this.backedAnnotatedTypes.clear();
    }

    public void cleanup() {
        this.cleanupAfterBoot();
        this.slimAnnotatedTypesById.clear();
        this.syntheticAnnotationsAnnotatedTypes.clear();
    }

    private static final class TypeHolder<T> {
        private final String bdaId;
        private final Class<T> rawType;
        private final Type baseType;

        private TypeHolder(Class<T> rawType, Type baseType, String bdaId) {
            this.rawType = rawType;
            this.baseType = baseType;
            this.bdaId = bdaId;
        }

        public Type getBaseType() {
            return this.baseType;
        }

        public Class<T> getRawType() {
            return this.rawType;
        }

        public String getBdaId() {
            return this.bdaId;
        }

        public boolean equals(Object obj) {
            if (obj instanceof TypeHolder) {
                TypeHolder that = (TypeHolder)obj;
                return Objects.equal((Object)this.getBaseType(), (Object)that.getBaseType()) && Objects.equal((Object)this.getBdaId(), (Object)that.getBdaId());
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.getBaseType(), this.getBdaId()});
        }

        public String toString() {
            return this.getBaseType() + " from " + this.getBdaId();
        }
    }

    private class TransformSlimAnnotatedTypeToEnhancedAnnotatedType
    implements Function<SlimAnnotatedType<?>, EnhancedAnnotatedType<?>> {
        private TransformSlimAnnotatedTypeToEnhancedAnnotatedType() {
        }

        public EnhancedAnnotatedType<?> apply(SlimAnnotatedType<?> annotatedType) {
            return EnhancedAnnotatedTypeImpl.of(annotatedType, ClassTransformer.this);
        }
    }

    private class TransformClassToBackedAnnotatedType
    implements Function<TypeHolder<?>, BackedAnnotatedType<?>> {
        private TransformClassToBackedAnnotatedType() {
        }

        public BackedAnnotatedType<?> apply(TypeHolder<?> typeHolder) {
            BackedAnnotatedType<?> type = BackedAnnotatedType.of(typeHolder.getRawType(), typeHolder.getBaseType(), ClassTransformer.this.cache, ClassTransformer.this.reflectionCache, typeHolder.getBdaId());
            return (BackedAnnotatedType)ClassTransformer.this.updateLookupTable(type);
        }
    }

    private class TransformClassToWeldAnnotation
    implements Function<Class<? extends Annotation>, EnhancedAnnotation<?>> {
        private TransformClassToWeldAnnotation() {
        }

        public EnhancedAnnotation<?> apply(Class<? extends Annotation> from) {
            BackedAnnotatedType<? extends Annotation> slimAnnotatedType = (BackedAnnotatedType<? extends Annotation>)ClassTransformer.this.syntheticAnnotationsAnnotatedTypes.get(from);
            if (slimAnnotatedType == null) {
                slimAnnotatedType = ClassTransformer.this.getBackedAnnotatedType(from, AnnotatedTypeIdentifier.NULL_BDA_ID);
            }
            return EnhancedAnnotationImpl.create(slimAnnotatedType, ClassTransformer.this);
        }
    }
}

