/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.Logging;
import org.jboss.as.logging.LoggingMessages;
import org.jboss.dmr.ModelNode;

class Filters {
    public static final String ACCEPT = "accept";
    public static final String ALL = "all";
    public static final String ANY = "any";
    public static final String DENY = "deny";
    public static final String LEVELS = "levels";
    public static final String LEVEL_CHANGE = "levelChange";
    public static final String LEVEL_RANGE = "levelRange";
    public static final String MATCH = "match";
    public static final String NOT = "not";
    public static final String SUBSTITUTE = "substitute";
    public static final String SUBSTITUTE_ALL = "substituteAll";

    Filters() {
    }

    static String filterToFilterSpec(ModelNode value) throws OperationFailedException {
        if (!value.isDefined()) {
            return null;
        }
        if (value.hasDefined(CommonAttributes.ACCEPT.getName())) {
            return ACCEPT;
        }
        if (value.hasDefined(CommonAttributes.ALL.getName())) {
            StringBuilder result = new StringBuilder(ALL).append('(');
            boolean add = false;
            for (ModelNode filterValue : value.get(CommonAttributes.ALL.getName()).asList()) {
                if (add) {
                    result.append(",");
                } else {
                    add = true;
                }
                result.append(Filters.filterToFilterSpec(filterValue));
            }
            return result.append(")").toString();
        }
        if (value.hasDefined(CommonAttributes.ANY.getName())) {
            StringBuilder result = new StringBuilder(ANY).append('(');
            boolean add = false;
            for (ModelNode filterValue : value.get(CommonAttributes.ANY.getName()).asList()) {
                if (add) {
                    result.append(",");
                } else {
                    add = true;
                }
                result.append(Filters.filterToFilterSpec(filterValue));
            }
            return result.append(")").toString();
        }
        if (value.hasDefined(CommonAttributes.CHANGE_LEVEL.getName())) {
            return String.format("%s(%s)", LEVEL_CHANGE, value.get(CommonAttributes.CHANGE_LEVEL.getName()).asString());
        }
        if (value.hasDefined(CommonAttributes.DENY.getName())) {
            return DENY;
        }
        if (value.hasDefined(CommonAttributes.LEVEL.getName())) {
            return String.format("%s(%s)", LEVELS, value.get(CommonAttributes.LEVEL.getName()).asString());
        }
        if (value.hasDefined(CommonAttributes.LEVEL_RANGE_LEGACY.getName())) {
            boolean maxInclusive;
            ModelNode levelRange = value.get(CommonAttributes.LEVEL_RANGE_LEGACY.getName());
            StringBuilder result = new StringBuilder(LEVEL_RANGE);
            boolean minInclusive = levelRange.hasDefined(CommonAttributes.MIN_INCLUSIVE.getName()) && levelRange.get(CommonAttributes.MIN_INCLUSIVE.getName()).asBoolean();
            boolean bl = maxInclusive = levelRange.hasDefined(CommonAttributes.MAX_INCLUSIVE.getName()) && levelRange.get(CommonAttributes.MAX_INCLUSIVE.getName()).asBoolean();
            if (minInclusive) {
                result.append("[");
            } else {
                result.append("(");
            }
            result.append(levelRange.get(CommonAttributes.MIN_LEVEL.getName()).asString()).append(",");
            result.append(levelRange.get(CommonAttributes.MAX_LEVEL.getName()).asString());
            if (maxInclusive) {
                result.append("]");
            } else {
                result.append(")");
            }
            return result.toString();
        }
        if (value.hasDefined(CommonAttributes.MATCH.getName())) {
            return String.format("%s(%s)", MATCH, Filters.escapeString((AttributeDefinition)CommonAttributes.MATCH, value));
        }
        if (value.hasDefined(CommonAttributes.NOT.getName())) {
            return String.format("%s(%s)", NOT, Filters.filterToFilterSpec(value.get(CommonAttributes.NOT.getName())));
        }
        if (value.hasDefined(CommonAttributes.REPLACE.getName())) {
            ModelNode replace = value.get(CommonAttributes.REPLACE.getName());
            boolean replaceAll = replace.hasDefined(CommonAttributes.REPLACE_ALL.getName()) ? replace.get(CommonAttributes.REPLACE_ALL.getName()).asBoolean() : CommonAttributes.REPLACE_ALL.getDefaultValue().asBoolean();
            StringBuilder result = new StringBuilder();
            if (replaceAll) {
                result.append(SUBSTITUTE_ALL);
            } else {
                result.append(SUBSTITUTE);
            }
            return result.append("(").append(Filters.escapeString((AttributeDefinition)CommonAttributes.PATTERN, replace)).append(",").append(Filters.escapeString((AttributeDefinition)CommonAttributes.REPLACEMENT, replace)).append(")").toString();
        }
        String name = value.hasDefined(CommonAttributes.FILTER.getName()) ? value.get(CommonAttributes.FILTER.getName()).asString() : value.asString();
        throw Logging.createOperationFailure(LoggingMessages.MESSAGES.invalidFilter(name));
    }

    static ModelNode filterSpecToFilter(String value) {
        ModelNode filter = new ModelNode(CommonAttributes.FILTER.getName()).setEmptyObject();
        Iterator<String> iterator = Filters.tokens(value).iterator();
        Filters.parseFilterExpression(iterator, filter, true);
        return filter;
    }

    private static void parseFilterExpression(Iterator<String> iterator, ModelNode model, boolean outermost) {
        if (!iterator.hasNext()) {
            if (outermost) {
                model.setEmptyObject();
                return;
            }
            throw LoggingMessages.MESSAGES.unexpectedEnd();
        }
        String token = iterator.next();
        if (ACCEPT.equals(token)) {
            Filters.set((AttributeDefinition)CommonAttributes.ACCEPT, model, true);
        } else if (DENY.equals(token)) {
            Filters.set((AttributeDefinition)CommonAttributes.DENY, model, true);
        } else if (NOT.equals(token)) {
            Filters.expect("(", iterator);
            Filters.parseFilterExpression(iterator, model.get(CommonAttributes.NOT.getName()), false);
            Filters.expect(")", iterator);
        } else if (ALL.equals(token)) {
            Filters.expect("(", iterator);
            do {
                ModelNode m = model.get(CommonAttributes.ALL.getName());
                Filters.parseFilterExpression(iterator, m, false);
            } while (Filters.expect(",", ")", iterator));
        } else if (ANY.equals(token)) {
            Filters.expect("(", iterator);
            do {
                ModelNode m = model.get(CommonAttributes.ANY.getName());
                Filters.parseFilterExpression(iterator, m, false);
            } while (Filters.expect(",", ")", iterator));
        } else if (LEVEL_CHANGE.equals(token)) {
            Filters.expect("(", iterator);
            String levelName = Filters.expectName(iterator);
            Filters.set((AttributeDefinition)CommonAttributes.CHANGE_LEVEL, model, levelName);
            Filters.expect(")", iterator);
        } else if (LEVELS.equals(token)) {
            Filters.expect("(", iterator);
            HashSet<String> levels = new HashSet<String>();
            do {
                levels.add(Filters.expectName(iterator));
            } while (Filters.expect(",", ")", iterator));
            if (levels.iterator().hasNext()) {
                Filters.set((AttributeDefinition)CommonAttributes.LEVEL, model, (String)levels.iterator().next());
            }
        } else if (LEVEL_RANGE.equals(token)) {
            ModelNode levelRange = model.get(CommonAttributes.LEVEL_RANGE_LEGACY.getName());
            boolean minInclusive = Filters.expect("[", "(", iterator);
            if (minInclusive) {
                Filters.set((AttributeDefinition)CommonAttributes.MIN_INCLUSIVE, levelRange, minInclusive);
            }
            String minLevel = Filters.expectName(iterator);
            Filters.set((AttributeDefinition)CommonAttributes.MIN_LEVEL, levelRange, minLevel);
            Filters.expect(",", iterator);
            String maxLevel = Filters.expectName(iterator);
            Filters.set((AttributeDefinition)CommonAttributes.MAX_LEVEL, levelRange, maxLevel);
            boolean maxInclusive = Filters.expect("]", ")", iterator);
            if (maxInclusive) {
                Filters.set((AttributeDefinition)CommonAttributes.MAX_INCLUSIVE, levelRange, maxInclusive);
            }
        } else if (MATCH.equals(token)) {
            Filters.expect("(", iterator);
            String pattern = Filters.expectString(iterator);
            Filters.set((AttributeDefinition)CommonAttributes.MATCH, model, pattern);
            Filters.expect(")", iterator);
        } else if (SUBSTITUTE.equals(token)) {
            ModelNode substitute = model.get(CommonAttributes.REPLACE.getName());
            substitute.get(CommonAttributes.REPLACE_ALL.getName()).set(false);
            Filters.expect("(", iterator);
            String pattern = Filters.expectString(iterator);
            Filters.set((AttributeDefinition)CommonAttributes.PATTERN, substitute, pattern);
            Filters.expect(",", iterator);
            String replacement = Filters.expectString(iterator);
            Filters.set((AttributeDefinition)CommonAttributes.REPLACEMENT, substitute, replacement);
            Filters.expect(")", iterator);
        } else if (SUBSTITUTE_ALL.equals(token)) {
            ModelNode substitute = model.get(CommonAttributes.REPLACE.getName());
            substitute.get(CommonAttributes.REPLACE_ALL.getName()).set(true);
            Filters.expect("(", iterator);
            String pattern = Filters.expectString(iterator);
            Filters.set((AttributeDefinition)CommonAttributes.PATTERN, substitute, pattern);
            Filters.expect(",", iterator);
            String replacement = Filters.expectString(iterator);
            Filters.set((AttributeDefinition)CommonAttributes.REPLACEMENT, substitute, replacement);
            Filters.expect(")", iterator);
        } else {
            String name = Filters.expectName(iterator);
            throw LoggingMessages.MESSAGES.filterNotFound(name);
        }
    }

    private static String expectName(Iterator<String> iterator) {
        String next;
        if (iterator.hasNext() && Character.isJavaIdentifierStart((next = iterator.next()).codePointAt(0))) {
            return next;
        }
        throw LoggingMessages.MESSAGES.expectedIdentifier();
    }

    private static String expectString(Iterator<String> iterator) {
        String next;
        if (iterator.hasNext() && (next = iterator.next()).codePointAt(0) == 34) {
            return next.substring(1);
        }
        throw LoggingMessages.MESSAGES.expectedString();
    }

    private static boolean expect(String trueToken, String falseToken, Iterator<String> iterator) {
        boolean result;
        String next;
        boolean hasNext = iterator.hasNext();
        String string = next = hasNext ? iterator.next() : null;
        if (!hasNext || !(result = trueToken.equals(next)) && !falseToken.equals(next)) {
            throw LoggingMessages.MESSAGES.expected(trueToken, falseToken);
        }
        return result;
    }

    private static void expect(String token, Iterator<String> iterator) {
        if (!iterator.hasNext() || !token.equals(iterator.next())) {
            throw LoggingMessages.MESSAGES.expected(token);
        }
    }

    private static void set(AttributeDefinition attribute, ModelNode model, String value) {
        Filters.set(attribute.getName(), model, value);
    }

    private static void set(AttributeDefinition attribute, ModelNode model, boolean value) {
        Filters.set(attribute.getName(), model, value);
    }

    private static void set(String name, ModelNode model, String value) {
        model.get(name).set(value);
    }

    private static void set(String name, ModelNode model, boolean value) {
        model.get(name).set(value);
    }

    private static List<String> tokens(String source) {
        ArrayList<String> tokens = new ArrayList<String>();
        int length = source.length();
        int idx = 0;
        while (idx < length) {
            int start;
            block16: {
                int ch = source.codePointAt(idx);
                if (Character.isWhitespace(ch)) {
                    ch = source.codePointAt(idx);
                    idx = source.offsetByCodePoints(idx, 1);
                    continue;
                }
                if (Character.isJavaIdentifierStart(ch)) {
                    start = idx;
                    while ((idx = source.offsetByCodePoints(idx, 1)) < length && Character.isJavaIdentifierPart(ch = source.codePointAt(idx))) {
                    }
                    tokens.add(source.substring(start, idx));
                    continue;
                }
                if (ch != 34) break block16;
                StringBuilder b = new StringBuilder();
                b.append('\"');
                idx = source.offsetByCodePoints(idx, 1);
                while (idx < length && (ch = source.codePointAt(idx)) != 34) {
                    block18: {
                        block17: {
                            ch = source.codePointAt(idx);
                            if (ch != 92) break block17;
                            if ((idx = source.offsetByCodePoints(idx, 1)) == length) {
                                throw LoggingMessages.MESSAGES.truncatedFilterExpression();
                            }
                            ch = source.codePointAt(idx);
                            switch (ch) {
                                case 92: {
                                    b.append('\\');
                                    break block18;
                                }
                                case 39: {
                                    b.append('\'');
                                    break block18;
                                }
                                case 34: {
                                    b.append('\"');
                                    break block18;
                                }
                                case 98: {
                                    b.append('\b');
                                    break block18;
                                }
                                case 102: {
                                    b.append('\f');
                                    break block18;
                                }
                                case 110: {
                                    b.append('\n');
                                    break block18;
                                }
                                case 114: {
                                    b.append('\r');
                                    break block18;
                                }
                                case 116: {
                                    b.append('\t');
                                    break block18;
                                }
                                default: {
                                    throw LoggingMessages.MESSAGES.invalidEscapeFoundInFilterExpression();
                                }
                            }
                        }
                        b.appendCodePoint(ch);
                    }
                    idx = source.offsetByCodePoints(idx, 1);
                }
                idx = source.offsetByCodePoints(idx, 1);
                tokens.add(b.toString());
                continue;
            }
            start = idx;
            idx = source.offsetByCodePoints(idx, 1);
            tokens.add(source.substring(start, idx));
        }
        return tokens;
    }

    private static String escapeString(AttributeDefinition attribute, ModelNode value) throws OperationFailedException {
        return String.format("\"%s\"", value.get(attribute.getName()).asString().replace("\\", "\\\\"));
    }
}

