/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.client;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.InvalidClientIDException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.jms.TransactionInProgressException;
import javax.transaction.xa.XAResource;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.client.ClientConsumer;
import org.hornetq.api.core.client.ClientProducer;
import org.hornetq.api.core.client.ClientSession;
import org.hornetq.core.filter.impl.FilterParser;
import org.hornetq.core.filter.impl.Identifier;
import org.hornetq.core.filter.impl.ParseException;
import org.hornetq.jms.client.HornetQBytesMessage;
import org.hornetq.jms.client.HornetQConnection;
import org.hornetq.jms.client.HornetQDestination;
import org.hornetq.jms.client.HornetQJMSClientBundle;
import org.hornetq.jms.client.HornetQMapMessage;
import org.hornetq.jms.client.HornetQMessage;
import org.hornetq.jms.client.HornetQMessageConsumer;
import org.hornetq.jms.client.HornetQMessageProducer;
import org.hornetq.jms.client.HornetQObjectMessage;
import org.hornetq.jms.client.HornetQQueue;
import org.hornetq.jms.client.HornetQQueueBrowser;
import org.hornetq.jms.client.HornetQStreamMessage;
import org.hornetq.jms.client.HornetQTemporaryQueue;
import org.hornetq.jms.client.HornetQTemporaryTopic;
import org.hornetq.jms.client.HornetQTextMessage;
import org.hornetq.jms.client.HornetQTopic;
import org.hornetq.jms.client.JMSExceptionHelper;
import org.hornetq.jms.client.SelectorTranslator;

public class HornetQSession
implements QueueSession,
TopicSession {
    public static final int TYPE_GENERIC_SESSION = 0;
    public static final int TYPE_QUEUE_SESSION = 1;
    public static final int TYPE_TOPIC_SESSION = 2;
    private static SimpleString REJECTING_FILTER = new SimpleString("_HQX=-1");
    private final HornetQConnection connection;
    private final ClientSession session;
    private final int sessionType;
    private final int ackMode;
    private final boolean transacted;
    private final boolean xa;
    private boolean recoverCalled;
    private final Set<HornetQMessageConsumer> consumers = new HashSet<HornetQMessageConsumer>();

    protected HornetQSession(HornetQConnection connection, boolean transacted, boolean xa, int ackMode, ClientSession session, int sessionType) {
        this.connection = connection;
        this.ackMode = ackMode;
        this.session = session;
        this.sessionType = sessionType;
        this.transacted = transacted;
        this.xa = xa;
    }

    @Override
    public BytesMessage createBytesMessage() throws JMSException {
        this.checkClosed();
        return new HornetQBytesMessage(this.session);
    }

    @Override
    public MapMessage createMapMessage() throws JMSException {
        this.checkClosed();
        return new HornetQMapMessage(this.session);
    }

    @Override
    public Message createMessage() throws JMSException {
        this.checkClosed();
        return new HornetQMessage(this.session);
    }

    @Override
    public ObjectMessage createObjectMessage() throws JMSException {
        this.checkClosed();
        return new HornetQObjectMessage(this.session);
    }

    @Override
    public ObjectMessage createObjectMessage(Serializable object) throws JMSException {
        this.checkClosed();
        HornetQObjectMessage msg = new HornetQObjectMessage(this.session);
        msg.setObject(object);
        return msg;
    }

    @Override
    public StreamMessage createStreamMessage() throws JMSException {
        this.checkClosed();
        return new HornetQStreamMessage(this.session);
    }

    @Override
    public TextMessage createTextMessage() throws JMSException {
        this.checkClosed();
        HornetQTextMessage msg = new HornetQTextMessage(this.session);
        msg.setText(null);
        return msg;
    }

    @Override
    public TextMessage createTextMessage(String text) throws JMSException {
        this.checkClosed();
        HornetQTextMessage msg = new HornetQTextMessage(this.session);
        msg.setText(text);
        return msg;
    }

    @Override
    public boolean getTransacted() throws JMSException {
        this.checkClosed();
        return this.transacted;
    }

    @Override
    public int getAcknowledgeMode() throws JMSException {
        this.checkClosed();
        return this.ackMode;
    }

    public boolean isXA() {
        return this.xa;
    }

    @Override
    public void commit() throws JMSException {
        if (!this.transacted) {
            throw new IllegalStateException("Cannot commit a non-transacted session");
        }
        if (this.xa) {
            throw new TransactionInProgressException("Cannot call commit on an XA session");
        }
        try {
            this.session.commit();
        }
        catch (HornetQException e) {
            throw JMSExceptionHelper.convertFromHornetQException(e);
        }
    }

    @Override
    public void rollback() throws JMSException {
        if (!this.transacted) {
            throw new IllegalStateException("Cannot rollback a non-transacted session");
        }
        if (this.xa) {
            throw new TransactionInProgressException("Cannot call rollback on an XA session");
        }
        try {
            this.session.rollback();
        }
        catch (HornetQException e) {
            throw JMSExceptionHelper.convertFromHornetQException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws JMSException {
        HornetQConnection hornetQConnection = this.connection;
        synchronized (hornetQConnection) {
            try {
                for (HornetQMessageConsumer cons : new HashSet<HornetQMessageConsumer>(this.consumers)) {
                    cons.close();
                }
                this.session.close();
                this.connection.removeSession(this);
            }
            catch (HornetQException e) {
                throw JMSExceptionHelper.convertFromHornetQException(e);
            }
        }
    }

    @Override
    public void recover() throws JMSException {
        if (this.transacted) {
            throw new IllegalStateException("Cannot recover a transacted session");
        }
        try {
            this.session.rollback(true);
        }
        catch (HornetQException e) {
            throw JMSExceptionHelper.convertFromHornetQException(e);
        }
        this.recoverCalled = true;
    }

    @Override
    public MessageListener getMessageListener() throws JMSException {
        this.checkClosed();
        return null;
    }

    @Override
    public void setMessageListener(MessageListener listener) throws JMSException {
        this.checkClosed();
    }

    @Override
    public void run() {
    }

    @Override
    public MessageProducer createProducer(Destination destination) throws JMSException {
        if (destination != null && !(destination instanceof HornetQDestination)) {
            throw new InvalidDestinationException("Not a HornetQ Destination:" + destination);
        }
        try {
            ClientSession.BindingQuery response;
            HornetQDestination jbd = (HornetQDestination)destination;
            if (jbd != null && !(response = this.session.bindingQuery(jbd.getSimpleAddress())).isExists()) {
                throw new InvalidDestinationException("Destination " + jbd.getName() + " does not exist");
            }
            ClientProducer producer = this.session.createProducer(jbd == null ? null : jbd.getSimpleAddress());
            return new HornetQMessageProducer(this.connection, producer, jbd, this.session);
        }
        catch (HornetQException e) {
            throw JMSExceptionHelper.convertFromHornetQException(e);
        }
    }

    @Override
    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        return this.createConsumer(destination, null, false);
    }

    @Override
    public MessageConsumer createConsumer(Destination destination, String messageSelector) throws JMSException {
        return this.createConsumer(destination, messageSelector, false);
    }

    @Override
    public MessageConsumer createConsumer(Destination destination, String messageSelector, boolean noLocal) throws JMSException {
        if (destination == null) {
            throw new InvalidDestinationException("Cannot create a consumer with a null destination");
        }
        if (!(destination instanceof HornetQDestination)) {
            throw new InvalidDestinationException("Not a HornetQDestination:" + destination);
        }
        HornetQDestination jbdest = (HornetQDestination)destination;
        if (jbdest.isTemporary() && !this.connection.containsTemporaryQueue(jbdest.getSimpleAddress())) {
            throw new JMSException("Can not create consumer for temporary destination " + destination + " from another JMS connection");
        }
        HornetQMessageConsumer consumer = this.createConsumer(jbdest, null, messageSelector, noLocal);
        return consumer;
    }

    @Override
    public Queue createQueue(String queueName) throws JMSException {
        if (this.sessionType == 2) {
            throw new IllegalStateException("Cannot create a queue using a TopicSession");
        }
        try {
            HornetQQueue queue = this.lookupQueue(queueName, false);
            if (queue == null) {
                queue = this.lookupQueue(queueName, true);
            }
            if (queue == null) {
                throw new JMSException("There is no queue with name " + queueName);
            }
            return queue;
        }
        catch (HornetQException e) {
            throw JMSExceptionHelper.convertFromHornetQException(e);
        }
    }

    @Override
    public Topic createTopic(String topicName) throws JMSException {
        if (this.sessionType == 1) {
            throw new IllegalStateException("Cannot create a topic on a QueueSession");
        }
        try {
            HornetQTopic topic = this.lookupTopic(topicName, false);
            if (topic == null) {
                topic = this.lookupTopic(topicName, true);
            }
            if (topic == null) {
                throw new JMSException("There is no topic with name " + topicName);
            }
            return topic;
        }
        catch (HornetQException e) {
            throw JMSExceptionHelper.convertFromHornetQException(e);
        }
    }

    @Override
    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        return this.createDurableSubscriber(topic, name, null, false);
    }

    @Override
    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        HornetQDestination jbdest;
        if (this.sessionType == 1) {
            throw new IllegalStateException("Cannot create a durable subscriber on a QueueSession");
        }
        if (topic == null) {
            throw new InvalidDestinationException("Cannot create a durable subscriber on a null topic");
        }
        if (!(topic instanceof HornetQDestination)) {
            throw new InvalidDestinationException("Not a HornetQTopic:" + topic);
        }
        if ("".equals(messageSelector)) {
            messageSelector = null;
        }
        if ((jbdest = (HornetQDestination)((Object)topic)).isQueue()) {
            throw new InvalidDestinationException("Cannot create a subscriber on a queue");
        }
        return this.createConsumer(jbdest, name, messageSelector, noLocal);
    }

    private HornetQMessageConsumer createConsumer(HornetQDestination dest, String subscriptionName, String selectorString, boolean noLocal) throws JMSException {
        try {
            ClientConsumer consumer;
            ClientSession.BindingQuery response;
            String string = selectorString = "".equals(selectorString) ? null : selectorString;
            if (noLocal) {
                this.connection.setHasNoLocal();
                String filter = this.connection.getClientID() != null ? HornetQConnection.CONNECTION_ID_PROPERTY_NAME.toString() + "<>'" + this.connection.getClientID() + "'" : HornetQConnection.CONNECTION_ID_PROPERTY_NAME.toString() + "<>'" + this.connection.getUID() + "'";
                selectorString = selectorString != null ? selectorString + " AND " + filter : filter;
            }
            SimpleString coreFilterString = null;
            if (selectorString != null) {
                coreFilterString = new SimpleString(SelectorTranslator.convertToHornetQFilterString(selectorString));
            }
            SimpleString autoDeleteQueueName = null;
            if (dest.isQueue()) {
                response = this.session.bindingQuery(dest.getSimpleAddress());
                if (!response.isExists()) {
                    throw new InvalidDestinationException("Queue " + dest.getName() + " does not exist");
                }
                consumer = this.session.createConsumer(dest.getSimpleAddress(), coreFilterString, false);
            } else {
                response = this.session.bindingQuery(dest.getSimpleAddress());
                if (!response.isExists()) {
                    throw new InvalidDestinationException("Topic " + dest.getName() + " does not exist");
                }
                if (subscriptionName == null) {
                    SimpleString queueName = new SimpleString(UUID.randomUUID().toString());
                    this.session.createTemporaryQueue(dest.getSimpleAddress(), queueName, coreFilterString);
                    consumer = this.session.createConsumer(queueName, null, false);
                    autoDeleteQueueName = queueName;
                } else {
                    if (this.connection.getClientID() == null) {
                        throw new InvalidClientIDException("Cannot create durable subscription - client ID has not been set");
                    }
                    if (dest.isTemporary()) {
                        throw new InvalidDestinationException("Cannot create a durable subscription on a temporary topic");
                    }
                    SimpleString queueName = new SimpleString(HornetQDestination.createQueueNameForDurableSubscription(this.connection.getClientID(), subscriptionName));
                    ClientSession.QueueQuery subResponse = this.session.queueQuery(queueName);
                    if (!subResponse.isExists()) {
                        this.session.createQueue(dest.getSimpleAddress(), queueName, coreFilterString, true);
                    } else {
                        boolean topicChanged;
                        if (subResponse.getConsumerCount() > 0) {
                            throw new IllegalStateException("Cannot create a subscriber on the durable subscription since it already has subscriber(s)");
                        }
                        SimpleString oldFilterString = subResponse.getFilterString();
                        boolean selectorChanged = coreFilterString == null && oldFilterString != null || oldFilterString == null && coreFilterString != null || oldFilterString != null && coreFilterString != null && !oldFilterString.equals(coreFilterString);
                        SimpleString oldTopicName = subResponse.getAddress();
                        boolean bl = topicChanged = !oldTopicName.equals(dest.getSimpleAddress());
                        if (selectorChanged || topicChanged) {
                            this.session.deleteQueue(queueName);
                            this.session.createQueue(dest.getSimpleAddress(), queueName, coreFilterString, true);
                        }
                    }
                    consumer = this.session.createConsumer(queueName, null, false);
                }
            }
            HornetQMessageConsumer jbc = new HornetQMessageConsumer(this, consumer, noLocal, dest, selectorString, autoDeleteQueueName);
            this.consumers.add(jbc);
            return jbc;
        }
        catch (HornetQException e) {
            throw JMSExceptionHelper.convertFromHornetQException(e);
        }
    }

    @Override
    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        return this.createBrowser(queue, null);
    }

    @Override
    public QueueBrowser createBrowser(Queue queue, String filterString) throws JMSException {
        if (this.sessionType == 2) {
            throw new IllegalStateException("Cannot create a browser on a TopicSession");
        }
        if (queue == null) {
            throw new InvalidDestinationException("Cannot create a browser with a null queue");
        }
        if (!(queue instanceof HornetQDestination)) {
            throw new InvalidDestinationException("Not a HornetQQueue:" + queue);
        }
        if ("".equals(filterString)) {
            filterString = null;
        }
        try {
            if (filterString != null) {
                new FilterParser().parse(new SimpleString(filterString.trim()), new HashMap<SimpleString, Identifier>());
            }
        }
        catch (ParseException e) {
            throw JMSExceptionHelper.convertFromHornetQException(HornetQJMSClientBundle.BUNDLE.invalidFilter(e, new SimpleString(filterString)));
        }
        HornetQDestination jbq = (HornetQDestination)((Object)queue);
        if (!jbq.isQueue()) {
            throw new InvalidDestinationException("Cannot create a browser on a topic");
        }
        try {
            ClientSession.BindingQuery message = this.session.bindingQuery(new SimpleString(jbq.getAddress()));
            if (!message.isExists()) {
                throw new InvalidDestinationException(jbq.getAddress() + " does not exist");
            }
        }
        catch (HornetQException e) {
            throw JMSExceptionHelper.convertFromHornetQException(e);
        }
        return new HornetQQueueBrowser((HornetQQueue)jbq, filterString, this.session);
    }

    @Override
    public TemporaryQueue createTemporaryQueue() throws JMSException {
        if (this.sessionType == 2) {
            throw new IllegalStateException("Cannot create a temporary queue using a TopicSession");
        }
        try {
            HornetQTemporaryQueue queue = HornetQDestination.createTemporaryQueue(this);
            SimpleString simpleAddress = queue.getSimpleAddress();
            this.session.createTemporaryQueue(simpleAddress, simpleAddress);
            this.connection.addTemporaryQueue(simpleAddress);
            return queue;
        }
        catch (HornetQException e) {
            throw JMSExceptionHelper.convertFromHornetQException(e);
        }
    }

    @Override
    public TemporaryTopic createTemporaryTopic() throws JMSException {
        if (this.sessionType == 1) {
            throw new IllegalStateException("Cannot create a temporary topic on a QueueSession");
        }
        try {
            HornetQTemporaryTopic topic = HornetQDestination.createTemporaryTopic(this);
            SimpleString simpleAddress = topic.getSimpleAddress();
            this.session.createTemporaryQueue(simpleAddress, simpleAddress, REJECTING_FILTER);
            this.connection.addTemporaryQueue(simpleAddress);
            return topic;
        }
        catch (HornetQException e) {
            throw JMSExceptionHelper.convertFromHornetQException(e);
        }
    }

    @Override
    public void unsubscribe(String name) throws JMSException {
        if (this.sessionType == 1) {
            throw new IllegalStateException("Cannot unsubscribe using a QueueSession");
        }
        SimpleString queueName = new SimpleString(HornetQDestination.createQueueNameForDurableSubscription(this.connection.getClientID(), name));
        try {
            ClientSession.QueueQuery response = this.session.queueQuery(queueName);
            if (!response.isExists()) {
                throw new InvalidDestinationException("Cannot unsubscribe, subscription with name " + name + " does not exist");
            }
            if (response.getConsumerCount() != 0) {
                throw new IllegalStateException("Cannot unsubscribe durable subscription " + name + " since it has active subscribers");
            }
            this.session.deleteQueue(queueName);
        }
        catch (HornetQException e) {
            throw JMSExceptionHelper.convertFromHornetQException(e);
        }
    }

    public Session getSession() throws JMSException {
        if (!this.xa) {
            throw new IllegalStateException("Isn't an XASession");
        }
        return this;
    }

    public XAResource getXAResource() {
        return this.session.getXAResource();
    }

    @Override
    public QueueReceiver createReceiver(Queue queue, String messageSelector) throws JMSException {
        return (QueueReceiver)this.createConsumer(queue, messageSelector);
    }

    @Override
    public QueueReceiver createReceiver(Queue queue) throws JMSException {
        return (QueueReceiver)this.createConsumer(queue);
    }

    @Override
    public QueueSender createSender(Queue queue) throws JMSException {
        return (QueueSender)this.createProducer(queue);
    }

    public QueueSession getQueueSession() throws JMSException {
        return (QueueSession)this.getSession();
    }

    @Override
    public TopicPublisher createPublisher(Topic topic) throws JMSException {
        return (TopicPublisher)this.createProducer(topic);
    }

    @Override
    public TopicSubscriber createSubscriber(Topic topic, String messageSelector, boolean noLocal) throws JMSException {
        return (TopicSubscriber)this.createConsumer(topic, messageSelector, noLocal);
    }

    @Override
    public TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        return (TopicSubscriber)this.createConsumer(topic);
    }

    public TopicSession getTopicSession() throws JMSException {
        return (TopicSession)this.getSession();
    }

    public String toString() {
        return "HornetQSession->" + this.session;
    }

    public ClientSession getCoreSession() {
        return this.session;
    }

    public boolean isRecoverCalled() {
        return this.recoverCalled;
    }

    public void setRecoverCalled(boolean recoverCalled) {
        this.recoverCalled = recoverCalled;
    }

    public void deleteTemporaryTopic(HornetQDestination tempTopic) throws JMSException {
        if (!tempTopic.isTemporary()) {
            throw new InvalidDestinationException("Not a temporary topic " + tempTopic);
        }
        try {
            ClientSession.BindingQuery response = this.session.bindingQuery(tempTopic.getSimpleAddress());
            if (!response.isExists()) {
                throw new InvalidDestinationException("Cannot delete temporary topic " + tempTopic.getName() + " does not exist");
            }
            if (response.getQueueNames().size() > 1) {
                throw new IllegalStateException("Cannot delete temporary topic " + tempTopic.getName() + " since it has subscribers");
            }
            SimpleString address = tempTopic.getSimpleAddress();
            this.session.deleteQueue(address);
            this.connection.removeTemporaryQueue(address);
        }
        catch (HornetQException e) {
            throw JMSExceptionHelper.convertFromHornetQException(e);
        }
    }

    public void deleteTemporaryQueue(HornetQDestination tempQueue) throws JMSException {
        if (!tempQueue.isTemporary()) {
            throw new InvalidDestinationException("Not a temporary queue " + tempQueue);
        }
        try {
            ClientSession.QueueQuery response = this.session.queueQuery(tempQueue.getSimpleAddress());
            if (!response.isExists()) {
                throw new InvalidDestinationException("Cannot delete temporary queue " + tempQueue.getName() + " does not exist");
            }
            if (response.getConsumerCount() > 0) {
                throw new IllegalStateException("Cannot delete temporary queue " + tempQueue.getName() + " since it has subscribers");
            }
            SimpleString address = tempQueue.getSimpleAddress();
            this.session.deleteQueue(address);
            this.connection.removeTemporaryQueue(address);
        }
        catch (HornetQException e) {
            throw JMSExceptionHelper.convertFromHornetQException(e);
        }
    }

    public void start() throws JMSException {
        try {
            this.session.start();
        }
        catch (HornetQException e) {
            throw JMSExceptionHelper.convertFromHornetQException(e);
        }
    }

    public void stop() throws JMSException {
        try {
            this.session.stop();
        }
        catch (HornetQException e) {
            throw JMSExceptionHelper.convertFromHornetQException(e);
        }
    }

    public void removeConsumer(HornetQMessageConsumer consumer) {
        this.consumers.remove(consumer);
    }

    void deleteQueue(SimpleString queueName) throws JMSException {
        if (!this.session.isClosed()) {
            try {
                this.session.deleteQueue(queueName);
            }
            catch (HornetQException hornetQException) {
                // empty catch block
            }
        }
    }

    private void checkClosed() throws JMSException {
        if (this.session.isClosed()) {
            throw new IllegalStateException("Session is closed");
        }
    }

    private HornetQQueue lookupQueue(String queueName, boolean isTemporary) throws HornetQException {
        HornetQQueue queue = isTemporary ? HornetQDestination.createTemporaryQueue(queueName) : HornetQDestination.createQueue(queueName);
        ClientSession.QueueQuery response = this.session.queueQuery(queue.getSimpleAddress());
        if (response.isExists()) {
            return queue;
        }
        return null;
    }

    private HornetQTopic lookupTopic(String topicName, boolean isTemporary) throws HornetQException {
        HornetQTopic topic = isTemporary ? HornetQDestination.createTemporaryTopic(topicName) : HornetQDestination.createTopic(topicName);
        ClientSession.BindingQuery query = this.session.bindingQuery(topic.getSimpleAddress());
        if (!query.isExists()) {
            return null;
        }
        return topic;
    }
}

